/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.model.AddTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.AddTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailAccessNotEnabledException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailArnInvalidException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.CloudWatchLogsDeliveryUnavailableException;
import software.amazon.awssdk.services.cloudtrail.model.CreateTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusResponse;
import software.amazon.awssdk.services.cloudtrail.model.InsightNotEnabledException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientDependencyServiceAccessPermissionException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientEncryptionPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientS3BucketPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientSnsTopicPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidCloudWatchLogsLogGroupArnException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidCloudWatchLogsRoleArnException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventCategoryException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventSelectorsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidHomeRegionException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidInsightSelectorsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidKmsKeyIdException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidLookupAttributesException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidMaxResultsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidNextTokenException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidS3BucketNameException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidS3PrefixException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidSnsTopicNameException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTagParameterException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTokenException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTrailNameException;
import software.amazon.awssdk.services.cloudtrail.model.KmsException;
import software.amazon.awssdk.services.cloudtrail.model.KmsKeyNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse;
import software.amazon.awssdk.services.cloudtrail.model.MaximumNumberOfTrailsExceededException;
import software.amazon.awssdk.services.cloudtrail.model.NotOrganizationMasterAccountException;
import software.amazon.awssdk.services.cloudtrail.model.OperationNotPermittedException;
import software.amazon.awssdk.services.cloudtrail.model.OrganizationNotInAllFeaturesModeException;
import software.amazon.awssdk.services.cloudtrail.model.OrganizationsNotInUseException;
import software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.RemoveTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.RemoveTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ResourceTypeNotSupportedException;
import software.amazon.awssdk.services.cloudtrail.model.S3BucketDoesNotExistException;
import software.amazon.awssdk.services.cloudtrail.model.StartLoggingRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartLoggingResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopLoggingRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopLoggingResponse;
import software.amazon.awssdk.services.cloudtrail.model.TagsLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.TrailAlreadyExistsException;
import software.amazon.awssdk.services.cloudtrail.model.TrailNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.TrailNotProvidedException;
import software.amazon.awssdk.services.cloudtrail.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cloudtrail.model.UpdateTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateTrailResponse;
import software.amazon.awssdk.services.cloudtrail.paginators.ListPublicKeysIterable;
import software.amazon.awssdk.services.cloudtrail.paginators.ListTagsIterable;
import software.amazon.awssdk.services.cloudtrail.paginators.ListTrailsIterable;
import software.amazon.awssdk.services.cloudtrail.paginators.LookupEventsIterable;
import software.amazon.awssdk.services.cloudtrail.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DescribeTrailsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetEventSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetInsightSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetTrailStatusRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListPublicKeysRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListTrailsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.LookupEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutEventSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutInsightSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartLoggingRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StopLoggingRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateTrailRequestMarshaller;

@SdkInternalApi
final class DefaultCloudTrailClient
implements CloudTrailClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudTrailClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "cloudtrail";
    }

    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws ResourceNotFoundException, CloudTrailArnInvalidException, ResourceTypeNotSupportedException, TagsLimitExceededException, InvalidTrailNameException, InvalidTagParameterException, UnsupportedOperationException, OperationNotPermittedException, NotOrganizationMasterAccountException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AddTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsRequest).withMarshaller((Marshaller)new AddTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateTrailResponse createTrail(CreateTrailRequest createTrailRequest) throws MaximumNumberOfTrailsExceededException, TrailAlreadyExistsException, S3BucketDoesNotExistException, InsufficientS3BucketPolicyException, InsufficientSnsTopicPolicyException, InsufficientEncryptionPolicyException, InvalidS3BucketNameException, InvalidS3PrefixException, InvalidSnsTopicNameException, InvalidKmsKeyIdException, InvalidTrailNameException, TrailNotProvidedException, InvalidParameterCombinationException, KmsKeyNotFoundException, KmsException, InvalidCloudWatchLogsLogGroupArnException, InvalidCloudWatchLogsRoleArnException, CloudWatchLogsDeliveryUnavailableException, InvalidTagParameterException, UnsupportedOperationException, OperationNotPermittedException, CloudTrailAccessNotEnabledException, InsufficientDependencyServiceAccessPermissionException, NotOrganizationMasterAccountException, OrganizationsNotInUseException, OrganizationNotInAllFeaturesModeException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTrailResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateTrailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTrailRequest).withMarshaller((Marshaller)new CreateTrailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteTrailResponse deleteTrail(DeleteTrailRequest deleteTrailRequest) throws TrailNotFoundException, InvalidTrailNameException, InvalidHomeRegionException, UnsupportedOperationException, OperationNotPermittedException, NotOrganizationMasterAccountException, InsufficientDependencyServiceAccessPermissionException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTrailResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteTrailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTrailRequest).withMarshaller((Marshaller)new DeleteTrailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeTrailsResponse describeTrails(DescribeTrailsRequest describeTrailsRequest) throws UnsupportedOperationException, OperationNotPermittedException, InvalidTrailNameException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeTrailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrails").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTrailsRequest).withMarshaller((Marshaller)new DescribeTrailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetEventSelectorsResponse getEventSelectors(GetEventSelectorsRequest getEventSelectorsRequest) throws TrailNotFoundException, InvalidTrailNameException, UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEventSelectorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetEventSelectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEventSelectors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEventSelectorsRequest).withMarshaller((Marshaller)new GetEventSelectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetInsightSelectorsResponse getInsightSelectors(GetInsightSelectorsRequest getInsightSelectorsRequest) throws TrailNotFoundException, InvalidTrailNameException, UnsupportedOperationException, OperationNotPermittedException, InsightNotEnabledException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInsightSelectorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetInsightSelectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInsightSelectors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getInsightSelectorsRequest).withMarshaller((Marshaller)new GetInsightSelectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetTrailResponse getTrail(GetTrailRequest getTrailRequest) throws TrailNotFoundException, InvalidTrailNameException, UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTrailResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetTrailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTrailRequest).withMarshaller((Marshaller)new GetTrailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetTrailStatusResponse getTrailStatus(GetTrailStatusRequest getTrailStatusRequest) throws TrailNotFoundException, InvalidTrailNameException, UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTrailStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetTrailStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrailStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTrailStatusRequest).withMarshaller((Marshaller)new GetTrailStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPublicKeysResponse listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) throws InvalidTimeRangeException, UnsupportedOperationException, OperationNotPermittedException, InvalidTokenException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPublicKeysResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPublicKeysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPublicKeys").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPublicKeysRequest).withMarshaller((Marshaller)new ListPublicKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPublicKeysIterable listPublicKeysPaginator(ListPublicKeysRequest listPublicKeysRequest) throws InvalidTimeRangeException, UnsupportedOperationException, OperationNotPermittedException, InvalidTokenException, AwsServiceException, SdkClientException, CloudTrailException {
        return new ListPublicKeysIterable(this, this.applyPaginatorUserAgent(listPublicKeysRequest));
    }

    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ResourceNotFoundException, CloudTrailArnInvalidException, ResourceTypeNotSupportedException, InvalidTrailNameException, UnsupportedOperationException, OperationNotPermittedException, InvalidTokenException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsRequest).withMarshaller((Marshaller)new ListTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTagsIterable listTagsPaginator(ListTagsRequest listTagsRequest) throws ResourceNotFoundException, CloudTrailArnInvalidException, ResourceTypeNotSupportedException, InvalidTrailNameException, UnsupportedOperationException, OperationNotPermittedException, InvalidTokenException, AwsServiceException, SdkClientException, CloudTrailException {
        return new ListTagsIterable(this, this.applyPaginatorUserAgent(listTagsRequest));
    }

    @Override
    public ListTrailsResponse listTrails(ListTrailsRequest listTrailsRequest) throws UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTrailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTrailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrails").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTrailsRequest).withMarshaller((Marshaller)new ListTrailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTrailsIterable listTrailsPaginator(ListTrailsRequest listTrailsRequest) throws UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException, CloudTrailException {
        return new ListTrailsIterable(this, this.applyPaginatorUserAgent(listTrailsRequest));
    }

    @Override
    public LookupEventsResponse lookupEvents(LookupEventsRequest lookupEventsRequest) throws InvalidLookupAttributesException, InvalidTimeRangeException, InvalidMaxResultsException, InvalidNextTokenException, InvalidEventCategoryException, UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, LookupEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (LookupEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("LookupEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)lookupEventsRequest).withMarshaller((Marshaller)new LookupEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public LookupEventsIterable lookupEventsPaginator(LookupEventsRequest lookupEventsRequest) throws InvalidLookupAttributesException, InvalidTimeRangeException, InvalidMaxResultsException, InvalidNextTokenException, InvalidEventCategoryException, UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException, CloudTrailException {
        return new LookupEventsIterable(this, this.applyPaginatorUserAgent(lookupEventsRequest));
    }

    @Override
    public PutEventSelectorsResponse putEventSelectors(PutEventSelectorsRequest putEventSelectorsRequest) throws TrailNotFoundException, InvalidTrailNameException, InvalidHomeRegionException, InvalidEventSelectorsException, UnsupportedOperationException, OperationNotPermittedException, NotOrganizationMasterAccountException, InsufficientDependencyServiceAccessPermissionException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEventSelectorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutEventSelectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEventSelectors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEventSelectorsRequest).withMarshaller((Marshaller)new PutEventSelectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutInsightSelectorsResponse putInsightSelectors(PutInsightSelectorsRequest putInsightSelectorsRequest) throws TrailNotFoundException, InvalidTrailNameException, InvalidHomeRegionException, InvalidInsightSelectorsException, InsufficientS3BucketPolicyException, InsufficientEncryptionPolicyException, UnsupportedOperationException, OperationNotPermittedException, NotOrganizationMasterAccountException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutInsightSelectorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutInsightSelectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutInsightSelectors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putInsightSelectorsRequest).withMarshaller((Marshaller)new PutInsightSelectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws ResourceNotFoundException, CloudTrailArnInvalidException, ResourceTypeNotSupportedException, InvalidTrailNameException, InvalidTagParameterException, UnsupportedOperationException, OperationNotPermittedException, NotOrganizationMasterAccountException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RemoveTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsRequest).withMarshaller((Marshaller)new RemoveTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartLoggingResponse startLogging(StartLoggingRequest startLoggingRequest) throws TrailNotFoundException, InvalidTrailNameException, InvalidHomeRegionException, UnsupportedOperationException, OperationNotPermittedException, NotOrganizationMasterAccountException, InsufficientDependencyServiceAccessPermissionException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartLoggingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartLoggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartLogging").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startLoggingRequest).withMarshaller((Marshaller)new StartLoggingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopLoggingResponse stopLogging(StopLoggingRequest stopLoggingRequest) throws TrailNotFoundException, InvalidTrailNameException, InvalidHomeRegionException, UnsupportedOperationException, OperationNotPermittedException, NotOrganizationMasterAccountException, InsufficientDependencyServiceAccessPermissionException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopLoggingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopLoggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopLogging").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopLoggingRequest).withMarshaller((Marshaller)new StopLoggingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateTrailResponse updateTrail(UpdateTrailRequest updateTrailRequest) throws S3BucketDoesNotExistException, InsufficientS3BucketPolicyException, InsufficientSnsTopicPolicyException, InsufficientEncryptionPolicyException, TrailNotFoundException, InvalidS3BucketNameException, InvalidS3PrefixException, InvalidSnsTopicNameException, InvalidKmsKeyIdException, InvalidTrailNameException, TrailNotProvidedException, InvalidEventSelectorsException, InvalidParameterCombinationException, InvalidHomeRegionException, KmsKeyNotFoundException, KmsException, InvalidCloudWatchLogsLogGroupArnException, InvalidCloudWatchLogsRoleArnException, CloudWatchLogsDeliveryUnavailableException, UnsupportedOperationException, OperationNotPermittedException, CloudTrailAccessNotEnabledException, InsufficientDependencyServiceAccessPermissionException, OrganizationsNotInUseException, NotOrganizationMasterAccountException, OrganizationNotInAllFeaturesModeException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTrailResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateTrailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTrail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTrailRequest).withMarshaller((Marshaller)new UpdateTrailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudTrailException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTokenException").exceptionBuilderSupplier(InvalidTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").exceptionBuilderSupplier(InvalidTimeRangeException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").exceptionBuilderSupplier(UnsupportedOperationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").exceptionBuilderSupplier(TrailNotProvidedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").exceptionBuilderSupplier(InvalidEventCategoryException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KmsException").exceptionBuilderSupplier(KmsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").exceptionBuilderSupplier(InvalidMaxResultsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").exceptionBuilderSupplier(TagsLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").exceptionBuilderSupplier(InvalidTrailNameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").exceptionBuilderSupplier(InvalidTagParameterException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").exceptionBuilderSupplier(OperationNotPermittedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrailNotFoundException").exceptionBuilderSupplier(TrailNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").exceptionBuilderSupplier(InvalidS3PrefixException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").exceptionBuilderSupplier(InvalidHomeRegionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CloudTrailRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.21").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudTrailRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

