/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.EventCategory;
import software.amazon.awssdk.services.cloudtrail.model.LookupAttribute;
import software.amazon.awssdk.services.cloudtrail.model.LookupAttributesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LookupEventsRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, LookupEventsRequest> {
    private static final SdkField<List<LookupAttribute>> LOOKUP_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(LookupEventsRequest.getter(LookupEventsRequest::lookupAttributes)).setter(LookupEventsRequest.setter(Builder::lookupAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookupAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LookupAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(LookupEventsRequest.getter(LookupEventsRequest::startTime)).setter(LookupEventsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(LookupEventsRequest.getter(LookupEventsRequest::endTime)).setter(LookupEventsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> EVENT_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LookupEventsRequest.getter(LookupEventsRequest::eventCategoryAsString)).setter(LookupEventsRequest.setter(Builder::eventCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategory").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(LookupEventsRequest.getter(LookupEventsRequest::maxResults)).setter(LookupEventsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LookupEventsRequest.getter(LookupEventsRequest::nextToken)).setter(LookupEventsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOOKUP_ATTRIBUTES_FIELD, START_TIME_FIELD, END_TIME_FIELD, EVENT_CATEGORY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<LookupAttribute> lookupAttributes;
    private final Instant startTime;
    private final Instant endTime;
    private final String eventCategory;
    private final Integer maxResults;
    private final String nextToken;

    private LookupEventsRequest(BuilderImpl builder) {
        super(builder);
        this.lookupAttributes = builder.lookupAttributes;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.eventCategory = builder.eventCategory;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<LookupAttribute> lookupAttributes() {
        return this.lookupAttributes;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public EventCategory eventCategory() {
        return EventCategory.fromValue(this.eventCategory);
    }

    public String eventCategoryAsString() {
        return this.eventCategory;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lookupAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCategoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupEventsRequest)) {
            return false;
        }
        LookupEventsRequest other = (LookupEventsRequest)((Object)obj);
        return Objects.equals(this.lookupAttributes(), other.lookupAttributes()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.eventCategoryAsString(), other.eventCategoryAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"LookupEventsRequest").add("LookupAttributes", this.lookupAttributes()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("EventCategory", (Object)this.eventCategoryAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LookupAttributes": {
                return Optional.ofNullable(clazz.cast(this.lookupAttributes()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "EventCategory": {
                return Optional.ofNullable(clazz.cast(this.eventCategoryAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LookupEventsRequest, T> g) {
        return obj -> g.apply((LookupEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private List<LookupAttribute> lookupAttributes = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;
        private String eventCategory;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(LookupEventsRequest model) {
            super(model);
            this.lookupAttributes(model.lookupAttributes);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.eventCategory(model.eventCategory);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<LookupAttribute.Builder> getLookupAttributes() {
            return this.lookupAttributes != null ? (Collection)this.lookupAttributes.stream().map(LookupAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lookupAttributes(Collection<LookupAttribute> lookupAttributes) {
            this.lookupAttributes = LookupAttributesListCopier.copy(lookupAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lookupAttributes(LookupAttribute ... lookupAttributes) {
            this.lookupAttributes(Arrays.asList(lookupAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lookupAttributes(Consumer<LookupAttribute.Builder> ... lookupAttributes) {
            this.lookupAttributes(Stream.of(lookupAttributes).map(c -> (LookupAttribute)((LookupAttribute.Builder)LookupAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLookupAttributes(Collection<LookupAttribute.BuilderImpl> lookupAttributes) {
            this.lookupAttributes = LookupAttributesListCopier.copyFromBuilder(lookupAttributes);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getEventCategoryAsString() {
            return this.eventCategory;
        }

        @Override
        public final Builder eventCategory(String eventCategory) {
            this.eventCategory = eventCategory;
            return this;
        }

        @Override
        public final Builder eventCategory(EventCategory eventCategory) {
            this.eventCategory(eventCategory == null ? null : eventCategory.toString());
            return this;
        }

        public final void setEventCategory(String eventCategory) {
            this.eventCategory = eventCategory;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public LookupEventsRequest build() {
            return new LookupEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, LookupEventsRequest> {
        public Builder lookupAttributes(Collection<LookupAttribute> var1);

        public Builder lookupAttributes(LookupAttribute ... var1);

        public Builder lookupAttributes(Consumer<LookupAttribute.Builder> ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder eventCategory(String var1);

        public Builder eventCategory(EventCategory var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

