/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.InsightSelector;
import software.amazon.awssdk.services.cloudtrail.model.InsightSelectorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutInsightSelectorsRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, PutInsightSelectorsRequest> {
    private static final SdkField<String> TRAIL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutInsightSelectorsRequest.getter(PutInsightSelectorsRequest::trailName)).setter(PutInsightSelectorsRequest.setter(Builder::trailName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailName").build()}).build();
    private static final SdkField<List<InsightSelector>> INSIGHT_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PutInsightSelectorsRequest.getter(PutInsightSelectorsRequest::insightSelectors)).setter(PutInsightSelectorsRequest.setter(Builder::insightSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightSelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_NAME_FIELD, INSIGHT_SELECTORS_FIELD));
    private final String trailName;
    private final List<InsightSelector> insightSelectors;

    private PutInsightSelectorsRequest(BuilderImpl builder) {
        super(builder);
        this.trailName = builder.trailName;
        this.insightSelectors = builder.insightSelectors;
    }

    public String trailName() {
        return this.trailName;
    }

    public List<InsightSelector> insightSelectors() {
        return this.insightSelectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trailName());
        hashCode = 31 * hashCode + Objects.hashCode(this.insightSelectors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInsightSelectorsRequest)) {
            return false;
        }
        PutInsightSelectorsRequest other = (PutInsightSelectorsRequest)((Object)obj);
        return Objects.equals(this.trailName(), other.trailName()) && Objects.equals(this.insightSelectors(), other.insightSelectors());
    }

    public String toString() {
        return ToString.builder((String)"PutInsightSelectorsRequest").add("TrailName", (Object)this.trailName()).add("InsightSelectors", this.insightSelectors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrailName": {
                return Optional.ofNullable(clazz.cast(this.trailName()));
            }
            case "InsightSelectors": {
                return Optional.ofNullable(clazz.cast(this.insightSelectors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutInsightSelectorsRequest, T> g) {
        return obj -> g.apply((PutInsightSelectorsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private String trailName;
        private List<InsightSelector> insightSelectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutInsightSelectorsRequest model) {
            super(model);
            this.trailName(model.trailName);
            this.insightSelectors(model.insightSelectors);
        }

        public final String getTrailName() {
            return this.trailName;
        }

        @Override
        public final Builder trailName(String trailName) {
            this.trailName = trailName;
            return this;
        }

        public final void setTrailName(String trailName) {
            this.trailName = trailName;
        }

        public final Collection<InsightSelector.Builder> getInsightSelectors() {
            return this.insightSelectors != null ? (Collection)this.insightSelectors.stream().map(InsightSelector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder insightSelectors(Collection<InsightSelector> insightSelectors) {
            this.insightSelectors = InsightSelectorsCopier.copy(insightSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightSelectors(InsightSelector ... insightSelectors) {
            this.insightSelectors(Arrays.asList(insightSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightSelectors(Consumer<InsightSelector.Builder> ... insightSelectors) {
            this.insightSelectors(Stream.of(insightSelectors).map(c -> (InsightSelector)((InsightSelector.Builder)InsightSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInsightSelectors(Collection<InsightSelector.BuilderImpl> insightSelectors) {
            this.insightSelectors = InsightSelectorsCopier.copyFromBuilder(insightSelectors);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutInsightSelectorsRequest build() {
            return new PutInsightSelectorsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutInsightSelectorsRequest> {
        public Builder trailName(String var1);

        public Builder insightSelectors(Collection<InsightSelector> var1);

        public Builder insightSelectors(InsightSelector ... var1);

        public Builder insightSelectors(Consumer<InsightSelector.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

