/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Trail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Trail> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trail.getter(Trail::name)).setter(Trail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trail.getter(Trail::s3BucketName)).setter(Trail.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trail.getter(Trail::s3KeyPrefix)).setter(Trail.setter(Builder::s3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()}).build();
    private static final SdkField<String> SNS_TOPIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trail.getter(Trail::snsTopicName)).setter(Trail.setter(Builder::snsTopicName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicName").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trail.getter(Trail::snsTopicARN)).setter(Trail.setter(Builder::snsTopicARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicARN").build()}).build();
    private static final SdkField<Boolean> INCLUDE_GLOBAL_SERVICE_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Trail.getter(Trail::includeGlobalServiceEvents)).setter(Trail.setter(Builder::includeGlobalServiceEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeGlobalServiceEvents").build()}).build();
    private static final SdkField<Boolean> IS_MULTI_REGION_TRAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Trail.getter(Trail::isMultiRegionTrail)).setter(Trail.setter(Builder::isMultiRegionTrail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsMultiRegionTrail").build()}).build();
    private static final SdkField<String> HOME_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trail.getter(Trail::homeRegion)).setter(Trail.setter(Builder::homeRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()}).build();
    private static final SdkField<String> TRAIL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trail.getter(Trail::trailARN)).setter(Trail.setter(Builder::trailARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailARN").build()}).build();
    private static final SdkField<Boolean> LOG_FILE_VALIDATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Trail.getter(Trail::logFileValidationEnabled)).setter(Trail.setter(Builder::logFileValidationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFileValidationEnabled").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trail.getter(Trail::cloudWatchLogsLogGroupArn)).setter(Trail.setter(Builder::cloudWatchLogsLogGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsLogGroupArn").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOGS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trail.getter(Trail::cloudWatchLogsRoleArn)).setter(Trail.setter(Builder::cloudWatchLogsRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsRoleArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Trail.getter(Trail::kmsKeyId)).setter(Trail.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Boolean> HAS_CUSTOM_EVENT_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Trail.getter(Trail::hasCustomEventSelectors)).setter(Trail.setter(Builder::hasCustomEventSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasCustomEventSelectors").build()}).build();
    private static final SdkField<Boolean> HAS_INSIGHT_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Trail.getter(Trail::hasInsightSelectors)).setter(Trail.setter(Builder::hasInsightSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasInsightSelectors").build()}).build();
    private static final SdkField<Boolean> IS_ORGANIZATION_TRAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Trail.getter(Trail::isOrganizationTrail)).setter(Trail.setter(Builder::isOrganizationTrail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsOrganizationTrail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, S3_BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD, SNS_TOPIC_NAME_FIELD, SNS_TOPIC_ARN_FIELD, INCLUDE_GLOBAL_SERVICE_EVENTS_FIELD, IS_MULTI_REGION_TRAIL_FIELD, HOME_REGION_FIELD, TRAIL_ARN_FIELD, LOG_FILE_VALIDATION_ENABLED_FIELD, CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD, CLOUD_WATCH_LOGS_ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, HAS_CUSTOM_EVENT_SELECTORS_FIELD, HAS_INSIGHT_SELECTORS_FIELD, IS_ORGANIZATION_TRAIL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String s3BucketName;
    private final String s3KeyPrefix;
    private final String snsTopicName;
    private final String snsTopicARN;
    private final Boolean includeGlobalServiceEvents;
    private final Boolean isMultiRegionTrail;
    private final String homeRegion;
    private final String trailARN;
    private final Boolean logFileValidationEnabled;
    private final String cloudWatchLogsLogGroupArn;
    private final String cloudWatchLogsRoleArn;
    private final String kmsKeyId;
    private final Boolean hasCustomEventSelectors;
    private final Boolean hasInsightSelectors;
    private final Boolean isOrganizationTrail;

    private Trail(BuilderImpl builder) {
        this.name = builder.name;
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.snsTopicName = builder.snsTopicName;
        this.snsTopicARN = builder.snsTopicARN;
        this.includeGlobalServiceEvents = builder.includeGlobalServiceEvents;
        this.isMultiRegionTrail = builder.isMultiRegionTrail;
        this.homeRegion = builder.homeRegion;
        this.trailARN = builder.trailARN;
        this.logFileValidationEnabled = builder.logFileValidationEnabled;
        this.cloudWatchLogsLogGroupArn = builder.cloudWatchLogsLogGroupArn;
        this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.hasCustomEventSelectors = builder.hasCustomEventSelectors;
        this.hasInsightSelectors = builder.hasInsightSelectors;
        this.isOrganizationTrail = builder.isOrganizationTrail;
    }

    public String name() {
        return this.name;
    }

    public String s3BucketName() {
        return this.s3BucketName;
    }

    public String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public String snsTopicName() {
        return this.snsTopicName;
    }

    public String snsTopicARN() {
        return this.snsTopicARN;
    }

    public Boolean includeGlobalServiceEvents() {
        return this.includeGlobalServiceEvents;
    }

    public Boolean isMultiRegionTrail() {
        return this.isMultiRegionTrail;
    }

    public String homeRegion() {
        return this.homeRegion;
    }

    public String trailARN() {
        return this.trailARN;
    }

    public Boolean logFileValidationEnabled() {
        return this.logFileValidationEnabled;
    }

    public String cloudWatchLogsLogGroupArn() {
        return this.cloudWatchLogsLogGroupArn;
    }

    public String cloudWatchLogsRoleArn() {
        return this.cloudWatchLogsRoleArn;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Boolean hasCustomEventSelectors() {
        return this.hasCustomEventSelectors;
    }

    public Boolean hasInsightSelectors() {
        return this.hasInsightSelectors;
    }

    public Boolean isOrganizationTrail() {
        return this.isOrganizationTrail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeGlobalServiceEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.isMultiRegionTrail());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.trailARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFileValidationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomEventSelectors());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsightSelectors());
        hashCode = 31 * hashCode + Objects.hashCode(this.isOrganizationTrail());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trail)) {
            return false;
        }
        Trail other = (Trail)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix()) && Objects.equals(this.snsTopicName(), other.snsTopicName()) && Objects.equals(this.snsTopicARN(), other.snsTopicARN()) && Objects.equals(this.includeGlobalServiceEvents(), other.includeGlobalServiceEvents()) && Objects.equals(this.isMultiRegionTrail(), other.isMultiRegionTrail()) && Objects.equals(this.homeRegion(), other.homeRegion()) && Objects.equals(this.trailARN(), other.trailARN()) && Objects.equals(this.logFileValidationEnabled(), other.logFileValidationEnabled()) && Objects.equals(this.cloudWatchLogsLogGroupArn(), other.cloudWatchLogsLogGroupArn()) && Objects.equals(this.cloudWatchLogsRoleArn(), other.cloudWatchLogsRoleArn()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.hasCustomEventSelectors(), other.hasCustomEventSelectors()) && Objects.equals(this.hasInsightSelectors(), other.hasInsightSelectors()) && Objects.equals(this.isOrganizationTrail(), other.isOrganizationTrail());
    }

    public String toString() {
        return ToString.builder((String)"Trail").add("Name", (Object)this.name()).add("S3BucketName", (Object)this.s3BucketName()).add("S3KeyPrefix", (Object)this.s3KeyPrefix()).add("SnsTopicName", (Object)this.snsTopicName()).add("SnsTopicARN", (Object)this.snsTopicARN()).add("IncludeGlobalServiceEvents", (Object)this.includeGlobalServiceEvents()).add("IsMultiRegionTrail", (Object)this.isMultiRegionTrail()).add("HomeRegion", (Object)this.homeRegion()).add("TrailARN", (Object)this.trailARN()).add("LogFileValidationEnabled", (Object)this.logFileValidationEnabled()).add("CloudWatchLogsLogGroupArn", (Object)this.cloudWatchLogsLogGroupArn()).add("CloudWatchLogsRoleArn", (Object)this.cloudWatchLogsRoleArn()).add("KmsKeyId", (Object)this.kmsKeyId()).add("HasCustomEventSelectors", (Object)this.hasCustomEventSelectors()).add("HasInsightSelectors", (Object)this.hasInsightSelectors()).add("IsOrganizationTrail", (Object)this.isOrganizationTrail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3KeyPrefix()));
            }
            case "SnsTopicName": {
                return Optional.ofNullable(clazz.cast(this.snsTopicName()));
            }
            case "SnsTopicARN": {
                return Optional.ofNullable(clazz.cast(this.snsTopicARN()));
            }
            case "IncludeGlobalServiceEvents": {
                return Optional.ofNullable(clazz.cast(this.includeGlobalServiceEvents()));
            }
            case "IsMultiRegionTrail": {
                return Optional.ofNullable(clazz.cast(this.isMultiRegionTrail()));
            }
            case "HomeRegion": {
                return Optional.ofNullable(clazz.cast(this.homeRegion()));
            }
            case "TrailARN": {
                return Optional.ofNullable(clazz.cast(this.trailARN()));
            }
            case "LogFileValidationEnabled": {
                return Optional.ofNullable(clazz.cast(this.logFileValidationEnabled()));
            }
            case "CloudWatchLogsLogGroupArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsLogGroupArn()));
            }
            case "CloudWatchLogsRoleArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsRoleArn()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "HasCustomEventSelectors": {
                return Optional.ofNullable(clazz.cast(this.hasCustomEventSelectors()));
            }
            case "HasInsightSelectors": {
                return Optional.ofNullable(clazz.cast(this.hasInsightSelectors()));
            }
            case "IsOrganizationTrail": {
                return Optional.ofNullable(clazz.cast(this.isOrganizationTrail()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Trail, T> g) {
        return obj -> g.apply((Trail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String s3BucketName;
        private String s3KeyPrefix;
        private String snsTopicName;
        private String snsTopicARN;
        private Boolean includeGlobalServiceEvents;
        private Boolean isMultiRegionTrail;
        private String homeRegion;
        private String trailARN;
        private Boolean logFileValidationEnabled;
        private String cloudWatchLogsLogGroupArn;
        private String cloudWatchLogsRoleArn;
        private String kmsKeyId;
        private Boolean hasCustomEventSelectors;
        private Boolean hasInsightSelectors;
        private Boolean isOrganizationTrail;

        private BuilderImpl() {
        }

        private BuilderImpl(Trail model) {
            this.name(model.name);
            this.s3BucketName(model.s3BucketName);
            this.s3KeyPrefix(model.s3KeyPrefix);
            this.snsTopicName(model.snsTopicName);
            this.snsTopicARN(model.snsTopicARN);
            this.includeGlobalServiceEvents(model.includeGlobalServiceEvents);
            this.isMultiRegionTrail(model.isMultiRegionTrail);
            this.homeRegion(model.homeRegion);
            this.trailARN(model.trailARN);
            this.logFileValidationEnabled(model.logFileValidationEnabled);
            this.cloudWatchLogsLogGroupArn(model.cloudWatchLogsLogGroupArn);
            this.cloudWatchLogsRoleArn(model.cloudWatchLogsRoleArn);
            this.kmsKeyId(model.kmsKeyId);
            this.hasCustomEventSelectors(model.hasCustomEventSelectors);
            this.hasInsightSelectors(model.hasInsightSelectors);
            this.isOrganizationTrail(model.isOrganizationTrail);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final String getSnsTopicName() {
            return this.snsTopicName;
        }

        @Override
        public final Builder snsTopicName(String snsTopicName) {
            this.snsTopicName = snsTopicName;
            return this;
        }

        public final void setSnsTopicName(String snsTopicName) {
            this.snsTopicName = snsTopicName;
        }

        public final String getSnsTopicARN() {
            return this.snsTopicARN;
        }

        @Override
        public final Builder snsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
            return this;
        }

        public final void setSnsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
        }

        public final Boolean getIncludeGlobalServiceEvents() {
            return this.includeGlobalServiceEvents;
        }

        @Override
        public final Builder includeGlobalServiceEvents(Boolean includeGlobalServiceEvents) {
            this.includeGlobalServiceEvents = includeGlobalServiceEvents;
            return this;
        }

        public final void setIncludeGlobalServiceEvents(Boolean includeGlobalServiceEvents) {
            this.includeGlobalServiceEvents = includeGlobalServiceEvents;
        }

        public final Boolean getIsMultiRegionTrail() {
            return this.isMultiRegionTrail;
        }

        @Override
        public final Builder isMultiRegionTrail(Boolean isMultiRegionTrail) {
            this.isMultiRegionTrail = isMultiRegionTrail;
            return this;
        }

        public final void setIsMultiRegionTrail(Boolean isMultiRegionTrail) {
            this.isMultiRegionTrail = isMultiRegionTrail;
        }

        public final String getHomeRegion() {
            return this.homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        public final String getTrailARN() {
            return this.trailARN;
        }

        @Override
        public final Builder trailARN(String trailARN) {
            this.trailARN = trailARN;
            return this;
        }

        public final void setTrailARN(String trailARN) {
            this.trailARN = trailARN;
        }

        public final Boolean getLogFileValidationEnabled() {
            return this.logFileValidationEnabled;
        }

        @Override
        public final Builder logFileValidationEnabled(Boolean logFileValidationEnabled) {
            this.logFileValidationEnabled = logFileValidationEnabled;
            return this;
        }

        public final void setLogFileValidationEnabled(Boolean logFileValidationEnabled) {
            this.logFileValidationEnabled = logFileValidationEnabled;
        }

        public final String getCloudWatchLogsLogGroupArn() {
            return this.cloudWatchLogsLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
            return this;
        }

        public final void setCloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
        }

        public final String getCloudWatchLogsRoleArn() {
            return this.cloudWatchLogsRoleArn;
        }

        @Override
        public final Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
            return this;
        }

        public final void setCloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getHasCustomEventSelectors() {
            return this.hasCustomEventSelectors;
        }

        @Override
        public final Builder hasCustomEventSelectors(Boolean hasCustomEventSelectors) {
            this.hasCustomEventSelectors = hasCustomEventSelectors;
            return this;
        }

        public final void setHasCustomEventSelectors(Boolean hasCustomEventSelectors) {
            this.hasCustomEventSelectors = hasCustomEventSelectors;
        }

        public final Boolean getHasInsightSelectors() {
            return this.hasInsightSelectors;
        }

        @Override
        public final Builder hasInsightSelectors(Boolean hasInsightSelectors) {
            this.hasInsightSelectors = hasInsightSelectors;
            return this;
        }

        public final void setHasInsightSelectors(Boolean hasInsightSelectors) {
            this.hasInsightSelectors = hasInsightSelectors;
        }

        public final Boolean getIsOrganizationTrail() {
            return this.isOrganizationTrail;
        }

        @Override
        public final Builder isOrganizationTrail(Boolean isOrganizationTrail) {
            this.isOrganizationTrail = isOrganizationTrail;
            return this;
        }

        public final void setIsOrganizationTrail(Boolean isOrganizationTrail) {
            this.isOrganizationTrail = isOrganizationTrail;
        }

        public Trail build() {
            return new Trail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Trail> {
        public Builder name(String var1);

        public Builder s3BucketName(String var1);

        public Builder s3KeyPrefix(String var1);

        public Builder snsTopicName(String var1);

        public Builder snsTopicARN(String var1);

        public Builder includeGlobalServiceEvents(Boolean var1);

        public Builder isMultiRegionTrail(Boolean var1);

        public Builder homeRegion(String var1);

        public Builder trailARN(String var1);

        public Builder logFileValidationEnabled(Boolean var1);

        public Builder cloudWatchLogsLogGroupArn(String var1);

        public Builder cloudWatchLogsRoleArn(String var1);

        public Builder kmsKeyId(String var1);

        public Builder hasCustomEventSelectors(Boolean var1);

        public Builder hasInsightSelectors(Boolean var1);

        public Builder isOrganizationTrail(Boolean var1);
    }
}

