/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.TrailNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrailsRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, DescribeTrailsRequest> {
    private static final SdkField<List<String>> TRAIL_NAME_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("trailNameList").getter(DescribeTrailsRequest.getter(DescribeTrailsRequest::trailNameList)).setter(DescribeTrailsRequest.setter(Builder::trailNameList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trailNameList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INCLUDE_SHADOW_TRAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeShadowTrails").getter(DescribeTrailsRequest.getter(DescribeTrailsRequest::includeShadowTrails)).setter(DescribeTrailsRequest.setter(Builder::includeShadowTrails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeShadowTrails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_NAME_LIST_FIELD, INCLUDE_SHADOW_TRAILS_FIELD));
    private final List<String> trailNameList;
    private final Boolean includeShadowTrails;

    private DescribeTrailsRequest(BuilderImpl builder) {
        super(builder);
        this.trailNameList = builder.trailNameList;
        this.includeShadowTrails = builder.includeShadowTrails;
    }

    public boolean hasTrailNameList() {
        return this.trailNameList != null && !(this.trailNameList instanceof SdkAutoConstructList);
    }

    public List<String> trailNameList() {
        return this.trailNameList;
    }

    public Boolean includeShadowTrails() {
        return this.includeShadowTrails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrailNameList() ? this.trailNameList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includeShadowTrails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrailsRequest)) {
            return false;
        }
        DescribeTrailsRequest other = (DescribeTrailsRequest)((Object)obj);
        return this.hasTrailNameList() == other.hasTrailNameList() && Objects.equals(this.trailNameList(), other.trailNameList()) && Objects.equals(this.includeShadowTrails(), other.includeShadowTrails());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTrailsRequest").add("TrailNameList", this.hasTrailNameList() ? this.trailNameList() : null).add("IncludeShadowTrails", (Object)this.includeShadowTrails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "trailNameList": {
                return Optional.ofNullable(clazz.cast(this.trailNameList()));
            }
            case "includeShadowTrails": {
                return Optional.ofNullable(clazz.cast(this.includeShadowTrails()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrailsRequest, T> g) {
        return obj -> g.apply((DescribeTrailsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private List<String> trailNameList = DefaultSdkAutoConstructList.getInstance();
        private Boolean includeShadowTrails;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrailsRequest model) {
            super(model);
            this.trailNameList(model.trailNameList);
            this.includeShadowTrails(model.includeShadowTrails);
        }

        public final Collection<String> getTrailNameList() {
            if (this.trailNameList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.trailNameList;
        }

        @Override
        public final Builder trailNameList(Collection<String> trailNameList) {
            this.trailNameList = TrailNameListCopier.copy(trailNameList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trailNameList(String ... trailNameList) {
            this.trailNameList(Arrays.asList(trailNameList));
            return this;
        }

        public final void setTrailNameList(Collection<String> trailNameList) {
            this.trailNameList = TrailNameListCopier.copy(trailNameList);
        }

        public final Boolean getIncludeShadowTrails() {
            return this.includeShadowTrails;
        }

        @Override
        public final Builder includeShadowTrails(Boolean includeShadowTrails) {
            this.includeShadowTrails = includeShadowTrails;
            return this;
        }

        public final void setIncludeShadowTrails(Boolean includeShadowTrails) {
            this.includeShadowTrails = includeShadowTrails;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTrailsRequest build() {
            return new DescribeTrailsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrailsRequest> {
        public Builder trailNameList(Collection<String> var1);

        public Builder trailNameList(String ... var1);

        public Builder includeShadowTrails(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

