/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.EventSelector;
import software.amazon.awssdk.services.cloudtrail.model.EventSelectorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEventSelectorsRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, PutEventSelectorsRequest> {
    private static final SdkField<String> TRAIL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrailName").getter(PutEventSelectorsRequest.getter(PutEventSelectorsRequest::trailName)).setter(PutEventSelectorsRequest.setter(Builder::trailName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailName").build()}).build();
    private static final SdkField<List<EventSelector>> EVENT_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventSelectors").getter(PutEventSelectorsRequest.getter(PutEventSelectorsRequest::eventSelectors)).setter(PutEventSelectorsRequest.setter(Builder::eventSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_NAME_FIELD, EVENT_SELECTORS_FIELD));
    private final String trailName;
    private final List<EventSelector> eventSelectors;

    private PutEventSelectorsRequest(BuilderImpl builder) {
        super(builder);
        this.trailName = builder.trailName;
        this.eventSelectors = builder.eventSelectors;
    }

    public String trailName() {
        return this.trailName;
    }

    public boolean hasEventSelectors() {
        return this.eventSelectors != null && !(this.eventSelectors instanceof SdkAutoConstructList);
    }

    public List<EventSelector> eventSelectors() {
        return this.eventSelectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trailName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventSelectors() ? this.eventSelectors() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventSelectorsRequest)) {
            return false;
        }
        PutEventSelectorsRequest other = (PutEventSelectorsRequest)((Object)obj);
        return Objects.equals(this.trailName(), other.trailName()) && this.hasEventSelectors() == other.hasEventSelectors() && Objects.equals(this.eventSelectors(), other.eventSelectors());
    }

    public String toString() {
        return ToString.builder((String)"PutEventSelectorsRequest").add("TrailName", (Object)this.trailName()).add("EventSelectors", this.hasEventSelectors() ? this.eventSelectors() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrailName": {
                return Optional.ofNullable(clazz.cast(this.trailName()));
            }
            case "EventSelectors": {
                return Optional.ofNullable(clazz.cast(this.eventSelectors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEventSelectorsRequest, T> g) {
        return obj -> g.apply((PutEventSelectorsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private String trailName;
        private List<EventSelector> eventSelectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventSelectorsRequest model) {
            super(model);
            this.trailName(model.trailName);
            this.eventSelectors(model.eventSelectors);
        }

        public final String getTrailName() {
            return this.trailName;
        }

        @Override
        public final Builder trailName(String trailName) {
            this.trailName = trailName;
            return this;
        }

        public final void setTrailName(String trailName) {
            this.trailName = trailName;
        }

        public final Collection<EventSelector.Builder> getEventSelectors() {
            if (this.eventSelectors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventSelectors != null ? (Collection)this.eventSelectors.stream().map(EventSelector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventSelectors(Collection<EventSelector> eventSelectors) {
            this.eventSelectors = EventSelectorsCopier.copy(eventSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSelectors(EventSelector ... eventSelectors) {
            this.eventSelectors(Arrays.asList(eventSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSelectors(Consumer<EventSelector.Builder> ... eventSelectors) {
            this.eventSelectors(Stream.of(eventSelectors).map(c -> (EventSelector)((EventSelector.Builder)EventSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventSelectors(Collection<EventSelector.BuilderImpl> eventSelectors) {
            this.eventSelectors = EventSelectorsCopier.copyFromBuilder(eventSelectors);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEventSelectorsRequest build() {
            return new PutEventSelectorsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutEventSelectorsRequest> {
        public Builder trailName(String var1);

        public Builder eventSelectors(Collection<EventSelector> var1);

        public Builder eventSelectors(EventSelector ... var1);

        public Builder eventSelectors(Consumer<EventSelector.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

