/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTrailResponse extends CloudTrailResponse implements
        ToCopyableBuilder<GetTrailResponse.Builder, GetTrailResponse> {
    private static final SdkField<Trail> TRAIL_FIELD = SdkField.<Trail> builder(MarshallingType.SDK_POJO).memberName("Trail")
            .getter(getter(GetTrailResponse::trail)).setter(setter(Builder::trail)).constructor(Trail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_FIELD));

    private final Trail trail;

    private GetTrailResponse(BuilderImpl builder) {
        super(builder);
        this.trail = builder.trail;
    }

    /**
     * Returns the value of the Trail property for this object.
     * 
     * @return The value of the Trail property for this object.
     */
    public Trail trail() {
        return trail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrailResponse)) {
            return false;
        }
        GetTrailResponse other = (GetTrailResponse) obj;
        return Objects.equals(trail(), other.trail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetTrailResponse").add("Trail", trail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Trail":
            return Optional.ofNullable(clazz.cast(trail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTrailResponse, T> g) {
        return obj -> g.apply((GetTrailResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTrailResponse> {
        /**
         * Sets the value of the Trail property for this object.
         *
         * @param trail
         *        The new value for the Trail property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trail(Trail trail);

        /**
         * Sets the value of the Trail property for this object.
         *
         * This is a convenience that creates an instance of the {@link Trail.Builder} avoiding the need to create one
         * manually via {@link Trail#builder()}.
         *
         * When the {@link Consumer} completes, {@link Trail.Builder#build()} is called immediately and its result is
         * passed to {@link #trail(Trail)}.
         * 
         * @param trail
         *        a consumer that will call methods on {@link Trail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trail(Trail)
         */
        default Builder trail(Consumer<Trail.Builder> trail) {
            return trail(Trail.builder().applyMutation(trail).build());
        }
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private Trail trail;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrailResponse model) {
            super(model);
            trail(model.trail);
        }

        public final Trail.Builder getTrail() {
            return trail != null ? trail.toBuilder() : null;
        }

        @Override
        public final Builder trail(Trail trail) {
            this.trail = trail;
            return this;
        }

        public final void setTrail(Trail.BuilderImpl trail) {
            this.trail = trail != null ? trail.build() : null;
        }

        @Override
        public GetTrailResponse build() {
            return new GetTrailResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
