/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This exception is thrown when the <code>PutEventSelectors</code> operation is called with a number of event selectors
 * or data resources that is not valid. The combination of event selectors and data resources is not valid. A trail can
 * have up to 5 event selectors. A trail is limited to 250 data resources. These data resources can be distributed
 * across event selectors, but the overall total cannot exceed 250.
 * </p>
 * <p>
 * You can:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Specify a valid number of event selectors (1 to 5) for a trail.
 * </p>
 * </li>
 * <li>
 * <p>
 * Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of resources on an
 * individual event selector is configurable up to 250. However, this upper limit is allowed only if the total number of
 * data resources does not exceed 250 across all event selectors for a trail.
 * </p>
 * </li>
 * <li>
 * <p>
 * Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter with a value
 * of <code>read-only</code> is invalid.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidEventSelectorsException extends CloudTrailException implements
        ToCopyableBuilder<InvalidEventSelectorsException.Builder, InvalidEventSelectorsException> {
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList());

    private static final long serialVersionUID = 1L;

    private InvalidEventSelectorsException(BuilderImpl builder) {
        super(builder);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidEventSelectorsException>,
            CloudTrailException.Builder {
        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends CloudTrailException.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(InvalidEventSelectorsException model) {
            super(model);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public InvalidEventSelectorsException build() {
            return new InvalidEventSelectorsException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
