/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a request for LookupEvents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LookupEventsRequest extends CloudTrailRequest implements
        ToCopyableBuilder<LookupEventsRequest.Builder, LookupEventsRequest> {
    private static final SdkField<List<LookupAttribute>> LOOKUP_ATTRIBUTES_FIELD = SdkField
            .<List<LookupAttribute>> builder(MarshallingType.LIST)
            .memberName("LookupAttributes")
            .getter(getter(LookupEventsRequest::lookupAttributes))
            .setter(setter(Builder::lookupAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookupAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LookupAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(LookupAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(LookupEventsRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(LookupEventsRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> EVENT_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventCategory").getter(getter(LookupEventsRequest::eventCategoryAsString))
            .setter(setter(Builder::eventCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategory").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(LookupEventsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(LookupEventsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOOKUP_ATTRIBUTES_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, EVENT_CATEGORY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<LookupAttribute> lookupAttributes;

    private final Instant startTime;

    private final Instant endTime;

    private final String eventCategory;

    private final Integer maxResults;

    private final String nextToken;

    private LookupEventsRequest(BuilderImpl builder) {
        super(builder);
        this.lookupAttributes = builder.lookupAttributes;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.eventCategory = builder.eventCategory;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the LookupAttributes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLookupAttributes() {
        return lookupAttributes != null && !(lookupAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of lookup attributes. Currently the list can contain only one item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLookupAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains a list of lookup attributes. Currently the list can contain only one item.
     */
    public List<LookupAttribute> lookupAttributes() {
        return lookupAttributes;
    }

    /**
     * <p>
     * Specifies that only events that occur after or at the specified time are returned. If the specified start time is
     * after the specified end time, an error is returned.
     * </p>
     * 
     * @return Specifies that only events that occur after or at the specified time are returned. If the specified start
     *         time is after the specified end time, an error is returned.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Specifies that only events that occur before or at the specified time are returned. If the specified end time is
     * before the specified start time, an error is returned.
     * </p>
     * 
     * @return Specifies that only events that occur before or at the specified time are returned. If the specified end
     *         time is before the specified start time, an error is returned.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Specifies the event category. If you do not specify an event category, events of the category are not returned in
     * the response. For example, if you do not specify <code>insight</code> as the value of <code>EventCategory</code>,
     * no Insights events are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventCategory}
     * will return {@link EventCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventCategoryAsString}.
     * </p>
     * 
     * @return Specifies the event category. If you do not specify an event category, events of the category are not
     *         returned in the response. For example, if you do not specify <code>insight</code> as the value of
     *         <code>EventCategory</code>, no Insights events are returned.
     * @see EventCategory
     */
    public EventCategory eventCategory() {
        return EventCategory.fromValue(eventCategory);
    }

    /**
     * <p>
     * Specifies the event category. If you do not specify an event category, events of the category are not returned in
     * the response. For example, if you do not specify <code>insight</code> as the value of <code>EventCategory</code>,
     * no Insights events are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventCategory}
     * will return {@link EventCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventCategoryAsString}.
     * </p>
     * 
     * @return Specifies the event category. If you do not specify an event category, events of the category are not
     *         returned in the response. For example, if you do not specify <code>insight</code> as the value of
     *         <code>EventCategory</code>, no Insights events are returned.
     * @see EventCategory
     */
    public String eventCategoryAsString() {
        return eventCategory;
    }

    /**
     * <p>
     * The number of events to return. Possible values are 1 through 50. The default is 50.
     * </p>
     * 
     * @return The number of events to return. Possible values are 1 through 50. The default is 50.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to use to get the next page of results after a previous API call. This token must be passed in with the
     * same parameters that were specified in the the original call. For example, if the original call specified an
     * AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.
     * </p>
     * 
     * @return The token to use to get the next page of results after a previous API call. This token must be passed in
     *         with the same parameters that were specified in the the original call. For example, if the original call
     *         specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include
     *         those same parameters.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLookupAttributes() ? lookupAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(eventCategoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupEventsRequest)) {
            return false;
        }
        LookupEventsRequest other = (LookupEventsRequest) obj;
        return hasLookupAttributes() == other.hasLookupAttributes()
                && Objects.equals(lookupAttributes(), other.lookupAttributes()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime())
                && Objects.equals(eventCategoryAsString(), other.eventCategoryAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LookupEventsRequest").add("LookupAttributes", hasLookupAttributes() ? lookupAttributes() : null)
                .add("StartTime", startTime()).add("EndTime", endTime()).add("EventCategory", eventCategoryAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LookupAttributes":
            return Optional.ofNullable(clazz.cast(lookupAttributes()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "EventCategory":
            return Optional.ofNullable(clazz.cast(eventCategoryAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LookupEventsRequest, T> g) {
        return obj -> g.apply((LookupEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, LookupEventsRequest> {
        /**
         * <p>
         * Contains a list of lookup attributes. Currently the list can contain only one item.
         * </p>
         * 
         * @param lookupAttributes
         *        Contains a list of lookup attributes. Currently the list can contain only one item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lookupAttributes(Collection<LookupAttribute> lookupAttributes);

        /**
         * <p>
         * Contains a list of lookup attributes. Currently the list can contain only one item.
         * </p>
         * 
         * @param lookupAttributes
         *        Contains a list of lookup attributes. Currently the list can contain only one item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lookupAttributes(LookupAttribute... lookupAttributes);

        /**
         * <p>
         * Contains a list of lookup attributes. Currently the list can contain only one item.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LookupAttribute>.Builder} avoiding the need
         * to create one manually via {@link List<LookupAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LookupAttribute>.Builder#build()} is called immediately and
         * its result is passed to {@link #lookupAttributes(List<LookupAttribute>)}.
         * 
         * @param lookupAttributes
         *        a consumer that will call methods on {@link List<LookupAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lookupAttributes(List<LookupAttribute>)
         */
        Builder lookupAttributes(Consumer<LookupAttribute.Builder>... lookupAttributes);

        /**
         * <p>
         * Specifies that only events that occur after or at the specified time are returned. If the specified start
         * time is after the specified end time, an error is returned.
         * </p>
         * 
         * @param startTime
         *        Specifies that only events that occur after or at the specified time are returned. If the specified
         *        start time is after the specified end time, an error is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Specifies that only events that occur before or at the specified time are returned. If the specified end time
         * is before the specified start time, an error is returned.
         * </p>
         * 
         * @param endTime
         *        Specifies that only events that occur before or at the specified time are returned. If the specified
         *        end time is before the specified start time, an error is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Specifies the event category. If you do not specify an event category, events of the category are not
         * returned in the response. For example, if you do not specify <code>insight</code> as the value of
         * <code>EventCategory</code>, no Insights events are returned.
         * </p>
         * 
         * @param eventCategory
         *        Specifies the event category. If you do not specify an event category, events of the category are not
         *        returned in the response. For example, if you do not specify <code>insight</code> as the value of
         *        <code>EventCategory</code>, no Insights events are returned.
         * @see EventCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventCategory
         */
        Builder eventCategory(String eventCategory);

        /**
         * <p>
         * Specifies the event category. If you do not specify an event category, events of the category are not
         * returned in the response. For example, if you do not specify <code>insight</code> as the value of
         * <code>EventCategory</code>, no Insights events are returned.
         * </p>
         * 
         * @param eventCategory
         *        Specifies the event category. If you do not specify an event category, events of the category are not
         *        returned in the response. For example, if you do not specify <code>insight</code> as the value of
         *        <code>EventCategory</code>, no Insights events are returned.
         * @see EventCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventCategory
         */
        Builder eventCategory(EventCategory eventCategory);

        /**
         * <p>
         * The number of events to return. Possible values are 1 through 50. The default is 50.
         * </p>
         * 
         * @param maxResults
         *        The number of events to return. Possible values are 1 through 50. The default is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to use to get the next page of results after a previous API call. This token must be passed in with
         * the same parameters that were specified in the the original call. For example, if the original call specified
         * an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same
         * parameters.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next page of results after a previous API call. This token must be passed
         *        in with the same parameters that were specified in the the original call. For example, if the original
         *        call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should
         *        include those same parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private List<LookupAttribute> lookupAttributes = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private String eventCategory;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(LookupEventsRequest model) {
            super(model);
            lookupAttributes(model.lookupAttributes);
            startTime(model.startTime);
            endTime(model.endTime);
            eventCategory(model.eventCategory);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<LookupAttribute.Builder> getLookupAttributes() {
            if (lookupAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return lookupAttributes != null ? lookupAttributes.stream().map(LookupAttribute::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lookupAttributes(Collection<LookupAttribute> lookupAttributes) {
            this.lookupAttributes = LookupAttributesListCopier.copy(lookupAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lookupAttributes(LookupAttribute... lookupAttributes) {
            lookupAttributes(Arrays.asList(lookupAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lookupAttributes(Consumer<LookupAttribute.Builder>... lookupAttributes) {
            lookupAttributes(Stream.of(lookupAttributes).map(c -> LookupAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLookupAttributes(Collection<LookupAttribute.BuilderImpl> lookupAttributes) {
            this.lookupAttributes = LookupAttributesListCopier.copyFromBuilder(lookupAttributes);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getEventCategory() {
            return eventCategory;
        }

        @Override
        public final Builder eventCategory(String eventCategory) {
            this.eventCategory = eventCategory;
            return this;
        }

        @Override
        public final Builder eventCategory(EventCategory eventCategory) {
            this.eventCategory(eventCategory == null ? null : eventCategory.toString());
            return this;
        }

        public final void setEventCategory(String eventCategory) {
            this.eventCategory = eventCategory;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public LookupEventsRequest build() {
            return new LookupEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
