/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for a trail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Trail implements SdkPojo, Serializable, ToCopyableBuilder<Trail.Builder, Trail> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Trail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(Trail::s3BucketName)).setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3KeyPrefix").getter(getter(Trail::s3KeyPrefix)).setter(setter(Builder::s3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()).build();

    private static final SdkField<String> SNS_TOPIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicName").getter(getter(Trail::snsTopicName)).setter(setter(Builder::snsTopicName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicName").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicARN").getter(getter(Trail::snsTopicARN)).setter(setter(Builder::snsTopicARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicARN").build()).build();

    private static final SdkField<Boolean> INCLUDE_GLOBAL_SERVICE_EVENTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeGlobalServiceEvents")
            .getter(getter(Trail::includeGlobalServiceEvents))
            .setter(setter(Builder::includeGlobalServiceEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeGlobalServiceEvents").build())
            .build();

    private static final SdkField<Boolean> IS_MULTI_REGION_TRAIL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsMultiRegionTrail").getter(getter(Trail::isMultiRegionTrail))
            .setter(setter(Builder::isMultiRegionTrail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsMultiRegionTrail").build())
            .build();

    private static final SdkField<String> HOME_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeRegion").getter(getter(Trail::homeRegion)).setter(setter(Builder::homeRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()).build();

    private static final SdkField<String> TRAIL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrailARN").getter(getter(Trail::trailARN)).setter(setter(Builder::trailARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailARN").build()).build();

    private static final SdkField<Boolean> LOG_FILE_VALIDATION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("LogFileValidationEnabled")
            .getter(getter(Trail::logFileValidationEnabled)).setter(setter(Builder::logFileValidationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFileValidationEnabled").build())
            .build();

    private static final SdkField<String> CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("CloudWatchLogsLogGroupArn")
            .getter(getter(Trail::cloudWatchLogsLogGroupArn)).setter(setter(Builder::cloudWatchLogsLogGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsLogGroupArn").build())
            .build();

    private static final SdkField<String> CLOUD_WATCH_LOGS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogsRoleArn").getter(getter(Trail::cloudWatchLogsRoleArn))
            .setter(setter(Builder::cloudWatchLogsRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsRoleArn").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(Trail::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> HAS_CUSTOM_EVENT_SELECTORS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasCustomEventSelectors").getter(getter(Trail::hasCustomEventSelectors))
            .setter(setter(Builder::hasCustomEventSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasCustomEventSelectors").build())
            .build();

    private static final SdkField<Boolean> HAS_INSIGHT_SELECTORS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasInsightSelectors").getter(getter(Trail::hasInsightSelectors))
            .setter(setter(Builder::hasInsightSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasInsightSelectors").build())
            .build();

    private static final SdkField<Boolean> IS_ORGANIZATION_TRAIL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsOrganizationTrail").getter(getter(Trail::isOrganizationTrail))
            .setter(setter(Builder::isOrganizationTrail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsOrganizationTrail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            S3_BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD, SNS_TOPIC_NAME_FIELD, SNS_TOPIC_ARN_FIELD,
            INCLUDE_GLOBAL_SERVICE_EVENTS_FIELD, IS_MULTI_REGION_TRAIL_FIELD, HOME_REGION_FIELD, TRAIL_ARN_FIELD,
            LOG_FILE_VALIDATION_ENABLED_FIELD, CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD, CLOUD_WATCH_LOGS_ROLE_ARN_FIELD,
            KMS_KEY_ID_FIELD, HAS_CUSTOM_EVENT_SELECTORS_FIELD, HAS_INSIGHT_SELECTORS_FIELD, IS_ORGANIZATION_TRAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String s3BucketName;

    private final String s3KeyPrefix;

    private final String snsTopicName;

    private final String snsTopicARN;

    private final Boolean includeGlobalServiceEvents;

    private final Boolean isMultiRegionTrail;

    private final String homeRegion;

    private final String trailARN;

    private final Boolean logFileValidationEnabled;

    private final String cloudWatchLogsLogGroupArn;

    private final String cloudWatchLogsRoleArn;

    private final String kmsKeyId;

    private final Boolean hasCustomEventSelectors;

    private final Boolean hasInsightSelectors;

    private final Boolean isOrganizationTrail;

    private Trail(BuilderImpl builder) {
        this.name = builder.name;
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.snsTopicName = builder.snsTopicName;
        this.snsTopicARN = builder.snsTopicARN;
        this.includeGlobalServiceEvents = builder.includeGlobalServiceEvents;
        this.isMultiRegionTrail = builder.isMultiRegionTrail;
        this.homeRegion = builder.homeRegion;
        this.trailARN = builder.trailARN;
        this.logFileValidationEnabled = builder.logFileValidationEnabled;
        this.cloudWatchLogsLogGroupArn = builder.cloudWatchLogsLogGroupArn;
        this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.hasCustomEventSelectors = builder.hasCustomEventSelectors;
        this.hasInsightSelectors = builder.hasInsightSelectors;
        this.isOrganizationTrail = builder.isOrganizationTrail;
    }

    /**
     * <p>
     * Name of the trail set by calling <a>CreateTrail</a>. The maximum length is 128 characters.
     * </p>
     * 
     * @return Name of the trail set by calling <a>CreateTrail</a>. The maximum length is 128 characters.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Name of the Amazon S3 bucket into which CloudTrail delivers your trail files. See <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3
     * Bucket Naming Requirements</a>.
     * </p>
     * 
     * @return Name of the Amazon S3 bucket into which CloudTrail delivers your trail files. See <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon
     *         S3 Bucket Naming Requirements</a>.
     */
    public String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file
     * delivery. For more information, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your
     * CloudTrail Log Files</a>.The maximum length is 200 characters.
     * </p>
     * 
     * @return Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log
     *         file delivery. For more information, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding
     *         Your CloudTrail Log Files</a>.The maximum length is 200 characters.
     */
    public String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    /**
     * <p>
     * This field is no longer in use. Use SnsTopicARN.
     * </p>
     * 
     * @return This field is no longer in use. Use SnsTopicARN.
     */
    public String snsTopicName() {
        return snsTopicName;
    }

    /**
     * <p>
     * Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are
     * delivered. The format of a topic ARN is:
     * </p>
     * <p>
     * <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code>
     * </p>
     * 
     * @return Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are
     *         delivered. The format of a topic ARN is:</p>
     *         <p>
     *         <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code>
     */
    public String snsTopicARN() {
        return snsTopicARN;
    }

    /**
     * <p>
     * Set to <b>True</b> to include AWS API calls from AWS global services such as IAM. Otherwise, <b>False</b>.
     * </p>
     * 
     * @return Set to <b>True</b> to include AWS API calls from AWS global services such as IAM. Otherwise,
     *         <b>False</b>.
     */
    public Boolean includeGlobalServiceEvents() {
        return includeGlobalServiceEvents;
    }

    /**
     * <p>
     * Specifies whether the trail exists only in one region or exists in all regions.
     * </p>
     * 
     * @return Specifies whether the trail exists only in one region or exists in all regions.
     */
    public Boolean isMultiRegionTrail() {
        return isMultiRegionTrail;
    }

    /**
     * <p>
     * The region in which the trail was created.
     * </p>
     * 
     * @return The region in which the trail was created.
     */
    public String homeRegion() {
        return homeRegion;
    }

    /**
     * <p>
     * Specifies the ARN of the trail. The format of a trail ARN is:
     * </p>
     * <p>
     * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     * </p>
     * 
     * @return Specifies the ARN of the trail. The format of a trail ARN is:</p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     */
    public String trailARN() {
        return trailARN;
    }

    /**
     * <p>
     * Specifies whether log file validation is enabled.
     * </p>
     * 
     * @return Specifies whether log file validation is enabled.
     */
    public Boolean logFileValidationEnabled() {
        return logFileValidationEnabled;
    }

    /**
     * <p>
     * Specifies an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail
     * logs will be delivered.
     * </p>
     * 
     * @return Specifies an Amazon Resource Name (ARN), a unique identifier that represents the log group to which
     *         CloudTrail logs will be delivered.
     */
    public String cloudWatchLogsLogGroupArn() {
        return cloudWatchLogsLogGroupArn;
    }

    /**
     * <p>
     * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
     * </p>
     * 
     * @return Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
     */
    public String cloudWatchLogsRoleArn() {
        return cloudWatchLogsRoleArn;
    }

    /**
     * <p>
     * Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a
     * KMS key in the format:
     * </p>
     * <p>
     * <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
     * </p>
     * 
     * @return Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified
     *         ARN to a KMS key in the format:</p>
     *         <p>
     *         <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specifies if the trail has custom event selectors.
     * </p>
     * 
     * @return Specifies if the trail has custom event selectors.
     */
    public Boolean hasCustomEventSelectors() {
        return hasCustomEventSelectors;
    }

    /**
     * <p>
     * Specifies whether a trail has insight types specified in an <code>InsightSelector</code> list.
     * </p>
     * 
     * @return Specifies whether a trail has insight types specified in an <code>InsightSelector</code> list.
     */
    public Boolean hasInsightSelectors() {
        return hasInsightSelectors;
    }

    /**
     * <p>
     * Specifies whether the trail is an organization trail.
     * </p>
     * 
     * @return Specifies whether the trail is an organization trail.
     */
    public Boolean isOrganizationTrail() {
        return isOrganizationTrail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicName());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicARN());
        hashCode = 31 * hashCode + Objects.hashCode(includeGlobalServiceEvents());
        hashCode = 31 * hashCode + Objects.hashCode(isMultiRegionTrail());
        hashCode = 31 * hashCode + Objects.hashCode(homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(trailARN());
        hashCode = 31 * hashCode + Objects.hashCode(logFileValidationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomEventSelectors());
        hashCode = 31 * hashCode + Objects.hashCode(hasInsightSelectors());
        hashCode = 31 * hashCode + Objects.hashCode(isOrganizationTrail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trail)) {
            return false;
        }
        Trail other = (Trail) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(s3KeyPrefix(), other.s3KeyPrefix()) && Objects.equals(snsTopicName(), other.snsTopicName())
                && Objects.equals(snsTopicARN(), other.snsTopicARN())
                && Objects.equals(includeGlobalServiceEvents(), other.includeGlobalServiceEvents())
                && Objects.equals(isMultiRegionTrail(), other.isMultiRegionTrail())
                && Objects.equals(homeRegion(), other.homeRegion()) && Objects.equals(trailARN(), other.trailARN())
                && Objects.equals(logFileValidationEnabled(), other.logFileValidationEnabled())
                && Objects.equals(cloudWatchLogsLogGroupArn(), other.cloudWatchLogsLogGroupArn())
                && Objects.equals(cloudWatchLogsRoleArn(), other.cloudWatchLogsRoleArn())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(hasCustomEventSelectors(), other.hasCustomEventSelectors())
                && Objects.equals(hasInsightSelectors(), other.hasInsightSelectors())
                && Objects.equals(isOrganizationTrail(), other.isOrganizationTrail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Trail").add("Name", name()).add("S3BucketName", s3BucketName())
                .add("S3KeyPrefix", s3KeyPrefix()).add("SnsTopicName", snsTopicName()).add("SnsTopicARN", snsTopicARN())
                .add("IncludeGlobalServiceEvents", includeGlobalServiceEvents()).add("IsMultiRegionTrail", isMultiRegionTrail())
                .add("HomeRegion", homeRegion()).add("TrailARN", trailARN())
                .add("LogFileValidationEnabled", logFileValidationEnabled())
                .add("CloudWatchLogsLogGroupArn", cloudWatchLogsLogGroupArn())
                .add("CloudWatchLogsRoleArn", cloudWatchLogsRoleArn()).add("KmsKeyId", kmsKeyId())
                .add("HasCustomEventSelectors", hasCustomEventSelectors()).add("HasInsightSelectors", hasInsightSelectors())
                .add("IsOrganizationTrail", isOrganizationTrail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "S3KeyPrefix":
            return Optional.ofNullable(clazz.cast(s3KeyPrefix()));
        case "SnsTopicName":
            return Optional.ofNullable(clazz.cast(snsTopicName()));
        case "SnsTopicARN":
            return Optional.ofNullable(clazz.cast(snsTopicARN()));
        case "IncludeGlobalServiceEvents":
            return Optional.ofNullable(clazz.cast(includeGlobalServiceEvents()));
        case "IsMultiRegionTrail":
            return Optional.ofNullable(clazz.cast(isMultiRegionTrail()));
        case "HomeRegion":
            return Optional.ofNullable(clazz.cast(homeRegion()));
        case "TrailARN":
            return Optional.ofNullable(clazz.cast(trailARN()));
        case "LogFileValidationEnabled":
            return Optional.ofNullable(clazz.cast(logFileValidationEnabled()));
        case "CloudWatchLogsLogGroupArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsLogGroupArn()));
        case "CloudWatchLogsRoleArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsRoleArn()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "HasCustomEventSelectors":
            return Optional.ofNullable(clazz.cast(hasCustomEventSelectors()));
        case "HasInsightSelectors":
            return Optional.ofNullable(clazz.cast(hasInsightSelectors()));
        case "IsOrganizationTrail":
            return Optional.ofNullable(clazz.cast(isOrganizationTrail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Trail, T> g) {
        return obj -> g.apply((Trail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Trail> {
        /**
         * <p>
         * Name of the trail set by calling <a>CreateTrail</a>. The maximum length is 128 characters.
         * </p>
         * 
         * @param name
         *        Name of the trail set by calling <a>CreateTrail</a>. The maximum length is 128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Name of the Amazon S3 bucket into which CloudTrail delivers your trail files. See <a
         * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3
         * Bucket Naming Requirements</a>.
         * </p>
         * 
         * @param s3BucketName
         *        Name of the Amazon S3 bucket into which CloudTrail delivers your trail files. See <a
         *        href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html"
         *        >Amazon S3 Bucket Naming Requirements</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file
         * delivery. For more information, see <a
         * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your
         * CloudTrail Log Files</a>.The maximum length is 200 characters.
         * </p>
         * 
         * @param s3KeyPrefix
         *        Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log
         *        file delivery. For more information, see <a
         *        href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html"
         *        >Finding Your CloudTrail Log Files</a>.The maximum length is 200 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);

        /**
         * <p>
         * This field is no longer in use. Use SnsTopicARN.
         * </p>
         * 
         * @param snsTopicName
         *        This field is no longer in use. Use SnsTopicARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicName(String snsTopicName);

        /**
         * <p>
         * Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are
         * delivered. The format of a topic ARN is:
         * </p>
         * <p>
         * <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code>
         * </p>
         * 
         * @param snsTopicARN
         *        Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files
         *        are delivered. The format of a topic ARN is:</p>
         *        <p>
         *        <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicARN(String snsTopicARN);

        /**
         * <p>
         * Set to <b>True</b> to include AWS API calls from AWS global services such as IAM. Otherwise, <b>False</b>.
         * </p>
         * 
         * @param includeGlobalServiceEvents
         *        Set to <b>True</b> to include AWS API calls from AWS global services such as IAM. Otherwise,
         *        <b>False</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeGlobalServiceEvents(Boolean includeGlobalServiceEvents);

        /**
         * <p>
         * Specifies whether the trail exists only in one region or exists in all regions.
         * </p>
         * 
         * @param isMultiRegionTrail
         *        Specifies whether the trail exists only in one region or exists in all regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isMultiRegionTrail(Boolean isMultiRegionTrail);

        /**
         * <p>
         * The region in which the trail was created.
         * </p>
         * 
         * @param homeRegion
         *        The region in which the trail was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegion(String homeRegion);

        /**
         * <p>
         * Specifies the ARN of the trail. The format of a trail ARN is:
         * </p>
         * <p>
         * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * </p>
         * 
         * @param trailARN
         *        Specifies the ARN of the trail. The format of a trail ARN is:</p>
         *        <p>
         *        <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailARN(String trailARN);

        /**
         * <p>
         * Specifies whether log file validation is enabled.
         * </p>
         * 
         * @param logFileValidationEnabled
         *        Specifies whether log file validation is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFileValidationEnabled(Boolean logFileValidationEnabled);

        /**
         * <p>
         * Specifies an Amazon Resource Name (ARN), a unique identifier that represents the log group to which
         * CloudTrail logs will be delivered.
         * </p>
         * 
         * @param cloudWatchLogsLogGroupArn
         *        Specifies an Amazon Resource Name (ARN), a unique identifier that represents the log group to which
         *        CloudTrail logs will be delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn);

        /**
         * <p>
         * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
         * </p>
         * 
         * @param cloudWatchLogsRoleArn
         *        Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn);

        /**
         * <p>
         * Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN
         * to a KMS key in the format:
         * </p>
         * <p>
         * <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
         * </p>
         * 
         * @param kmsKeyId
         *        Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully
         *        specified ARN to a KMS key in the format:</p>
         *        <p>
         *        <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies if the trail has custom event selectors.
         * </p>
         * 
         * @param hasCustomEventSelectors
         *        Specifies if the trail has custom event selectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasCustomEventSelectors(Boolean hasCustomEventSelectors);

        /**
         * <p>
         * Specifies whether a trail has insight types specified in an <code>InsightSelector</code> list.
         * </p>
         * 
         * @param hasInsightSelectors
         *        Specifies whether a trail has insight types specified in an <code>InsightSelector</code> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasInsightSelectors(Boolean hasInsightSelectors);

        /**
         * <p>
         * Specifies whether the trail is an organization trail.
         * </p>
         * 
         * @param isOrganizationTrail
         *        Specifies whether the trail is an organization trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isOrganizationTrail(Boolean isOrganizationTrail);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String s3BucketName;

        private String s3KeyPrefix;

        private String snsTopicName;

        private String snsTopicARN;

        private Boolean includeGlobalServiceEvents;

        private Boolean isMultiRegionTrail;

        private String homeRegion;

        private String trailARN;

        private Boolean logFileValidationEnabled;

        private String cloudWatchLogsLogGroupArn;

        private String cloudWatchLogsRoleArn;

        private String kmsKeyId;

        private Boolean hasCustomEventSelectors;

        private Boolean hasInsightSelectors;

        private Boolean isOrganizationTrail;

        private BuilderImpl() {
        }

        private BuilderImpl(Trail model) {
            name(model.name);
            s3BucketName(model.s3BucketName);
            s3KeyPrefix(model.s3KeyPrefix);
            snsTopicName(model.snsTopicName);
            snsTopicARN(model.snsTopicARN);
            includeGlobalServiceEvents(model.includeGlobalServiceEvents);
            isMultiRegionTrail(model.isMultiRegionTrail);
            homeRegion(model.homeRegion);
            trailARN(model.trailARN);
            logFileValidationEnabled(model.logFileValidationEnabled);
            cloudWatchLogsLogGroupArn(model.cloudWatchLogsLogGroupArn);
            cloudWatchLogsRoleArn(model.cloudWatchLogsRoleArn);
            kmsKeyId(model.kmsKeyId);
            hasCustomEventSelectors(model.hasCustomEventSelectors);
            hasInsightSelectors(model.hasInsightSelectors);
            isOrganizationTrail(model.isOrganizationTrail);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final String getSnsTopicName() {
            return snsTopicName;
        }

        @Override
        public final Builder snsTopicName(String snsTopicName) {
            this.snsTopicName = snsTopicName;
            return this;
        }

        public final void setSnsTopicName(String snsTopicName) {
            this.snsTopicName = snsTopicName;
        }

        public final String getSnsTopicARN() {
            return snsTopicARN;
        }

        @Override
        public final Builder snsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
            return this;
        }

        public final void setSnsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
        }

        public final Boolean getIncludeGlobalServiceEvents() {
            return includeGlobalServiceEvents;
        }

        @Override
        public final Builder includeGlobalServiceEvents(Boolean includeGlobalServiceEvents) {
            this.includeGlobalServiceEvents = includeGlobalServiceEvents;
            return this;
        }

        public final void setIncludeGlobalServiceEvents(Boolean includeGlobalServiceEvents) {
            this.includeGlobalServiceEvents = includeGlobalServiceEvents;
        }

        public final Boolean getIsMultiRegionTrail() {
            return isMultiRegionTrail;
        }

        @Override
        public final Builder isMultiRegionTrail(Boolean isMultiRegionTrail) {
            this.isMultiRegionTrail = isMultiRegionTrail;
            return this;
        }

        public final void setIsMultiRegionTrail(Boolean isMultiRegionTrail) {
            this.isMultiRegionTrail = isMultiRegionTrail;
        }

        public final String getHomeRegion() {
            return homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        public final String getTrailARN() {
            return trailARN;
        }

        @Override
        public final Builder trailARN(String trailARN) {
            this.trailARN = trailARN;
            return this;
        }

        public final void setTrailARN(String trailARN) {
            this.trailARN = trailARN;
        }

        public final Boolean getLogFileValidationEnabled() {
            return logFileValidationEnabled;
        }

        @Override
        public final Builder logFileValidationEnabled(Boolean logFileValidationEnabled) {
            this.logFileValidationEnabled = logFileValidationEnabled;
            return this;
        }

        public final void setLogFileValidationEnabled(Boolean logFileValidationEnabled) {
            this.logFileValidationEnabled = logFileValidationEnabled;
        }

        public final String getCloudWatchLogsLogGroupArn() {
            return cloudWatchLogsLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
            return this;
        }

        public final void setCloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
        }

        public final String getCloudWatchLogsRoleArn() {
            return cloudWatchLogsRoleArn;
        }

        @Override
        public final Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
            return this;
        }

        public final void setCloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getHasCustomEventSelectors() {
            return hasCustomEventSelectors;
        }

        @Override
        public final Builder hasCustomEventSelectors(Boolean hasCustomEventSelectors) {
            this.hasCustomEventSelectors = hasCustomEventSelectors;
            return this;
        }

        public final void setHasCustomEventSelectors(Boolean hasCustomEventSelectors) {
            this.hasCustomEventSelectors = hasCustomEventSelectors;
        }

        public final Boolean getHasInsightSelectors() {
            return hasInsightSelectors;
        }

        @Override
        public final Builder hasInsightSelectors(Boolean hasInsightSelectors) {
            this.hasInsightSelectors = hasInsightSelectors;
            return this;
        }

        public final void setHasInsightSelectors(Boolean hasInsightSelectors) {
            this.hasInsightSelectors = hasInsightSelectors;
        }

        public final Boolean getIsOrganizationTrail() {
            return isOrganizationTrail;
        }

        @Override
        public final Builder isOrganizationTrail(Boolean isOrganizationTrail) {
            this.isOrganizationTrail = isOrganizationTrail;
            return this;
        }

        public final void setIsOrganizationTrail(Boolean isOrganizationTrail) {
            this.isOrganizationTrail = isOrganizationTrail;
        }

        @Override
        public Trail build() {
            return new Trail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
