/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.OperatorCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdvancedFieldSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdvancedFieldSelector> {
    private static final SdkField<String> FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Field").getter(AdvancedFieldSelector.getter(AdvancedFieldSelector::field)).setter(AdvancedFieldSelector.setter(Builder::field)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Field").build()}).build();
    private static final SdkField<List<String>> EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Equals").getter(AdvancedFieldSelector.getter(AdvancedFieldSelector::equalsValue)).setter(AdvancedFieldSelector.setter(Builder::equalsValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Equals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STARTS_WITH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StartsWith").getter(AdvancedFieldSelector.getter(AdvancedFieldSelector::startsWith)).setter(AdvancedFieldSelector.setter(Builder::startsWith)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartsWith").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ENDS_WITH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndsWith").getter(AdvancedFieldSelector.getter(AdvancedFieldSelector::endsWith)).setter(AdvancedFieldSelector.setter(Builder::endsWith)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndsWith").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotEquals").getter(AdvancedFieldSelector.getter(AdvancedFieldSelector::notEquals)).setter(AdvancedFieldSelector.setter(Builder::notEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotEquals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_STARTS_WITH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotStartsWith").getter(AdvancedFieldSelector.getter(AdvancedFieldSelector::notStartsWith)).setter(AdvancedFieldSelector.setter(Builder::notStartsWith)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotStartsWith").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_ENDS_WITH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotEndsWith").getter(AdvancedFieldSelector.getter(AdvancedFieldSelector::notEndsWith)).setter(AdvancedFieldSelector.setter(Builder::notEndsWith)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotEndsWith").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, EQUALS_FIELD, STARTS_WITH_FIELD, ENDS_WITH_FIELD, NOT_EQUALS_FIELD, NOT_STARTS_WITH_FIELD, NOT_ENDS_WITH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String field;
    private final List<String> equals;
    private final List<String> startsWith;
    private final List<String> endsWith;
    private final List<String> notEquals;
    private final List<String> notStartsWith;
    private final List<String> notEndsWith;

    private AdvancedFieldSelector(BuilderImpl builder) {
        this.field = builder.field;
        this.equals = builder.equals;
        this.startsWith = builder.startsWith;
        this.endsWith = builder.endsWith;
        this.notEquals = builder.notEquals;
        this.notStartsWith = builder.notStartsWith;
        this.notEndsWith = builder.notEndsWith;
    }

    public String field() {
        return this.field;
    }

    public boolean hasEqualsValue() {
        return this.equals != null && !(this.equals instanceof SdkAutoConstructList);
    }

    public List<String> equalsValue() {
        return this.equals;
    }

    public boolean hasStartsWith() {
        return this.startsWith != null && !(this.startsWith instanceof SdkAutoConstructList);
    }

    public List<String> startsWith() {
        return this.startsWith;
    }

    public boolean hasEndsWith() {
        return this.endsWith != null && !(this.endsWith instanceof SdkAutoConstructList);
    }

    public List<String> endsWith() {
        return this.endsWith;
    }

    public boolean hasNotEquals() {
        return this.notEquals != null && !(this.notEquals instanceof SdkAutoConstructList);
    }

    public List<String> notEquals() {
        return this.notEquals;
    }

    public boolean hasNotStartsWith() {
        return this.notStartsWith != null && !(this.notStartsWith instanceof SdkAutoConstructList);
    }

    public List<String> notStartsWith() {
        return this.notStartsWith;
    }

    public boolean hasNotEndsWith() {
        return this.notEndsWith != null && !(this.notEndsWith instanceof SdkAutoConstructList);
    }

    public List<String> notEndsWith() {
        return this.notEndsWith;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.field());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEqualsValue() ? this.equalsValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStartsWith() ? this.startsWith() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndsWith() ? this.endsWith() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotEquals() ? this.notEquals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotStartsWith() ? this.notStartsWith() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotEndsWith() ? this.notEndsWith() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedFieldSelector)) {
            return false;
        }
        AdvancedFieldSelector other = (AdvancedFieldSelector)obj;
        return Objects.equals(this.field(), other.field()) && this.hasEqualsValue() == other.hasEqualsValue() && Objects.equals(this.equalsValue(), other.equalsValue()) && this.hasStartsWith() == other.hasStartsWith() && Objects.equals(this.startsWith(), other.startsWith()) && this.hasEndsWith() == other.hasEndsWith() && Objects.equals(this.endsWith(), other.endsWith()) && this.hasNotEquals() == other.hasNotEquals() && Objects.equals(this.notEquals(), other.notEquals()) && this.hasNotStartsWith() == other.hasNotStartsWith() && Objects.equals(this.notStartsWith(), other.notStartsWith()) && this.hasNotEndsWith() == other.hasNotEndsWith() && Objects.equals(this.notEndsWith(), other.notEndsWith());
    }

    public String toString() {
        return ToString.builder((String)"AdvancedFieldSelector").add("Field", (Object)this.field()).add("Equals", this.hasEqualsValue() ? this.equalsValue() : null).add("StartsWith", this.hasStartsWith() ? this.startsWith() : null).add("EndsWith", this.hasEndsWith() ? this.endsWith() : null).add("NotEquals", this.hasNotEquals() ? this.notEquals() : null).add("NotStartsWith", this.hasNotStartsWith() ? this.notStartsWith() : null).add("NotEndsWith", this.hasNotEndsWith() ? this.notEndsWith() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Field": {
                return Optional.ofNullable(clazz.cast(this.field()));
            }
            case "Equals": {
                return Optional.ofNullable(clazz.cast(this.equalsValue()));
            }
            case "StartsWith": {
                return Optional.ofNullable(clazz.cast(this.startsWith()));
            }
            case "EndsWith": {
                return Optional.ofNullable(clazz.cast(this.endsWith()));
            }
            case "NotEquals": {
                return Optional.ofNullable(clazz.cast(this.notEquals()));
            }
            case "NotStartsWith": {
                return Optional.ofNullable(clazz.cast(this.notStartsWith()));
            }
            case "NotEndsWith": {
                return Optional.ofNullable(clazz.cast(this.notEndsWith()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdvancedFieldSelector, T> g) {
        return obj -> g.apply((AdvancedFieldSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String field;
        private List<String> equals = DefaultSdkAutoConstructList.getInstance();
        private List<String> startsWith = DefaultSdkAutoConstructList.getInstance();
        private List<String> endsWith = DefaultSdkAutoConstructList.getInstance();
        private List<String> notEquals = DefaultSdkAutoConstructList.getInstance();
        private List<String> notStartsWith = DefaultSdkAutoConstructList.getInstance();
        private List<String> notEndsWith = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedFieldSelector model) {
            this.field(model.field);
            this.equalsValue(model.equals);
            this.startsWith(model.startsWith);
            this.endsWith(model.endsWith);
            this.notEquals(model.notEquals);
            this.notStartsWith(model.notStartsWith);
            this.notEndsWith(model.notEndsWith);
        }

        public final String getField() {
            return this.field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        public final void setField(String field) {
            this.field = field;
        }

        public final Collection<String> getEqualsValue() {
            if (this.equals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.equals;
        }

        @Override
        public final Builder equalsValue(Collection<String> equals) {
            this.equals = OperatorCopier.copy(equals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder equalsValue(String ... equals) {
            this.equalsValue(Arrays.asList(equals));
            return this;
        }

        public final void setEqualsValue(Collection<String> equals) {
            this.equals = OperatorCopier.copy(equals);
        }

        public final Collection<String> getStartsWith() {
            if (this.startsWith instanceof SdkAutoConstructList) {
                return null;
            }
            return this.startsWith;
        }

        @Override
        public final Builder startsWith(Collection<String> startsWith) {
            this.startsWith = OperatorCopier.copy(startsWith);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startsWith(String ... startsWith) {
            this.startsWith(Arrays.asList(startsWith));
            return this;
        }

        public final void setStartsWith(Collection<String> startsWith) {
            this.startsWith = OperatorCopier.copy(startsWith);
        }

        public final Collection<String> getEndsWith() {
            if (this.endsWith instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endsWith;
        }

        @Override
        public final Builder endsWith(Collection<String> endsWith) {
            this.endsWith = OperatorCopier.copy(endsWith);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endsWith(String ... endsWith) {
            this.endsWith(Arrays.asList(endsWith));
            return this;
        }

        public final void setEndsWith(Collection<String> endsWith) {
            this.endsWith = OperatorCopier.copy(endsWith);
        }

        public final Collection<String> getNotEquals() {
            if (this.notEquals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notEquals;
        }

        @Override
        public final Builder notEquals(Collection<String> notEquals) {
            this.notEquals = OperatorCopier.copy(notEquals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notEquals(String ... notEquals) {
            this.notEquals(Arrays.asList(notEquals));
            return this;
        }

        public final void setNotEquals(Collection<String> notEquals) {
            this.notEquals = OperatorCopier.copy(notEquals);
        }

        public final Collection<String> getNotStartsWith() {
            if (this.notStartsWith instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notStartsWith;
        }

        @Override
        public final Builder notStartsWith(Collection<String> notStartsWith) {
            this.notStartsWith = OperatorCopier.copy(notStartsWith);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notStartsWith(String ... notStartsWith) {
            this.notStartsWith(Arrays.asList(notStartsWith));
            return this;
        }

        public final void setNotStartsWith(Collection<String> notStartsWith) {
            this.notStartsWith = OperatorCopier.copy(notStartsWith);
        }

        public final Collection<String> getNotEndsWith() {
            if (this.notEndsWith instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notEndsWith;
        }

        @Override
        public final Builder notEndsWith(Collection<String> notEndsWith) {
            this.notEndsWith = OperatorCopier.copy(notEndsWith);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notEndsWith(String ... notEndsWith) {
            this.notEndsWith(Arrays.asList(notEndsWith));
            return this;
        }

        public final void setNotEndsWith(Collection<String> notEndsWith) {
            this.notEndsWith = OperatorCopier.copy(notEndsWith);
        }

        public AdvancedFieldSelector build() {
            return new AdvancedFieldSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdvancedFieldSelector> {
        public Builder field(String var1);

        public Builder equalsValue(Collection<String> var1);

        public Builder equalsValue(String ... var1);

        public Builder startsWith(Collection<String> var1);

        public Builder startsWith(String ... var1);

        public Builder endsWith(Collection<String> var1);

        public Builder endsWith(String ... var1);

        public Builder notEquals(Collection<String> var1);

        public Builder notEquals(String ... var1);

        public Builder notStartsWith(Collection<String> var1);

        public Builder notStartsWith(String ... var1);

        public Builder notEndsWith(Collection<String> var1);

        public Builder notEndsWith(String ... var1);
    }
}

