/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEventSelectorsResponse extends CloudTrailResponse implements
        ToCopyableBuilder<GetEventSelectorsResponse.Builder, GetEventSelectorsResponse> {
    private static final SdkField<String> TRAIL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrailARN").getter(getter(GetEventSelectorsResponse::trailARN)).setter(setter(Builder::trailARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailARN").build()).build();

    private static final SdkField<List<EventSelector>> EVENT_SELECTORS_FIELD = SdkField
            .<List<EventSelector>> builder(MarshallingType.LIST)
            .memberName("EventSelectors")
            .getter(getter(GetEventSelectorsResponse::eventSelectors))
            .setter(setter(Builder::eventSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSelectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AdvancedEventSelector>> ADVANCED_EVENT_SELECTORS_FIELD = SdkField
            .<List<AdvancedEventSelector>> builder(MarshallingType.LIST)
            .memberName("AdvancedEventSelectors")
            .getter(getter(GetEventSelectorsResponse::advancedEventSelectors))
            .setter(setter(Builder::advancedEventSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedEventSelectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdvancedEventSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdvancedEventSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_ARN_FIELD,
            EVENT_SELECTORS_FIELD, ADVANCED_EVENT_SELECTORS_FIELD));

    private final String trailARN;

    private final List<EventSelector> eventSelectors;

    private final List<AdvancedEventSelector> advancedEventSelectors;

    private GetEventSelectorsResponse(BuilderImpl builder) {
        super(builder);
        this.trailARN = builder.trailARN;
        this.eventSelectors = builder.eventSelectors;
        this.advancedEventSelectors = builder.advancedEventSelectors;
    }

    /**
     * <p>
     * The specified trail ARN that has the event selectors.
     * </p>
     * 
     * @return The specified trail ARN that has the event selectors.
     */
    public String trailARN() {
        return trailARN;
    }

    /**
     * Returns true if the EventSelectors property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEventSelectors() {
        return eventSelectors != null && !(eventSelectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The event selectors that are configured for the trail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventSelectors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The event selectors that are configured for the trail.
     */
    public List<EventSelector> eventSelectors() {
        return eventSelectors;
    }

    /**
     * Returns true if the AdvancedEventSelectors property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAdvancedEventSelectors() {
        return advancedEventSelectors != null && !(advancedEventSelectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The advanced event selectors that are configured for the trail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdvancedEventSelectors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The advanced event selectors that are configured for the trail.
     */
    public List<AdvancedEventSelector> advancedEventSelectors() {
        return advancedEventSelectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trailARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventSelectors() ? eventSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAdvancedEventSelectors() ? advancedEventSelectors() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventSelectorsResponse)) {
            return false;
        }
        GetEventSelectorsResponse other = (GetEventSelectorsResponse) obj;
        return Objects.equals(trailARN(), other.trailARN()) && hasEventSelectors() == other.hasEventSelectors()
                && Objects.equals(eventSelectors(), other.eventSelectors())
                && hasAdvancedEventSelectors() == other.hasAdvancedEventSelectors()
                && Objects.equals(advancedEventSelectors(), other.advancedEventSelectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetEventSelectorsResponse").add("TrailARN", trailARN())
                .add("EventSelectors", hasEventSelectors() ? eventSelectors() : null)
                .add("AdvancedEventSelectors", hasAdvancedEventSelectors() ? advancedEventSelectors() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrailARN":
            return Optional.ofNullable(clazz.cast(trailARN()));
        case "EventSelectors":
            return Optional.ofNullable(clazz.cast(eventSelectors()));
        case "AdvancedEventSelectors":
            return Optional.ofNullable(clazz.cast(advancedEventSelectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEventSelectorsResponse, T> g) {
        return obj -> g.apply((GetEventSelectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEventSelectorsResponse> {
        /**
         * <p>
         * The specified trail ARN that has the event selectors.
         * </p>
         * 
         * @param trailARN
         *        The specified trail ARN that has the event selectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailARN(String trailARN);

        /**
         * <p>
         * The event selectors that are configured for the trail.
         * </p>
         * 
         * @param eventSelectors
         *        The event selectors that are configured for the trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSelectors(Collection<EventSelector> eventSelectors);

        /**
         * <p>
         * The event selectors that are configured for the trail.
         * </p>
         * 
         * @param eventSelectors
         *        The event selectors that are configured for the trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSelectors(EventSelector... eventSelectors);

        /**
         * <p>
         * The event selectors that are configured for the trail.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventSelector>.Builder} avoiding the need
         * to create one manually via {@link List<EventSelector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventSelector>.Builder#build()} is called immediately and
         * its result is passed to {@link #eventSelectors(List<EventSelector>)}.
         * 
         * @param eventSelectors
         *        a consumer that will call methods on {@link List<EventSelector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSelectors(List<EventSelector>)
         */
        Builder eventSelectors(Consumer<EventSelector.Builder>... eventSelectors);

        /**
         * <p>
         * The advanced event selectors that are configured for the trail.
         * </p>
         * 
         * @param advancedEventSelectors
         *        The advanced event selectors that are configured for the trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors);

        /**
         * <p>
         * The advanced event selectors that are configured for the trail.
         * </p>
         * 
         * @param advancedEventSelectors
         *        The advanced event selectors that are configured for the trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedEventSelectors(AdvancedEventSelector... advancedEventSelectors);

        /**
         * <p>
         * The advanced event selectors that are configured for the trail.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AdvancedEventSelector>.Builder} avoiding
         * the need to create one manually via {@link List<AdvancedEventSelector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AdvancedEventSelector>.Builder#build()} is called
         * immediately and its result is passed to {@link #advancedEventSelectors(List<AdvancedEventSelector>)}.
         * 
         * @param advancedEventSelectors
         *        a consumer that will call methods on {@link List<AdvancedEventSelector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedEventSelectors(List<AdvancedEventSelector>)
         */
        Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder>... advancedEventSelectors);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String trailARN;

        private List<EventSelector> eventSelectors = DefaultSdkAutoConstructList.getInstance();

        private List<AdvancedEventSelector> advancedEventSelectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventSelectorsResponse model) {
            super(model);
            trailARN(model.trailARN);
            eventSelectors(model.eventSelectors);
            advancedEventSelectors(model.advancedEventSelectors);
        }

        public final String getTrailARN() {
            return trailARN;
        }

        @Override
        public final Builder trailARN(String trailARN) {
            this.trailARN = trailARN;
            return this;
        }

        public final void setTrailARN(String trailARN) {
            this.trailARN = trailARN;
        }

        public final Collection<EventSelector.Builder> getEventSelectors() {
            if (eventSelectors instanceof SdkAutoConstructList) {
                return null;
            }
            return eventSelectors != null ? eventSelectors.stream().map(EventSelector::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder eventSelectors(Collection<EventSelector> eventSelectors) {
            this.eventSelectors = EventSelectorsCopier.copy(eventSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSelectors(EventSelector... eventSelectors) {
            eventSelectors(Arrays.asList(eventSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSelectors(Consumer<EventSelector.Builder>... eventSelectors) {
            eventSelectors(Stream.of(eventSelectors).map(c -> EventSelector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEventSelectors(Collection<EventSelector.BuilderImpl> eventSelectors) {
            this.eventSelectors = EventSelectorsCopier.copyFromBuilder(eventSelectors);
        }

        public final Collection<AdvancedEventSelector.Builder> getAdvancedEventSelectors() {
            if (advancedEventSelectors instanceof SdkAutoConstructList) {
                return null;
            }
            return advancedEventSelectors != null ? advancedEventSelectors.stream().map(AdvancedEventSelector::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder advancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copy(advancedEventSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(AdvancedEventSelector... advancedEventSelectors) {
            advancedEventSelectors(Arrays.asList(advancedEventSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder>... advancedEventSelectors) {
            advancedEventSelectors(Stream.of(advancedEventSelectors)
                    .map(c -> AdvancedEventSelector.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdvancedEventSelectors(Collection<AdvancedEventSelector.BuilderImpl> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copyFromBuilder(advancedEventSelectors);
        }

        @Override
        public GetEventSelectorsResponse build() {
            return new GetEventSelectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
