/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.ResourceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTagsRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, ListTagsRequest> {
    private static final SdkField<List<String>> RESOURCE_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceIdList").getter(ListTagsRequest.getter(ListTagsRequest::resourceIdList)).setter(ListTagsRequest.setter(Builder::resourceIdList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTagsRequest.getter(ListTagsRequest::nextToken)).setter(ListTagsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> resourceIdList;
    private final String nextToken;

    private ListTagsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdList = builder.resourceIdList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResourceIdList() {
        return this.resourceIdList != null && !(this.resourceIdList instanceof SdkAutoConstructList);
    }

    public final List<String> resourceIdList() {
        return this.resourceIdList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIdList() ? this.resourceIdList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsRequest)) {
            return false;
        }
        ListTagsRequest other = (ListTagsRequest)((Object)obj);
        return this.hasResourceIdList() == other.hasResourceIdList() && Objects.equals(this.resourceIdList(), other.resourceIdList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTagsRequest").add("ResourceIdList", this.hasResourceIdList() ? this.resourceIdList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceIdList": {
                return Optional.ofNullable(clazz.cast(this.resourceIdList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagsRequest, T> g) {
        return obj -> g.apply((ListTagsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private List<String> resourceIdList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsRequest model) {
            super(model);
            this.resourceIdList(model.resourceIdList);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getResourceIdList() {
            if (this.resourceIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceIdList;
        }

        @Override
        public final Builder resourceIdList(Collection<String> resourceIdList) {
            this.resourceIdList = ResourceIdListCopier.copy(resourceIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdList(String ... resourceIdList) {
            this.resourceIdList(Arrays.asList(resourceIdList));
            return this;
        }

        public final void setResourceIdList(Collection<String> resourceIdList) {
            this.resourceIdList = ResourceIdListCopier.copy(resourceIdList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTagsRequest build() {
            return new ListTagsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTagsRequest> {
        public Builder resourceIdList(Collection<String> var1);

        public Builder resourceIdList(String ... var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

