/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector;
import software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelectorsCopier;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.EventSelector;
import software.amazon.awssdk.services.cloudtrail.model.EventSelectorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEventSelectorsResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, GetEventSelectorsResponse> {
    private static final SdkField<String> TRAIL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrailARN").getter(GetEventSelectorsResponse.getter(GetEventSelectorsResponse::trailARN)).setter(GetEventSelectorsResponse.setter(Builder::trailARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailARN").build()}).build();
    private static final SdkField<List<EventSelector>> EVENT_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventSelectors").getter(GetEventSelectorsResponse.getter(GetEventSelectorsResponse::eventSelectors)).setter(GetEventSelectorsResponse.setter(Builder::eventSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AdvancedEventSelector>> ADVANCED_EVENT_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdvancedEventSelectors").getter(GetEventSelectorsResponse.getter(GetEventSelectorsResponse::advancedEventSelectors)).setter(GetEventSelectorsResponse.setter(Builder::advancedEventSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedEventSelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdvancedEventSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_ARN_FIELD, EVENT_SELECTORS_FIELD, ADVANCED_EVENT_SELECTORS_FIELD));
    private final String trailARN;
    private final List<EventSelector> eventSelectors;
    private final List<AdvancedEventSelector> advancedEventSelectors;

    private GetEventSelectorsResponse(BuilderImpl builder) {
        super(builder);
        this.trailARN = builder.trailARN;
        this.eventSelectors = builder.eventSelectors;
        this.advancedEventSelectors = builder.advancedEventSelectors;
    }

    public final String trailARN() {
        return this.trailARN;
    }

    public final boolean hasEventSelectors() {
        return this.eventSelectors != null && !(this.eventSelectors instanceof SdkAutoConstructList);
    }

    public final List<EventSelector> eventSelectors() {
        return this.eventSelectors;
    }

    public final boolean hasAdvancedEventSelectors() {
        return this.advancedEventSelectors != null && !(this.advancedEventSelectors instanceof SdkAutoConstructList);
    }

    public final List<AdvancedEventSelector> advancedEventSelectors() {
        return this.advancedEventSelectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trailARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventSelectors() ? this.eventSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvancedEventSelectors() ? this.advancedEventSelectors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventSelectorsResponse)) {
            return false;
        }
        GetEventSelectorsResponse other = (GetEventSelectorsResponse)((Object)obj);
        return Objects.equals(this.trailARN(), other.trailARN()) && this.hasEventSelectors() == other.hasEventSelectors() && Objects.equals(this.eventSelectors(), other.eventSelectors()) && this.hasAdvancedEventSelectors() == other.hasAdvancedEventSelectors() && Objects.equals(this.advancedEventSelectors(), other.advancedEventSelectors());
    }

    public final String toString() {
        return ToString.builder((String)"GetEventSelectorsResponse").add("TrailARN", (Object)this.trailARN()).add("EventSelectors", this.hasEventSelectors() ? this.eventSelectors() : null).add("AdvancedEventSelectors", this.hasAdvancedEventSelectors() ? this.advancedEventSelectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrailARN": {
                return Optional.ofNullable(clazz.cast(this.trailARN()));
            }
            case "EventSelectors": {
                return Optional.ofNullable(clazz.cast(this.eventSelectors()));
            }
            case "AdvancedEventSelectors": {
                return Optional.ofNullable(clazz.cast(this.advancedEventSelectors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEventSelectorsResponse, T> g) {
        return obj -> g.apply((GetEventSelectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String trailARN;
        private List<EventSelector> eventSelectors = DefaultSdkAutoConstructList.getInstance();
        private List<AdvancedEventSelector> advancedEventSelectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventSelectorsResponse model) {
            super(model);
            this.trailARN(model.trailARN);
            this.eventSelectors(model.eventSelectors);
            this.advancedEventSelectors(model.advancedEventSelectors);
        }

        public final String getTrailARN() {
            return this.trailARN;
        }

        @Override
        public final Builder trailARN(String trailARN) {
            this.trailARN = trailARN;
            return this;
        }

        public final void setTrailARN(String trailARN) {
            this.trailARN = trailARN;
        }

        public final Collection<EventSelector.Builder> getEventSelectors() {
            if (this.eventSelectors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventSelectors != null ? (Collection)this.eventSelectors.stream().map(EventSelector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventSelectors(Collection<EventSelector> eventSelectors) {
            this.eventSelectors = EventSelectorsCopier.copy(eventSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSelectors(EventSelector ... eventSelectors) {
            this.eventSelectors(Arrays.asList(eventSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSelectors(Consumer<EventSelector.Builder> ... eventSelectors) {
            this.eventSelectors(Stream.of(eventSelectors).map(c -> (EventSelector)((EventSelector.Builder)EventSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventSelectors(Collection<EventSelector.BuilderImpl> eventSelectors) {
            this.eventSelectors = EventSelectorsCopier.copyFromBuilder(eventSelectors);
        }

        public final Collection<AdvancedEventSelector.Builder> getAdvancedEventSelectors() {
            if (this.advancedEventSelectors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.advancedEventSelectors != null ? (Collection)this.advancedEventSelectors.stream().map(AdvancedEventSelector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder advancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copy(advancedEventSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(AdvancedEventSelector ... advancedEventSelectors) {
            this.advancedEventSelectors(Arrays.asList(advancedEventSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder> ... advancedEventSelectors) {
            this.advancedEventSelectors(Stream.of(advancedEventSelectors).map(c -> (AdvancedEventSelector)((AdvancedEventSelector.Builder)AdvancedEventSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdvancedEventSelectors(Collection<AdvancedEventSelector.BuilderImpl> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copyFromBuilder(advancedEventSelectors);
        }

        @Override
        public GetEventSelectorsResponse build() {
            return new GetEventSelectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEventSelectorsResponse> {
        public Builder trailARN(String var1);

        public Builder eventSelectors(Collection<EventSelector> var1);

        public Builder eventSelectors(EventSelector ... var1);

        public Builder eventSelectors(Consumer<EventSelector.Builder> ... var1);

        public Builder advancedEventSelectors(Collection<AdvancedEventSelector> var1);

        public Builder advancedEventSelectors(AdvancedEventSelector ... var1);

        public Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder> ... var1);
    }
}

