/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an attribute and value that filter the events returned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LookupAttribute implements SdkPojo, Serializable, ToCopyableBuilder<LookupAttribute.Builder, LookupAttribute> {
    private static final SdkField<String> ATTRIBUTE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeKey").getter(getter(LookupAttribute::attributeKeyAsString))
            .setter(setter(Builder::attributeKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeKey").build()).build();

    private static final SdkField<String> ATTRIBUTE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeValue").getter(getter(LookupAttribute::attributeValue)).setter(setter(Builder::attributeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_KEY_FIELD,
            ATTRIBUTE_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributeKey;

    private final String attributeValue;

    private LookupAttribute(BuilderImpl builder) {
        this.attributeKey = builder.attributeKey;
        this.attributeValue = builder.attributeValue;
    }

    /**
     * <p>
     * Specifies an attribute on which to filter the events returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeKey} will
     * return {@link LookupAttributeKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeKeyAsString}.
     * </p>
     * 
     * @return Specifies an attribute on which to filter the events returned.
     * @see LookupAttributeKey
     */
    public final LookupAttributeKey attributeKey() {
        return LookupAttributeKey.fromValue(attributeKey);
    }

    /**
     * <p>
     * Specifies an attribute on which to filter the events returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeKey} will
     * return {@link LookupAttributeKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeKeyAsString}.
     * </p>
     * 
     * @return Specifies an attribute on which to filter the events returned.
     * @see LookupAttributeKey
     */
    public final String attributeKeyAsString() {
        return attributeKey;
    }

    /**
     * <p>
     * Specifies a value for the specified AttributeKey.
     * </p>
     * 
     * @return Specifies a value for the specified AttributeKey.
     */
    public final String attributeValue() {
        return attributeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attributeValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupAttribute)) {
            return false;
        }
        LookupAttribute other = (LookupAttribute) obj;
        return Objects.equals(attributeKeyAsString(), other.attributeKeyAsString())
                && Objects.equals(attributeValue(), other.attributeValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LookupAttribute").add("AttributeKey", attributeKeyAsString())
                .add("AttributeValue", attributeValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeKey":
            return Optional.ofNullable(clazz.cast(attributeKeyAsString()));
        case "AttributeValue":
            return Optional.ofNullable(clazz.cast(attributeValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LookupAttribute, T> g) {
        return obj -> g.apply((LookupAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LookupAttribute> {
        /**
         * <p>
         * Specifies an attribute on which to filter the events returned.
         * </p>
         * 
         * @param attributeKey
         *        Specifies an attribute on which to filter the events returned.
         * @see LookupAttributeKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookupAttributeKey
         */
        Builder attributeKey(String attributeKey);

        /**
         * <p>
         * Specifies an attribute on which to filter the events returned.
         * </p>
         * 
         * @param attributeKey
         *        Specifies an attribute on which to filter the events returned.
         * @see LookupAttributeKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookupAttributeKey
         */
        Builder attributeKey(LookupAttributeKey attributeKey);

        /**
         * <p>
         * Specifies a value for the specified AttributeKey.
         * </p>
         * 
         * @param attributeValue
         *        Specifies a value for the specified AttributeKey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValue(String attributeValue);
    }

    static final class BuilderImpl implements Builder {
        private String attributeKey;

        private String attributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(LookupAttribute model) {
            attributeKey(model.attributeKey);
            attributeValue(model.attributeValue);
        }

        public final String getAttributeKey() {
            return attributeKey;
        }

        public final void setAttributeKey(String attributeKey) {
            this.attributeKey = attributeKey;
        }

        @Override
        @Transient
        public final Builder attributeKey(String attributeKey) {
            this.attributeKey = attributeKey;
            return this;
        }

        @Override
        @Transient
        public final Builder attributeKey(LookupAttributeKey attributeKey) {
            this.attributeKey(attributeKey == null ? null : attributeKey.toString());
            return this;
        }

        public final String getAttributeValue() {
            return attributeValue;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        @Transient
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        @Override
        public LookupAttribute build() {
            return new LookupAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
