/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.TrailInfo;
import software.amazon.awssdk.services.cloudtrail.model.TrailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrailsResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, ListTrailsResponse> {
    private static final SdkField<List<TrailInfo>> TRAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Trails").getter(ListTrailsResponse.getter(ListTrailsResponse::trails)).setter(ListTrailsResponse.setter(Builder::trails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrailInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTrailsResponse.getter(ListTrailsResponse::nextToken)).setter(ListTrailsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAILS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TrailInfo> trails;
    private final String nextToken;

    private ListTrailsResponse(BuilderImpl builder) {
        super(builder);
        this.trails = builder.trails;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTrails() {
        return this.trails != null && !(this.trails instanceof SdkAutoConstructList);
    }

    public final List<TrailInfo> trails() {
        return this.trails;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrails() ? this.trails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrailsResponse)) {
            return false;
        }
        ListTrailsResponse other = (ListTrailsResponse)((Object)obj);
        return this.hasTrails() == other.hasTrails() && Objects.equals(this.trails(), other.trails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrailsResponse").add("Trails", this.hasTrails() ? this.trails() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Trails": {
                return Optional.ofNullable(clazz.cast(this.trails()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrailsResponse, T> g) {
        return obj -> g.apply((ListTrailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private List<TrailInfo> trails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrailsResponse model) {
            super(model);
            this.trails(model.trails);
            this.nextToken(model.nextToken);
        }

        public final List<TrailInfo.Builder> getTrails() {
            List<TrailInfo.Builder> result = TrailsCopier.copyToBuilder(this.trails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrails(Collection<TrailInfo.BuilderImpl> trails) {
            this.trails = TrailsCopier.copyFromBuilder(trails);
        }

        @Override
        @Transient
        public final Builder trails(Collection<TrailInfo> trails) {
            this.trails = TrailsCopier.copy(trails);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder trails(TrailInfo ... trails) {
            this.trails(Arrays.asList(trails));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder trails(Consumer<TrailInfo.Builder> ... trails) {
            this.trails(Stream.of(trails).map(c -> (TrailInfo)((TrailInfo.Builder)TrailInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTrailsResponse build() {
            return new ListTrailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrailsResponse> {
        public Builder trails(Collection<TrailInfo> var1);

        public Builder trails(TrailInfo ... var1);

        public Builder trails(Consumer<TrailInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

