/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.QueryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Query
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Query> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(Query.getter(Query::queryId)).setter(Query.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<String> QUERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryStatus").getter(Query.getter(Query::queryStatusAsString)).setter(Query.setter(Builder::queryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Query.getter(Query::creationTime)).setter(Query.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, QUERY_STATUS_FIELD, CREATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String queryId;
    private final String queryStatus;
    private final Instant creationTime;

    private Query(BuilderImpl builder) {
        this.queryId = builder.queryId;
        this.queryStatus = builder.queryStatus;
        this.creationTime = builder.creationTime;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final QueryStatus queryStatus() {
        return QueryStatus.fromValue(this.queryStatus);
    }

    public final String queryStatusAsString() {
        return this.queryStatus;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query other = (Query)obj;
        return Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.queryStatusAsString(), other.queryStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"Query").add("QueryId", (Object)this.queryId()).add("QueryStatus", (Object)this.queryStatusAsString()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "QueryStatus": {
                return Optional.ofNullable(clazz.cast(this.queryStatusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Query, T> g) {
        return obj -> g.apply((Query)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryId;
        private String queryStatus;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Query model) {
            this.queryId(model.queryId);
            this.queryStatus(model.queryStatus);
            this.creationTime(model.creationTime);
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        @Transient
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getQueryStatus() {
            return this.queryStatus;
        }

        public final void setQueryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
        }

        @Override
        @Transient
        public final Builder queryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder queryStatus(QueryStatus queryStatus) {
            this.queryStatus(queryStatus == null ? null : queryStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Query build() {
            return new Query(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Query> {
        public Builder queryId(String var1);

        public Builder queryStatus(String var1);

        public Builder queryStatus(QueryStatus var1);

        public Builder creationTime(Instant var1);
    }
}

