/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrailsResponse extends CloudTrailResponse implements
        ToCopyableBuilder<ListTrailsResponse.Builder, ListTrailsResponse> {
    private static final SdkField<List<TrailInfo>> TRAILS_FIELD = SdkField
            .<List<TrailInfo>> builder(MarshallingType.LIST)
            .memberName("Trails")
            .getter(getter(ListTrailsResponse::trails))
            .setter(setter(Builder::trails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrailInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrailInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTrailsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRAILS_FIELD, NEXT_TOKEN_FIELD));

    private final List<TrailInfo> trails;

    private final String nextToken;

    private ListTrailsResponse(BuilderImpl builder) {
        super(builder);
        this.trails = builder.trails;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Trails property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTrails() {
        return trails != null && !(trails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the name, ARN, and home region of trails in the current account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrails} method.
     * </p>
     * 
     * @return Returns the name, ARN, and home region of trails in the current account.
     */
    public final List<TrailInfo> trails() {
        return trails;
    }

    /**
     * <p>
     * The token to use to get the next page of results after a previous API call. If the token does not appear, there
     * are no more results to return. The token must be passed in with the same parameters as the previous call. For
     * example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with
     * NextToken should include those same parameters.
     * </p>
     * 
     * @return The token to use to get the next page of results after a previous API call. If the token does not appear,
     *         there are no more results to return. The token must be passed in with the same parameters as the previous
     *         call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root',
     *         the call with NextToken should include those same parameters.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTrails() ? trails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrailsResponse)) {
            return false;
        }
        ListTrailsResponse other = (ListTrailsResponse) obj;
        return hasTrails() == other.hasTrails() && Objects.equals(trails(), other.trails())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrailsResponse").add("Trails", hasTrails() ? trails() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Trails":
            return Optional.ofNullable(clazz.cast(trails()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrailsResponse, T> g) {
        return obj -> g.apply((ListTrailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTrailsResponse> {
        /**
         * <p>
         * Returns the name, ARN, and home region of trails in the current account.
         * </p>
         * 
         * @param trails
         *        Returns the name, ARN, and home region of trails in the current account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trails(Collection<TrailInfo> trails);

        /**
         * <p>
         * Returns the name, ARN, and home region of trails in the current account.
         * </p>
         * 
         * @param trails
         *        Returns the name, ARN, and home region of trails in the current account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trails(TrailInfo... trails);

        /**
         * <p>
         * Returns the name, ARN, and home region of trails in the current account.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TrailInfo>.Builder} avoiding the
         * need to create one manually via {@link List<TrailInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TrailInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #trails(List<TrailInfo>)}.
         * 
         * @param trails
         *        a consumer that will call methods on {@link List<TrailInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trails(List<TrailInfo>)
         */
        Builder trails(Consumer<TrailInfo.Builder>... trails);

        /**
         * <p>
         * The token to use to get the next page of results after a previous API call. If the token does not appear,
         * there are no more results to return. The token must be passed in with the same parameters as the previous
         * call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the
         * call with NextToken should include those same parameters.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next page of results after a previous API call. If the token does not
         *        appear, there are no more results to return. The token must be passed in with the same parameters as
         *        the previous call. For example, if the original call specified an AttributeKey of 'Username' with a
         *        value of 'root', the call with NextToken should include those same parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private List<TrailInfo> trails = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrailsResponse model) {
            super(model);
            trails(model.trails);
            nextToken(model.nextToken);
        }

        public final List<TrailInfo.Builder> getTrails() {
            List<TrailInfo.Builder> result = TrailsCopier.copyToBuilder(this.trails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrails(Collection<TrailInfo.BuilderImpl> trails) {
            this.trails = TrailsCopier.copyFromBuilder(trails);
        }

        @Override
        public final Builder trails(Collection<TrailInfo> trails) {
            this.trails = TrailsCopier.copy(trails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trails(TrailInfo... trails) {
            trails(Arrays.asList(trails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trails(Consumer<TrailInfo.Builder>... trails) {
            trails(Stream.of(trails).map(c -> TrailInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTrailsResponse build() {
            return new ListTrailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
