/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeQueryResponse extends CloudTrailResponse implements
        ToCopyableBuilder<DescribeQueryResponse.Builder, DescribeQueryResponse> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryId").getter(getter(DescribeQueryResponse::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(DescribeQueryResponse::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<String> QUERY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryStatus").getter(getter(DescribeQueryResponse::queryStatusAsString))
            .setter(setter(Builder::queryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatus").build()).build();

    private static final SdkField<QueryStatisticsForDescribeQuery> QUERY_STATISTICS_FIELD = SdkField
            .<QueryStatisticsForDescribeQuery> builder(MarshallingType.SDK_POJO).memberName("QueryStatistics")
            .getter(getter(DescribeQueryResponse::queryStatistics)).setter(setter(Builder::queryStatistics))
            .constructor(QueryStatisticsForDescribeQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatistics").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(DescribeQueryResponse::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD,
            QUERY_STRING_FIELD, QUERY_STATUS_FIELD, QUERY_STATISTICS_FIELD, ERROR_MESSAGE_FIELD));

    private final String queryId;

    private final String queryString;

    private final String queryStatus;

    private final QueryStatisticsForDescribeQuery queryStatistics;

    private final String errorMessage;

    private DescribeQueryResponse(BuilderImpl builder) {
        super(builder);
        this.queryId = builder.queryId;
        this.queryString = builder.queryString;
        this.queryStatus = builder.queryStatus;
        this.queryStatistics = builder.queryStatistics;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The ID of the query.
     * </p>
     * 
     * @return The ID of the query.
     */
    public final String queryId() {
        return queryId;
    }

    /**
     * <p>
     * The SQL code of a query.
     * </p>
     * 
     * @return The SQL code of a query.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The status of a query. Values for <code>QueryStatus</code> include <code>QUEUED</code>, <code>RUNNING</code>,
     * <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryStatus} will
     * return {@link QueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryStatusAsString}.
     * </p>
     * 
     * @return The status of a query. Values for <code>QueryStatus</code> include <code>QUEUED</code>,
     *         <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or
     *         <code>CANCELLED</code>
     * @see QueryStatus
     */
    public final QueryStatus queryStatus() {
        return QueryStatus.fromValue(queryStatus);
    }

    /**
     * <p>
     * The status of a query. Values for <code>QueryStatus</code> include <code>QUEUED</code>, <code>RUNNING</code>,
     * <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryStatus} will
     * return {@link QueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryStatusAsString}.
     * </p>
     * 
     * @return The status of a query. Values for <code>QueryStatus</code> include <code>QUEUED</code>,
     *         <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or
     *         <code>CANCELLED</code>
     * @see QueryStatus
     */
    public final String queryStatusAsString() {
        return queryStatus;
    }

    /**
     * <p>
     * Metadata about a query, including the number of events that were matched, the total number of events scanned, the
     * query run time in milliseconds, and the query's creation time.
     * </p>
     * 
     * @return Metadata about a query, including the number of events that were matched, the total number of events
     *         scanned, the query run time in milliseconds, and the query's creation time.
     */
    public final QueryStatisticsForDescribeQuery queryStatistics() {
        return queryStatistics;
    }

    /**
     * <p>
     * The error message returned if a query failed.
     * </p>
     * 
     * @return The error message returned if a query failed.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(queryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queryStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeQueryResponse)) {
            return false;
        }
        DescribeQueryResponse other = (DescribeQueryResponse) obj;
        return Objects.equals(queryId(), other.queryId()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(queryStatusAsString(), other.queryStatusAsString())
                && Objects.equals(queryStatistics(), other.queryStatistics())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeQueryResponse").add("QueryId", queryId()).add("QueryString", queryString())
                .add("QueryStatus", queryStatusAsString()).add("QueryStatistics", queryStatistics())
                .add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "QueryStatus":
            return Optional.ofNullable(clazz.cast(queryStatusAsString()));
        case "QueryStatistics":
            return Optional.ofNullable(clazz.cast(queryStatistics()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeQueryResponse, T> g) {
        return obj -> g.apply((DescribeQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeQueryResponse> {
        /**
         * <p>
         * The ID of the query.
         * </p>
         * 
         * @param queryId
         *        The ID of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * The SQL code of a query.
         * </p>
         * 
         * @param queryString
         *        The SQL code of a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The status of a query. Values for <code>QueryStatus</code> include <code>QUEUED</code>, <code>RUNNING</code>,
         * <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>
         * </p>
         * 
         * @param queryStatus
         *        The status of a query. Values for <code>QueryStatus</code> include <code>QUEUED</code>,
         *        <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or
         *        <code>CANCELLED</code>
         * @see QueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryStatus
         */
        Builder queryStatus(String queryStatus);

        /**
         * <p>
         * The status of a query. Values for <code>QueryStatus</code> include <code>QUEUED</code>, <code>RUNNING</code>,
         * <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>
         * </p>
         * 
         * @param queryStatus
         *        The status of a query. Values for <code>QueryStatus</code> include <code>QUEUED</code>,
         *        <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or
         *        <code>CANCELLED</code>
         * @see QueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryStatus
         */
        Builder queryStatus(QueryStatus queryStatus);

        /**
         * <p>
         * Metadata about a query, including the number of events that were matched, the total number of events scanned,
         * the query run time in milliseconds, and the query's creation time.
         * </p>
         * 
         * @param queryStatistics
         *        Metadata about a query, including the number of events that were matched, the total number of events
         *        scanned, the query run time in milliseconds, and the query's creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStatistics(QueryStatisticsForDescribeQuery queryStatistics);

        /**
         * <p>
         * Metadata about a query, including the number of events that were matched, the total number of events scanned,
         * the query run time in milliseconds, and the query's creation time.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryStatisticsForDescribeQuery.Builder}
         * avoiding the need to create one manually via {@link QueryStatisticsForDescribeQuery#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueryStatisticsForDescribeQuery.Builder#build()} is called
         * immediately and its result is passed to {@link #queryStatistics(QueryStatisticsForDescribeQuery)}.
         * 
         * @param queryStatistics
         *        a consumer that will call methods on {@link QueryStatisticsForDescribeQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryStatistics(QueryStatisticsForDescribeQuery)
         */
        default Builder queryStatistics(Consumer<QueryStatisticsForDescribeQuery.Builder> queryStatistics) {
            return queryStatistics(QueryStatisticsForDescribeQuery.builder().applyMutation(queryStatistics).build());
        }

        /**
         * <p>
         * The error message returned if a query failed.
         * </p>
         * 
         * @param errorMessage
         *        The error message returned if a query failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String queryId;

        private String queryString;

        private String queryStatus;

        private QueryStatisticsForDescribeQuery queryStatistics;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeQueryResponse model) {
            super(model);
            queryId(model.queryId);
            queryString(model.queryString);
            queryStatus(model.queryStatus);
            queryStatistics(model.queryStatistics);
            errorMessage(model.errorMessage);
        }

        public final String getQueryId() {
            return queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getQueryStatus() {
            return queryStatus;
        }

        public final void setQueryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
        }

        @Override
        public final Builder queryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
            return this;
        }

        @Override
        public final Builder queryStatus(QueryStatus queryStatus) {
            this.queryStatus(queryStatus == null ? null : queryStatus.toString());
            return this;
        }

        public final QueryStatisticsForDescribeQuery.Builder getQueryStatistics() {
            return queryStatistics != null ? queryStatistics.toBuilder() : null;
        }

        public final void setQueryStatistics(QueryStatisticsForDescribeQuery.BuilderImpl queryStatistics) {
            this.queryStatistics = queryStatistics != null ? queryStatistics.build() : null;
        }

        @Override
        public final Builder queryStatistics(QueryStatisticsForDescribeQuery queryStatistics) {
            this.queryStatistics = queryStatistics;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public DescribeQueryResponse build() {
            return new DescribeQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
