/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelQueryRequest extends CloudTrailRequest implements
        ToCopyableBuilder<CancelQueryRequest.Builder, CancelQueryRequest> {
    private static final SdkField<String> EVENT_DATA_STORE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventDataStore").getter(getter(CancelQueryRequest::eventDataStore))
            .setter(setter(Builder::eventDataStore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStore").build()).build();

    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryId").getter(getter(CancelQueryRequest::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_FIELD,
            QUERY_ID_FIELD));

    private final String eventDataStore;

    private final String queryId;

    private CancelQueryRequest(BuilderImpl builder) {
        super(builder);
        this.eventDataStore = builder.eventDataStore;
        this.queryId = builder.queryId;
    }

    /**
     * <p>
     * The ARN (or the ID suffix of the ARN) of an event data store on which the specified query is running.
     * </p>
     * 
     * @return The ARN (or the ID suffix of the ARN) of an event data store on which the specified query is running.
     */
    public final String eventDataStore() {
        return eventDataStore;
    }

    /**
     * <p>
     * The ID of the query that you want to cancel. The <code>QueryId</code> comes from the response of a
     * <code>StartQuery</code> operation.
     * </p>
     * 
     * @return The ID of the query that you want to cancel. The <code>QueryId</code> comes from the response of a
     *         <code>StartQuery</code> operation.
     */
    public final String queryId() {
        return queryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventDataStore());
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelQueryRequest)) {
            return false;
        }
        CancelQueryRequest other = (CancelQueryRequest) obj;
        return Objects.equals(eventDataStore(), other.eventDataStore()) && Objects.equals(queryId(), other.queryId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelQueryRequest").add("EventDataStore", eventDataStore()).add("QueryId", queryId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventDataStore":
            return Optional.ofNullable(clazz.cast(eventDataStore()));
        case "QueryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelQueryRequest, T> g) {
        return obj -> g.apply((CancelQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CancelQueryRequest> {
        /**
         * <p>
         * The ARN (or the ID suffix of the ARN) of an event data store on which the specified query is running.
         * </p>
         * 
         * @param eventDataStore
         *        The ARN (or the ID suffix of the ARN) of an event data store on which the specified query is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataStore(String eventDataStore);

        /**
         * <p>
         * The ID of the query that you want to cancel. The <code>QueryId</code> comes from the response of a
         * <code>StartQuery</code> operation.
         * </p>
         * 
         * @param queryId
         *        The ID of the query that you want to cancel. The <code>QueryId</code> comes from the response of a
         *        <code>StartQuery</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String eventDataStore;

        private String queryId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelQueryRequest model) {
            super(model);
            eventDataStore(model.eventDataStore);
            queryId(model.queryId);
        }

        public final String getEventDataStore() {
            return eventDataStore;
        }

        public final void setEventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
        }

        @Override
        public final Builder eventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
            return this;
        }

        public final String getQueryId() {
            return queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelQueryRequest build() {
            return new CancelQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
