/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInsightSelectorsResponse extends CloudTrailResponse implements
        ToCopyableBuilder<GetInsightSelectorsResponse.Builder, GetInsightSelectorsResponse> {
    private static final SdkField<String> TRAIL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrailARN").getter(getter(GetInsightSelectorsResponse::trailARN)).setter(setter(Builder::trailARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailARN").build()).build();

    private static final SdkField<List<InsightSelector>> INSIGHT_SELECTORS_FIELD = SdkField
            .<List<InsightSelector>> builder(MarshallingType.LIST)
            .memberName("InsightSelectors")
            .getter(getter(GetInsightSelectorsResponse::insightSelectors))
            .setter(setter(Builder::insightSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightSelectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InsightSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(InsightSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_ARN_FIELD,
            INSIGHT_SELECTORS_FIELD));

    private final String trailARN;

    private final List<InsightSelector> insightSelectors;

    private GetInsightSelectorsResponse(BuilderImpl builder) {
        super(builder);
        this.trailARN = builder.trailARN;
        this.insightSelectors = builder.insightSelectors;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a trail for which you want to get Insights selectors.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a trail for which you want to get Insights selectors.
     */
    public final String trailARN() {
        return trailARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the InsightSelectors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInsightSelectors() {
        return insightSelectors != null && !(insightSelectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON string that contains the insight types you want to log on a trail. In this release,
     * <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code> are supported as insight types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInsightSelectors} method.
     * </p>
     * 
     * @return A JSON string that contains the insight types you want to log on a trail. In this release,
     *         <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code> are supported as insight types.
     */
    public final List<InsightSelector> insightSelectors() {
        return insightSelectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trailARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasInsightSelectors() ? insightSelectors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightSelectorsResponse)) {
            return false;
        }
        GetInsightSelectorsResponse other = (GetInsightSelectorsResponse) obj;
        return Objects.equals(trailARN(), other.trailARN()) && hasInsightSelectors() == other.hasInsightSelectors()
                && Objects.equals(insightSelectors(), other.insightSelectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInsightSelectorsResponse").add("TrailARN", trailARN())
                .add("InsightSelectors", hasInsightSelectors() ? insightSelectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrailARN":
            return Optional.ofNullable(clazz.cast(trailARN()));
        case "InsightSelectors":
            return Optional.ofNullable(clazz.cast(insightSelectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInsightSelectorsResponse, T> g) {
        return obj -> g.apply((GetInsightSelectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInsightSelectorsResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a trail for which you want to get Insights selectors.
         * </p>
         * 
         * @param trailARN
         *        The Amazon Resource Name (ARN) of a trail for which you want to get Insights selectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailARN(String trailARN);

        /**
         * <p>
         * A JSON string that contains the insight types you want to log on a trail. In this release,
         * <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code> are supported as insight types.
         * </p>
         * 
         * @param insightSelectors
         *        A JSON string that contains the insight types you want to log on a trail. In this release,
         *        <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code> are supported as insight types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightSelectors(Collection<InsightSelector> insightSelectors);

        /**
         * <p>
         * A JSON string that contains the insight types you want to log on a trail. In this release,
         * <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code> are supported as insight types.
         * </p>
         * 
         * @param insightSelectors
         *        A JSON string that contains the insight types you want to log on a trail. In this release,
         *        <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code> are supported as insight types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightSelectors(InsightSelector... insightSelectors);

        /**
         * <p>
         * A JSON string that contains the insight types you want to log on a trail. In this release,
         * <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code> are supported as insight types.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<InsightSelector>.Builder} avoiding
         * the need to create one manually via {@link List<InsightSelector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InsightSelector>.Builder#build()} is called immediately and
         * its result is passed to {@link #insightSelectors(List<InsightSelector>)}.
         * 
         * @param insightSelectors
         *        a consumer that will call methods on {@link List<InsightSelector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightSelectors(List<InsightSelector>)
         */
        Builder insightSelectors(Consumer<InsightSelector.Builder>... insightSelectors);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String trailARN;

        private List<InsightSelector> insightSelectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightSelectorsResponse model) {
            super(model);
            trailARN(model.trailARN);
            insightSelectors(model.insightSelectors);
        }

        public final String getTrailARN() {
            return trailARN;
        }

        public final void setTrailARN(String trailARN) {
            this.trailARN = trailARN;
        }

        @Override
        public final Builder trailARN(String trailARN) {
            this.trailARN = trailARN;
            return this;
        }

        public final List<InsightSelector.Builder> getInsightSelectors() {
            List<InsightSelector.Builder> result = InsightSelectorsCopier.copyToBuilder(this.insightSelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsightSelectors(Collection<InsightSelector.BuilderImpl> insightSelectors) {
            this.insightSelectors = InsightSelectorsCopier.copyFromBuilder(insightSelectors);
        }

        @Override
        public final Builder insightSelectors(Collection<InsightSelector> insightSelectors) {
            this.insightSelectors = InsightSelectorsCopier.copy(insightSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightSelectors(InsightSelector... insightSelectors) {
            insightSelectors(Arrays.asList(insightSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightSelectors(Consumer<InsightSelector.Builder>... insightSelectors) {
            insightSelectors(Stream.of(insightSelectors).map(c -> InsightSelector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetInsightSelectorsResponse build() {
            return new GetInsightSelectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
