/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetChannelResponse extends CloudTrailResponse implements
        ToCopyableBuilder<GetChannelResponse.Builder, GetChannelResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(GetChannelResponse::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetChannelResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(GetChannelResponse::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<SourceConfig> SOURCE_CONFIG_FIELD = SdkField.<SourceConfig> builder(MarshallingType.SDK_POJO)
            .memberName("SourceConfig").getter(getter(GetChannelResponse::sourceConfig)).setter(setter(Builder::sourceConfig))
            .constructor(SourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConfig").build()).build();

    private static final SdkField<List<Destination>> DESTINATIONS_FIELD = SdkField
            .<List<Destination>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(GetChannelResponse::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Destination> builder(MarshallingType.SDK_POJO)
                                            .constructor(Destination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, NAME_FIELD,
            SOURCE_FIELD, SOURCE_CONFIG_FIELD, DESTINATIONS_FIELD));

    private final String channelArn;

    private final String name;

    private final String source;

    private final SourceConfig sourceConfig;

    private final List<Destination> destinations;

    private GetChannelResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.name = builder.name;
        this.source = builder.source;
        this.sourceConfig = builder.sourceConfig;
        this.destinations = builder.destinations;
    }

    /**
     * <p>
     * The ARN of the CloudTrail service-linked channel.
     * </p>
     * 
     * @return The ARN of the CloudTrail service-linked channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The name of the CloudTrail service-linked channel. For service-linked channels, the value is
     * <code>aws-service-channel/service-name/custom-suffix</code> where <code>service-name</code> represents the name
     * of the Amazon Web Services service that created the channel and <code>custom-suffix</code> represents the suffix
     * generated by the Amazon Web Services service.
     * </p>
     * 
     * @return The name of the CloudTrail service-linked channel. For service-linked channels, the value is
     *         <code>aws-service-channel/service-name/custom-suffix</code> where <code>service-name</code> represents
     *         the name of the Amazon Web Services service that created the channel and <code>custom-suffix</code>
     *         represents the suffix generated by the Amazon Web Services service.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The trail or event data store for the CloudTrail service-linked channel.
     * </p>
     * 
     * @return The trail or event data store for the CloudTrail service-linked channel.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * Provides information about the advanced event selectors configured for the service-linked channel, and whether
     * the service-linked channel applies to all regions or one region.
     * </p>
     * 
     * @return Provides information about the advanced event selectors configured for the service-linked channel, and
     *         whether the service-linked channel applies to all regions or one region.
     */
    public final SourceConfig sourceConfig() {
        return sourceConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services service that created the CloudTrail service-linked channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return The Amazon Web Services service that created the CloudTrail service-linked channel.
     */
    public final List<Destination> destinations() {
        return destinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(sourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChannelResponse)) {
            return false;
        }
        GetChannelResponse other = (GetChannelResponse) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(name(), other.name())
                && Objects.equals(source(), other.source()) && Objects.equals(sourceConfig(), other.sourceConfig())
                && hasDestinations() == other.hasDestinations() && Objects.equals(destinations(), other.destinations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetChannelResponse").add("ChannelArn", channelArn()).add("Name", name()).add("Source", source())
                .add("SourceConfig", sourceConfig()).add("Destinations", hasDestinations() ? destinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "SourceConfig":
            return Optional.ofNullable(clazz.cast(sourceConfig()));
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetChannelResponse, T> g) {
        return obj -> g.apply((GetChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetChannelResponse> {
        /**
         * <p>
         * The ARN of the CloudTrail service-linked channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the CloudTrail service-linked channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The name of the CloudTrail service-linked channel. For service-linked channels, the value is
         * <code>aws-service-channel/service-name/custom-suffix</code> where <code>service-name</code> represents the
         * name of the Amazon Web Services service that created the channel and <code>custom-suffix</code> represents
         * the suffix generated by the Amazon Web Services service.
         * </p>
         * 
         * @param name
         *        The name of the CloudTrail service-linked channel. For service-linked channels, the value is
         *        <code>aws-service-channel/service-name/custom-suffix</code> where <code>service-name</code> represents
         *        the name of the Amazon Web Services service that created the channel and <code>custom-suffix</code>
         *        represents the suffix generated by the Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The trail or event data store for the CloudTrail service-linked channel.
         * </p>
         * 
         * @param source
         *        The trail or event data store for the CloudTrail service-linked channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * Provides information about the advanced event selectors configured for the service-linked channel, and
         * whether the service-linked channel applies to all regions or one region.
         * </p>
         * 
         * @param sourceConfig
         *        Provides information about the advanced event selectors configured for the service-linked channel, and
         *        whether the service-linked channel applies to all regions or one region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConfig(SourceConfig sourceConfig);

        /**
         * <p>
         * Provides information about the advanced event selectors configured for the service-linked channel, and
         * whether the service-linked channel applies to all regions or one region.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceConfig.Builder} avoiding the need
         * to create one manually via {@link SourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceConfig(SourceConfig)}.
         * 
         * @param sourceConfig
         *        a consumer that will call methods on {@link SourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceConfig(SourceConfig)
         */
        default Builder sourceConfig(Consumer<SourceConfig.Builder> sourceConfig) {
            return sourceConfig(SourceConfig.builder().applyMutation(sourceConfig).build());
        }

        /**
         * <p>
         * The Amazon Web Services service that created the CloudTrail service-linked channel.
         * </p>
         * 
         * @param destinations
         *        The Amazon Web Services service that created the CloudTrail service-linked channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<Destination> destinations);

        /**
         * <p>
         * The Amazon Web Services service that created the CloudTrail service-linked channel.
         * </p>
         * 
         * @param destinations
         *        The Amazon Web Services service that created the CloudTrail service-linked channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Destination... destinations);

        /**
         * <p>
         * The Amazon Web Services service that created the CloudTrail service-linked channel.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.Destination.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudtrail.model.Destination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.Destination.Builder#build()} is called immediately
         * and its result is passed to {@link #destinations(List<Destination>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(java.util.Collection<Destination>)
         */
        Builder destinations(Consumer<Destination.Builder>... destinations);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String channelArn;

        private String name;

        private String source;

        private SourceConfig sourceConfig;

        private List<Destination> destinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetChannelResponse model) {
            super(model);
            channelArn(model.channelArn);
            name(model.name);
            source(model.source);
            sourceConfig(model.sourceConfig);
            destinations(model.destinations);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final SourceConfig.Builder getSourceConfig() {
            return sourceConfig != null ? sourceConfig.toBuilder() : null;
        }

        public final void setSourceConfig(SourceConfig.BuilderImpl sourceConfig) {
            this.sourceConfig = sourceConfig != null ? sourceConfig.build() : null;
        }

        @Override
        public final Builder sourceConfig(SourceConfig sourceConfig) {
            this.sourceConfig = sourceConfig;
            return this;
        }

        public final List<Destination.Builder> getDestinations() {
            List<Destination.Builder> result = DestinationsCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<Destination.BuilderImpl> destinations) {
            this.destinations = DestinationsCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<Destination> destinations) {
            this.destinations = DestinationsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Destination... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<Destination.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> Destination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetChannelResponse build() {
            return new GetChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
