/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEventDataStoreRequest extends CloudTrailRequest implements
        ToCopyableBuilder<UpdateEventDataStoreRequest.Builder, UpdateEventDataStoreRequest> {
    private static final SdkField<String> EVENT_DATA_STORE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventDataStore").getter(getter(UpdateEventDataStoreRequest::eventDataStore))
            .setter(setter(Builder::eventDataStore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStore").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateEventDataStoreRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<AdvancedEventSelector>> ADVANCED_EVENT_SELECTORS_FIELD = SdkField
            .<List<AdvancedEventSelector>> builder(MarshallingType.LIST)
            .memberName("AdvancedEventSelectors")
            .getter(getter(UpdateEventDataStoreRequest::advancedEventSelectors))
            .setter(setter(Builder::advancedEventSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedEventSelectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdvancedEventSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdvancedEventSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> MULTI_REGION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiRegionEnabled").getter(getter(UpdateEventDataStoreRequest::multiRegionEnabled))
            .setter(setter(Builder::multiRegionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionEnabled").build())
            .build();

    private static final SdkField<Boolean> ORGANIZATION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OrganizationEnabled").getter(getter(UpdateEventDataStoreRequest::organizationEnabled))
            .setter(setter(Builder::organizationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationEnabled").build())
            .build();

    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetentionPeriod").getter(getter(UpdateEventDataStoreRequest::retentionPeriod))
            .setter(setter(Builder::retentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()).build();

    private static final SdkField<Boolean> TERMINATION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TerminationProtectionEnabled")
            .getter(getter(UpdateEventDataStoreRequest::terminationProtectionEnabled))
            .setter(setter(Builder::terminationProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtectionEnabled")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_FIELD,
            NAME_FIELD, ADVANCED_EVENT_SELECTORS_FIELD, MULTI_REGION_ENABLED_FIELD, ORGANIZATION_ENABLED_FIELD,
            RETENTION_PERIOD_FIELD, TERMINATION_PROTECTION_ENABLED_FIELD));

    private final String eventDataStore;

    private final String name;

    private final List<AdvancedEventSelector> advancedEventSelectors;

    private final Boolean multiRegionEnabled;

    private final Boolean organizationEnabled;

    private final Integer retentionPeriod;

    private final Boolean terminationProtectionEnabled;

    private UpdateEventDataStoreRequest(BuilderImpl builder) {
        super(builder);
        this.eventDataStore = builder.eventDataStore;
        this.name = builder.name;
        this.advancedEventSelectors = builder.advancedEventSelectors;
        this.multiRegionEnabled = builder.multiRegionEnabled;
        this.organizationEnabled = builder.organizationEnabled;
        this.retentionPeriod = builder.retentionPeriod;
        this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
    }

    /**
     * <p>
     * The ARN (or the ID suffix of the ARN) of the event data store that you want to update.
     * </p>
     * 
     * @return The ARN (or the ID suffix of the ARN) of the event data store that you want to update.
     */
    public final String eventDataStore() {
        return eventDataStore;
    }

    /**
     * <p>
     * The event data store name.
     * </p>
     * 
     * @return The event data store name.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdvancedEventSelectors property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdvancedEventSelectors() {
        return advancedEventSelectors != null && !(advancedEventSelectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The advanced event selectors used to select events for the event data store. You can configure up to five
     * advanced event selectors for each event data store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdvancedEventSelectors} method.
     * </p>
     * 
     * @return The advanced event selectors used to select events for the event data store. You can configure up to five
     *         advanced event selectors for each event data store.
     */
    public final List<AdvancedEventSelector> advancedEventSelectors() {
        return advancedEventSelectors;
    }

    /**
     * <p>
     * Specifies whether an event data store collects events from all regions, or only from the region in which it was
     * created.
     * </p>
     * 
     * @return Specifies whether an event data store collects events from all regions, or only from the region in which
     *         it was created.
     */
    public final Boolean multiRegionEnabled() {
        return multiRegionEnabled;
    }

    /**
     * <p>
     * Specifies whether an event data store collects events logged for an organization in Organizations.
     * </p>
     * 
     * @return Specifies whether an event data store collects events logged for an organization in Organizations.
     */
    public final Boolean organizationEnabled() {
        return organizationEnabled;
    }

    /**
     * <p>
     * The retention period, in days.
     * </p>
     * 
     * @return The retention period, in days.
     */
    public final Integer retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * Indicates that termination protection is enabled and the event data store cannot be automatically deleted.
     * </p>
     * 
     * @return Indicates that termination protection is enabled and the event data store cannot be automatically
     *         deleted.
     */
    public final Boolean terminationProtectionEnabled() {
        return terminationProtectionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventDataStore());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdvancedEventSelectors() ? advancedEventSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(organizationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(terminationProtectionEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventDataStoreRequest)) {
            return false;
        }
        UpdateEventDataStoreRequest other = (UpdateEventDataStoreRequest) obj;
        return Objects.equals(eventDataStore(), other.eventDataStore()) && Objects.equals(name(), other.name())
                && hasAdvancedEventSelectors() == other.hasAdvancedEventSelectors()
                && Objects.equals(advancedEventSelectors(), other.advancedEventSelectors())
                && Objects.equals(multiRegionEnabled(), other.multiRegionEnabled())
                && Objects.equals(organizationEnabled(), other.organizationEnabled())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(terminationProtectionEnabled(), other.terminationProtectionEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEventDataStoreRequest").add("EventDataStore", eventDataStore()).add("Name", name())
                .add("AdvancedEventSelectors", hasAdvancedEventSelectors() ? advancedEventSelectors() : null)
                .add("MultiRegionEnabled", multiRegionEnabled()).add("OrganizationEnabled", organizationEnabled())
                .add("RetentionPeriod", retentionPeriod()).add("TerminationProtectionEnabled", terminationProtectionEnabled())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventDataStore":
            return Optional.ofNullable(clazz.cast(eventDataStore()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AdvancedEventSelectors":
            return Optional.ofNullable(clazz.cast(advancedEventSelectors()));
        case "MultiRegionEnabled":
            return Optional.ofNullable(clazz.cast(multiRegionEnabled()));
        case "OrganizationEnabled":
            return Optional.ofNullable(clazz.cast(organizationEnabled()));
        case "RetentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "TerminationProtectionEnabled":
            return Optional.ofNullable(clazz.cast(terminationProtectionEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventDataStoreRequest, T> g) {
        return obj -> g.apply((UpdateEventDataStoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEventDataStoreRequest> {
        /**
         * <p>
         * The ARN (or the ID suffix of the ARN) of the event data store that you want to update.
         * </p>
         * 
         * @param eventDataStore
         *        The ARN (or the ID suffix of the ARN) of the event data store that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataStore(String eventDataStore);

        /**
         * <p>
         * The event data store name.
         * </p>
         * 
         * @param name
         *        The event data store name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The advanced event selectors used to select events for the event data store. You can configure up to five
         * advanced event selectors for each event data store.
         * </p>
         * 
         * @param advancedEventSelectors
         *        The advanced event selectors used to select events for the event data store. You can configure up to
         *        five advanced event selectors for each event data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors);

        /**
         * <p>
         * The advanced event selectors used to select events for the event data store. You can configure up to five
         * advanced event selectors for each event data store.
         * </p>
         * 
         * @param advancedEventSelectors
         *        The advanced event selectors used to select events for the event data store. You can configure up to
         *        five advanced event selectors for each event data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedEventSelectors(AdvancedEventSelector... advancedEventSelectors);

        /**
         * <p>
         * The advanced event selectors used to select events for the event data store. You can configure up to five
         * advanced event selectors for each event data store.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector.Builder#build()} is called
         * immediately and its result is passed to {@link #advancedEventSelectors(List<AdvancedEventSelector>)}.
         * 
         * @param advancedEventSelectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedEventSelectors(java.util.Collection<AdvancedEventSelector>)
         */
        Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder>... advancedEventSelectors);

        /**
         * <p>
         * Specifies whether an event data store collects events from all regions, or only from the region in which it
         * was created.
         * </p>
         * 
         * @param multiRegionEnabled
         *        Specifies whether an event data store collects events from all regions, or only from the region in
         *        which it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionEnabled(Boolean multiRegionEnabled);

        /**
         * <p>
         * Specifies whether an event data store collects events logged for an organization in Organizations.
         * </p>
         * 
         * @param organizationEnabled
         *        Specifies whether an event data store collects events logged for an organization in Organizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationEnabled(Boolean organizationEnabled);

        /**
         * <p>
         * The retention period, in days.
         * </p>
         * 
         * @param retentionPeriod
         *        The retention period, in days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(Integer retentionPeriod);

        /**
         * <p>
         * Indicates that termination protection is enabled and the event data store cannot be automatically deleted.
         * </p>
         * 
         * @param terminationProtectionEnabled
         *        Indicates that termination protection is enabled and the event data store cannot be automatically
         *        deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String eventDataStore;

        private String name;

        private List<AdvancedEventSelector> advancedEventSelectors = DefaultSdkAutoConstructList.getInstance();

        private Boolean multiRegionEnabled;

        private Boolean organizationEnabled;

        private Integer retentionPeriod;

        private Boolean terminationProtectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventDataStoreRequest model) {
            super(model);
            eventDataStore(model.eventDataStore);
            name(model.name);
            advancedEventSelectors(model.advancedEventSelectors);
            multiRegionEnabled(model.multiRegionEnabled);
            organizationEnabled(model.organizationEnabled);
            retentionPeriod(model.retentionPeriod);
            terminationProtectionEnabled(model.terminationProtectionEnabled);
        }

        public final String getEventDataStore() {
            return eventDataStore;
        }

        public final void setEventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
        }

        @Override
        public final Builder eventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AdvancedEventSelector.Builder> getAdvancedEventSelectors() {
            List<AdvancedEventSelector.Builder> result = AdvancedEventSelectorsCopier.copyToBuilder(this.advancedEventSelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedEventSelectors(Collection<AdvancedEventSelector.BuilderImpl> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copyFromBuilder(advancedEventSelectors);
        }

        @Override
        public final Builder advancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copy(advancedEventSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(AdvancedEventSelector... advancedEventSelectors) {
            advancedEventSelectors(Arrays.asList(advancedEventSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder>... advancedEventSelectors) {
            advancedEventSelectors(Stream.of(advancedEventSelectors)
                    .map(c -> AdvancedEventSelector.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getMultiRegionEnabled() {
            return multiRegionEnabled;
        }

        public final void setMultiRegionEnabled(Boolean multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
        }

        @Override
        public final Builder multiRegionEnabled(Boolean multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
            return this;
        }

        public final Boolean getOrganizationEnabled() {
            return organizationEnabled;
        }

        public final void setOrganizationEnabled(Boolean organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
        }

        @Override
        public final Builder organizationEnabled(Boolean organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
            return this;
        }

        public final Integer getRetentionPeriod() {
            return retentionPeriod;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final Boolean getTerminationProtectionEnabled() {
            return terminationProtectionEnabled;
        }

        public final void setTerminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
        }

        @Override
        public final Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventDataStoreRequest build() {
            return new UpdateEventDataStoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
