/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the objects or data listed below if successful. Otherwise, returns an error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTrailStatusResponse extends CloudTrailResponse implements
        ToCopyableBuilder<GetTrailStatusResponse.Builder, GetTrailStatusResponse> {
    private static final SdkField<Boolean> IS_LOGGING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsLogging").getter(getter(GetTrailStatusResponse::isLogging)).setter(setter(Builder::isLogging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLogging").build()).build();

    private static final SdkField<String> LATEST_DELIVERY_ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestDeliveryError").getter(getter(GetTrailStatusResponse::latestDeliveryError))
            .setter(setter(Builder::latestDeliveryError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDeliveryError").build())
            .build();

    private static final SdkField<String> LATEST_NOTIFICATION_ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestNotificationError").getter(getter(GetTrailStatusResponse::latestNotificationError))
            .setter(setter(Builder::latestNotificationError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestNotificationError").build())
            .build();

    private static final SdkField<Instant> LATEST_DELIVERY_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestDeliveryTime").getter(getter(GetTrailStatusResponse::latestDeliveryTime))
            .setter(setter(Builder::latestDeliveryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDeliveryTime").build())
            .build();

    private static final SdkField<Instant> LATEST_NOTIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestNotificationTime").getter(getter(GetTrailStatusResponse::latestNotificationTime))
            .setter(setter(Builder::latestNotificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestNotificationTime").build())
            .build();

    private static final SdkField<Instant> START_LOGGING_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartLoggingTime").getter(getter(GetTrailStatusResponse::startLoggingTime))
            .setter(setter(Builder::startLoggingTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartLoggingTime").build()).build();

    private static final SdkField<Instant> STOP_LOGGING_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StopLoggingTime").getter(getter(GetTrailStatusResponse::stopLoggingTime))
            .setter(setter(Builder::stopLoggingTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopLoggingTime").build()).build();

    private static final SdkField<String> LATEST_CLOUD_WATCH_LOGS_DELIVERY_ERROR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LatestCloudWatchLogsDeliveryError")
            .getter(getter(GetTrailStatusResponse::latestCloudWatchLogsDeliveryError))
            .setter(setter(Builder::latestCloudWatchLogsDeliveryError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestCloudWatchLogsDeliveryError")
                    .build()).build();

    private static final SdkField<Instant> LATEST_CLOUD_WATCH_LOGS_DELIVERY_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestCloudWatchLogsDeliveryTime")
            .getter(getter(GetTrailStatusResponse::latestCloudWatchLogsDeliveryTime))
            .setter(setter(Builder::latestCloudWatchLogsDeliveryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestCloudWatchLogsDeliveryTime")
                    .build()).build();

    private static final SdkField<Instant> LATEST_DIGEST_DELIVERY_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("LatestDigestDeliveryTime")
            .getter(getter(GetTrailStatusResponse::latestDigestDeliveryTime)).setter(setter(Builder::latestDigestDeliveryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDigestDeliveryTime").build())
            .build();

    private static final SdkField<String> LATEST_DIGEST_DELIVERY_ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestDigestDeliveryError").getter(getter(GetTrailStatusResponse::latestDigestDeliveryError))
            .setter(setter(Builder::latestDigestDeliveryError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDigestDeliveryError").build())
            .build();

    private static final SdkField<String> LATEST_DELIVERY_ATTEMPT_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestDeliveryAttemptTime").getter(getter(GetTrailStatusResponse::latestDeliveryAttemptTime))
            .setter(setter(Builder::latestDeliveryAttemptTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDeliveryAttemptTime").build())
            .build();

    private static final SdkField<String> LATEST_NOTIFICATION_ATTEMPT_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LatestNotificationAttemptTime")
            .getter(getter(GetTrailStatusResponse::latestNotificationAttemptTime))
            .setter(setter(Builder::latestNotificationAttemptTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestNotificationAttemptTime")
                    .build()).build();

    private static final SdkField<String> LATEST_NOTIFICATION_ATTEMPT_SUCCEEDED_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LatestNotificationAttemptSucceeded")
            .getter(getter(GetTrailStatusResponse::latestNotificationAttemptSucceeded))
            .setter(setter(Builder::latestNotificationAttemptSucceeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestNotificationAttemptSucceeded")
                    .build()).build();

    private static final SdkField<String> LATEST_DELIVERY_ATTEMPT_SUCCEEDED_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LatestDeliveryAttemptSucceeded")
            .getter(getter(GetTrailStatusResponse::latestDeliveryAttemptSucceeded))
            .setter(setter(Builder::latestDeliveryAttemptSucceeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDeliveryAttemptSucceeded")
                    .build()).build();

    private static final SdkField<String> TIME_LOGGING_STARTED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeLoggingStarted").getter(getter(GetTrailStatusResponse::timeLoggingStarted))
            .setter(setter(Builder::timeLoggingStarted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeLoggingStarted").build())
            .build();

    private static final SdkField<String> TIME_LOGGING_STOPPED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeLoggingStopped").getter(getter(GetTrailStatusResponse::timeLoggingStopped))
            .setter(setter(Builder::timeLoggingStopped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeLoggingStopped").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_LOGGING_FIELD,
            LATEST_DELIVERY_ERROR_FIELD, LATEST_NOTIFICATION_ERROR_FIELD, LATEST_DELIVERY_TIME_FIELD,
            LATEST_NOTIFICATION_TIME_FIELD, START_LOGGING_TIME_FIELD, STOP_LOGGING_TIME_FIELD,
            LATEST_CLOUD_WATCH_LOGS_DELIVERY_ERROR_FIELD, LATEST_CLOUD_WATCH_LOGS_DELIVERY_TIME_FIELD,
            LATEST_DIGEST_DELIVERY_TIME_FIELD, LATEST_DIGEST_DELIVERY_ERROR_FIELD, LATEST_DELIVERY_ATTEMPT_TIME_FIELD,
            LATEST_NOTIFICATION_ATTEMPT_TIME_FIELD, LATEST_NOTIFICATION_ATTEMPT_SUCCEEDED_FIELD,
            LATEST_DELIVERY_ATTEMPT_SUCCEEDED_FIELD, TIME_LOGGING_STARTED_FIELD, TIME_LOGGING_STOPPED_FIELD));

    private final Boolean isLogging;

    private final String latestDeliveryError;

    private final String latestNotificationError;

    private final Instant latestDeliveryTime;

    private final Instant latestNotificationTime;

    private final Instant startLoggingTime;

    private final Instant stopLoggingTime;

    private final String latestCloudWatchLogsDeliveryError;

    private final Instant latestCloudWatchLogsDeliveryTime;

    private final Instant latestDigestDeliveryTime;

    private final String latestDigestDeliveryError;

    private final String latestDeliveryAttemptTime;

    private final String latestNotificationAttemptTime;

    private final String latestNotificationAttemptSucceeded;

    private final String latestDeliveryAttemptSucceeded;

    private final String timeLoggingStarted;

    private final String timeLoggingStopped;

    private GetTrailStatusResponse(BuilderImpl builder) {
        super(builder);
        this.isLogging = builder.isLogging;
        this.latestDeliveryError = builder.latestDeliveryError;
        this.latestNotificationError = builder.latestNotificationError;
        this.latestDeliveryTime = builder.latestDeliveryTime;
        this.latestNotificationTime = builder.latestNotificationTime;
        this.startLoggingTime = builder.startLoggingTime;
        this.stopLoggingTime = builder.stopLoggingTime;
        this.latestCloudWatchLogsDeliveryError = builder.latestCloudWatchLogsDeliveryError;
        this.latestCloudWatchLogsDeliveryTime = builder.latestCloudWatchLogsDeliveryTime;
        this.latestDigestDeliveryTime = builder.latestDigestDeliveryTime;
        this.latestDigestDeliveryError = builder.latestDigestDeliveryError;
        this.latestDeliveryAttemptTime = builder.latestDeliveryAttemptTime;
        this.latestNotificationAttemptTime = builder.latestNotificationAttemptTime;
        this.latestNotificationAttemptSucceeded = builder.latestNotificationAttemptSucceeded;
        this.latestDeliveryAttemptSucceeded = builder.latestDeliveryAttemptSucceeded;
        this.timeLoggingStarted = builder.timeLoggingStarted;
        this.timeLoggingStopped = builder.timeLoggingStopped;
    }

    /**
     * <p>
     * Whether the CloudTrail trail is currently logging Amazon Web Services API calls.
     * </p>
     * 
     * @return Whether the CloudTrail trail is currently logging Amazon Web Services API calls.
     */
    public final Boolean isLogging() {
        return isLogging;
    }

    /**
     * <p>
     * Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver log files to the designated
     * bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon S3
     * API Reference.
     * </p>
     * <note>
     * <p>
     * This error occurs only when there is a problem with the destination S3 bucket, and does not occur for requests
     * that time out. To resolve the issue, create a new bucket, and then call <code>UpdateTrail</code> to specify the
     * new bucket; or fix the existing objects so that CloudTrail can again write to the bucket.
     * </p>
     * </note>
     * 
     * @return Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver log files to the
     *         designated bucket. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the
     *         Amazon S3 API Reference. </p> <note>
     *         <p>
     *         This error occurs only when there is a problem with the destination S3 bucket, and does not occur for
     *         requests that time out. To resolve the issue, create a new bucket, and then call <code>UpdateTrail</code>
     *         to specify the new bucket; or fix the existing objects so that CloudTrail can again write to the bucket.
     *         </p>
     */
    public final String latestDeliveryError() {
        return latestDeliveryError;
    }

    /**
     * <p>
     * Displays any Amazon SNS error that CloudTrail encountered when attempting to send a notification. For more
     * information about Amazon SNS errors, see the <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon SNS Developer Guide</a>.
     * </p>
     * 
     * @return Displays any Amazon SNS error that CloudTrail encountered when attempting to send a notification. For
     *         more information about Amazon SNS errors, see the <a
     *         href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon SNS Developer Guide</a>.
     */
    public final String latestNotificationError() {
        return latestNotificationError;
    }

    /**
     * <p>
     * Specifies the date and time that CloudTrail last delivered log files to an account's Amazon S3 bucket.
     * </p>
     * 
     * @return Specifies the date and time that CloudTrail last delivered log files to an account's Amazon S3 bucket.
     */
    public final Instant latestDeliveryTime() {
        return latestDeliveryTime;
    }

    /**
     * <p>
     * Specifies the date and time of the most recent Amazon SNS notification that CloudTrail has written a new log file
     * to an account's Amazon S3 bucket.
     * </p>
     * 
     * @return Specifies the date and time of the most recent Amazon SNS notification that CloudTrail has written a new
     *         log file to an account's Amazon S3 bucket.
     */
    public final Instant latestNotificationTime() {
        return latestNotificationTime;
    }

    /**
     * <p>
     * Specifies the most recent date and time when CloudTrail started recording API calls for an Amazon Web Services
     * account.
     * </p>
     * 
     * @return Specifies the most recent date and time when CloudTrail started recording API calls for an Amazon Web
     *         Services account.
     */
    public final Instant startLoggingTime() {
        return startLoggingTime;
    }

    /**
     * <p>
     * Specifies the most recent date and time when CloudTrail stopped recording API calls for an Amazon Web Services
     * account.
     * </p>
     * 
     * @return Specifies the most recent date and time when CloudTrail stopped recording API calls for an Amazon Web
     *         Services account.
     */
    public final Instant stopLoggingTime() {
        return stopLoggingTime;
    }

    /**
     * <p>
     * Displays any CloudWatch Logs error that CloudTrail encountered when attempting to deliver logs to CloudWatch
     * Logs.
     * </p>
     * 
     * @return Displays any CloudWatch Logs error that CloudTrail encountered when attempting to deliver logs to
     *         CloudWatch Logs.
     */
    public final String latestCloudWatchLogsDeliveryError() {
        return latestCloudWatchLogsDeliveryError;
    }

    /**
     * <p>
     * Displays the most recent date and time when CloudTrail delivered logs to CloudWatch Logs.
     * </p>
     * 
     * @return Displays the most recent date and time when CloudTrail delivered logs to CloudWatch Logs.
     */
    public final Instant latestCloudWatchLogsDeliveryTime() {
        return latestCloudWatchLogsDeliveryTime;
    }

    /**
     * <p>
     * Specifies the date and time that CloudTrail last delivered a digest file to an account's Amazon S3 bucket.
     * </p>
     * 
     * @return Specifies the date and time that CloudTrail last delivered a digest file to an account's Amazon S3
     *         bucket.
     */
    public final Instant latestDigestDeliveryTime() {
        return latestDigestDeliveryTime;
    }

    /**
     * <p>
     * Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver a digest file to the
     * designated bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon S3
     * API Reference.
     * </p>
     * <note>
     * <p>
     * This error occurs only when there is a problem with the destination S3 bucket, and does not occur for requests
     * that time out. To resolve the issue, create a new bucket, and then call <code>UpdateTrail</code> to specify the
     * new bucket; or fix the existing objects so that CloudTrail can again write to the bucket.
     * </p>
     * </note>
     * 
     * @return Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver a digest file to the
     *         designated bucket. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the
     *         Amazon S3 API Reference. </p> <note>
     *         <p>
     *         This error occurs only when there is a problem with the destination S3 bucket, and does not occur for
     *         requests that time out. To resolve the issue, create a new bucket, and then call <code>UpdateTrail</code>
     *         to specify the new bucket; or fix the existing objects so that CloudTrail can again write to the bucket.
     *         </p>
     */
    public final String latestDigestDeliveryError() {
        return latestDigestDeliveryError;
    }

    /**
     * <p>
     * This field is no longer in use.
     * </p>
     * 
     * @return This field is no longer in use.
     */
    public final String latestDeliveryAttemptTime() {
        return latestDeliveryAttemptTime;
    }

    /**
     * <p>
     * This field is no longer in use.
     * </p>
     * 
     * @return This field is no longer in use.
     */
    public final String latestNotificationAttemptTime() {
        return latestNotificationAttemptTime;
    }

    /**
     * <p>
     * This field is no longer in use.
     * </p>
     * 
     * @return This field is no longer in use.
     */
    public final String latestNotificationAttemptSucceeded() {
        return latestNotificationAttemptSucceeded;
    }

    /**
     * <p>
     * This field is no longer in use.
     * </p>
     * 
     * @return This field is no longer in use.
     */
    public final String latestDeliveryAttemptSucceeded() {
        return latestDeliveryAttemptSucceeded;
    }

    /**
     * <p>
     * This field is no longer in use.
     * </p>
     * 
     * @return This field is no longer in use.
     */
    public final String timeLoggingStarted() {
        return timeLoggingStarted;
    }

    /**
     * <p>
     * This field is no longer in use.
     * </p>
     * 
     * @return This field is no longer in use.
     */
    public final String timeLoggingStopped() {
        return timeLoggingStopped;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(isLogging());
        hashCode = 31 * hashCode + Objects.hashCode(latestDeliveryError());
        hashCode = 31 * hashCode + Objects.hashCode(latestNotificationError());
        hashCode = 31 * hashCode + Objects.hashCode(latestDeliveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestNotificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(startLoggingTime());
        hashCode = 31 * hashCode + Objects.hashCode(stopLoggingTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestCloudWatchLogsDeliveryError());
        hashCode = 31 * hashCode + Objects.hashCode(latestCloudWatchLogsDeliveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestDigestDeliveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestDigestDeliveryError());
        hashCode = 31 * hashCode + Objects.hashCode(latestDeliveryAttemptTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestNotificationAttemptTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestNotificationAttemptSucceeded());
        hashCode = 31 * hashCode + Objects.hashCode(latestDeliveryAttemptSucceeded());
        hashCode = 31 * hashCode + Objects.hashCode(timeLoggingStarted());
        hashCode = 31 * hashCode + Objects.hashCode(timeLoggingStopped());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrailStatusResponse)) {
            return false;
        }
        GetTrailStatusResponse other = (GetTrailStatusResponse) obj;
        return Objects.equals(isLogging(), other.isLogging())
                && Objects.equals(latestDeliveryError(), other.latestDeliveryError())
                && Objects.equals(latestNotificationError(), other.latestNotificationError())
                && Objects.equals(latestDeliveryTime(), other.latestDeliveryTime())
                && Objects.equals(latestNotificationTime(), other.latestNotificationTime())
                && Objects.equals(startLoggingTime(), other.startLoggingTime())
                && Objects.equals(stopLoggingTime(), other.stopLoggingTime())
                && Objects.equals(latestCloudWatchLogsDeliveryError(), other.latestCloudWatchLogsDeliveryError())
                && Objects.equals(latestCloudWatchLogsDeliveryTime(), other.latestCloudWatchLogsDeliveryTime())
                && Objects.equals(latestDigestDeliveryTime(), other.latestDigestDeliveryTime())
                && Objects.equals(latestDigestDeliveryError(), other.latestDigestDeliveryError())
                && Objects.equals(latestDeliveryAttemptTime(), other.latestDeliveryAttemptTime())
                && Objects.equals(latestNotificationAttemptTime(), other.latestNotificationAttemptTime())
                && Objects.equals(latestNotificationAttemptSucceeded(), other.latestNotificationAttemptSucceeded())
                && Objects.equals(latestDeliveryAttemptSucceeded(), other.latestDeliveryAttemptSucceeded())
                && Objects.equals(timeLoggingStarted(), other.timeLoggingStarted())
                && Objects.equals(timeLoggingStopped(), other.timeLoggingStopped());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTrailStatusResponse").add("IsLogging", isLogging())
                .add("LatestDeliveryError", latestDeliveryError()).add("LatestNotificationError", latestNotificationError())
                .add("LatestDeliveryTime", latestDeliveryTime()).add("LatestNotificationTime", latestNotificationTime())
                .add("StartLoggingTime", startLoggingTime()).add("StopLoggingTime", stopLoggingTime())
                .add("LatestCloudWatchLogsDeliveryError", latestCloudWatchLogsDeliveryError())
                .add("LatestCloudWatchLogsDeliveryTime", latestCloudWatchLogsDeliveryTime())
                .add("LatestDigestDeliveryTime", latestDigestDeliveryTime())
                .add("LatestDigestDeliveryError", latestDigestDeliveryError())
                .add("LatestDeliveryAttemptTime", latestDeliveryAttemptTime())
                .add("LatestNotificationAttemptTime", latestNotificationAttemptTime())
                .add("LatestNotificationAttemptSucceeded", latestNotificationAttemptSucceeded())
                .add("LatestDeliveryAttemptSucceeded", latestDeliveryAttemptSucceeded())
                .add("TimeLoggingStarted", timeLoggingStarted()).add("TimeLoggingStopped", timeLoggingStopped()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsLogging":
            return Optional.ofNullable(clazz.cast(isLogging()));
        case "LatestDeliveryError":
            return Optional.ofNullable(clazz.cast(latestDeliveryError()));
        case "LatestNotificationError":
            return Optional.ofNullable(clazz.cast(latestNotificationError()));
        case "LatestDeliveryTime":
            return Optional.ofNullable(clazz.cast(latestDeliveryTime()));
        case "LatestNotificationTime":
            return Optional.ofNullable(clazz.cast(latestNotificationTime()));
        case "StartLoggingTime":
            return Optional.ofNullable(clazz.cast(startLoggingTime()));
        case "StopLoggingTime":
            return Optional.ofNullable(clazz.cast(stopLoggingTime()));
        case "LatestCloudWatchLogsDeliveryError":
            return Optional.ofNullable(clazz.cast(latestCloudWatchLogsDeliveryError()));
        case "LatestCloudWatchLogsDeliveryTime":
            return Optional.ofNullable(clazz.cast(latestCloudWatchLogsDeliveryTime()));
        case "LatestDigestDeliveryTime":
            return Optional.ofNullable(clazz.cast(latestDigestDeliveryTime()));
        case "LatestDigestDeliveryError":
            return Optional.ofNullable(clazz.cast(latestDigestDeliveryError()));
        case "LatestDeliveryAttemptTime":
            return Optional.ofNullable(clazz.cast(latestDeliveryAttemptTime()));
        case "LatestNotificationAttemptTime":
            return Optional.ofNullable(clazz.cast(latestNotificationAttemptTime()));
        case "LatestNotificationAttemptSucceeded":
            return Optional.ofNullable(clazz.cast(latestNotificationAttemptSucceeded()));
        case "LatestDeliveryAttemptSucceeded":
            return Optional.ofNullable(clazz.cast(latestDeliveryAttemptSucceeded()));
        case "TimeLoggingStarted":
            return Optional.ofNullable(clazz.cast(timeLoggingStarted()));
        case "TimeLoggingStopped":
            return Optional.ofNullable(clazz.cast(timeLoggingStopped()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTrailStatusResponse, T> g) {
        return obj -> g.apply((GetTrailStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTrailStatusResponse> {
        /**
         * <p>
         * Whether the CloudTrail trail is currently logging Amazon Web Services API calls.
         * </p>
         * 
         * @param isLogging
         *        Whether the CloudTrail trail is currently logging Amazon Web Services API calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLogging(Boolean isLogging);

        /**
         * <p>
         * Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver log files to the
         * designated bucket. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon
         * S3 API Reference.
         * </p>
         * <note>
         * <p>
         * This error occurs only when there is a problem with the destination S3 bucket, and does not occur for
         * requests that time out. To resolve the issue, create a new bucket, and then call <code>UpdateTrail</code> to
         * specify the new bucket; or fix the existing objects so that CloudTrail can again write to the bucket.
         * </p>
         * </note>
         * 
         * @param latestDeliveryError
         *        Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver log files to the
         *        designated bucket. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the
         *        Amazon S3 API Reference. </p> <note>
         *        <p>
         *        This error occurs only when there is a problem with the destination S3 bucket, and does not occur for
         *        requests that time out. To resolve the issue, create a new bucket, and then call
         *        <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that CloudTrail can
         *        again write to the bucket.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestDeliveryError(String latestDeliveryError);

        /**
         * <p>
         * Displays any Amazon SNS error that CloudTrail encountered when attempting to send a notification. For more
         * information about Amazon SNS errors, see the <a
         * href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon SNS Developer Guide</a>.
         * </p>
         * 
         * @param latestNotificationError
         *        Displays any Amazon SNS error that CloudTrail encountered when attempting to send a notification. For
         *        more information about Amazon SNS errors, see the <a
         *        href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon SNS Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestNotificationError(String latestNotificationError);

        /**
         * <p>
         * Specifies the date and time that CloudTrail last delivered log files to an account's Amazon S3 bucket.
         * </p>
         * 
         * @param latestDeliveryTime
         *        Specifies the date and time that CloudTrail last delivered log files to an account's Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestDeliveryTime(Instant latestDeliveryTime);

        /**
         * <p>
         * Specifies the date and time of the most recent Amazon SNS notification that CloudTrail has written a new log
         * file to an account's Amazon S3 bucket.
         * </p>
         * 
         * @param latestNotificationTime
         *        Specifies the date and time of the most recent Amazon SNS notification that CloudTrail has written a
         *        new log file to an account's Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestNotificationTime(Instant latestNotificationTime);

        /**
         * <p>
         * Specifies the most recent date and time when CloudTrail started recording API calls for an Amazon Web
         * Services account.
         * </p>
         * 
         * @param startLoggingTime
         *        Specifies the most recent date and time when CloudTrail started recording API calls for an Amazon Web
         *        Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startLoggingTime(Instant startLoggingTime);

        /**
         * <p>
         * Specifies the most recent date and time when CloudTrail stopped recording API calls for an Amazon Web
         * Services account.
         * </p>
         * 
         * @param stopLoggingTime
         *        Specifies the most recent date and time when CloudTrail stopped recording API calls for an Amazon Web
         *        Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopLoggingTime(Instant stopLoggingTime);

        /**
         * <p>
         * Displays any CloudWatch Logs error that CloudTrail encountered when attempting to deliver logs to CloudWatch
         * Logs.
         * </p>
         * 
         * @param latestCloudWatchLogsDeliveryError
         *        Displays any CloudWatch Logs error that CloudTrail encountered when attempting to deliver logs to
         *        CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestCloudWatchLogsDeliveryError(String latestCloudWatchLogsDeliveryError);

        /**
         * <p>
         * Displays the most recent date and time when CloudTrail delivered logs to CloudWatch Logs.
         * </p>
         * 
         * @param latestCloudWatchLogsDeliveryTime
         *        Displays the most recent date and time when CloudTrail delivered logs to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestCloudWatchLogsDeliveryTime(Instant latestCloudWatchLogsDeliveryTime);

        /**
         * <p>
         * Specifies the date and time that CloudTrail last delivered a digest file to an account's Amazon S3 bucket.
         * </p>
         * 
         * @param latestDigestDeliveryTime
         *        Specifies the date and time that CloudTrail last delivered a digest file to an account's Amazon S3
         *        bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestDigestDeliveryTime(Instant latestDigestDeliveryTime);

        /**
         * <p>
         * Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver a digest file to the
         * designated bucket. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon
         * S3 API Reference.
         * </p>
         * <note>
         * <p>
         * This error occurs only when there is a problem with the destination S3 bucket, and does not occur for
         * requests that time out. To resolve the issue, create a new bucket, and then call <code>UpdateTrail</code> to
         * specify the new bucket; or fix the existing objects so that CloudTrail can again write to the bucket.
         * </p>
         * </note>
         * 
         * @param latestDigestDeliveryError
         *        Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver a digest file to
         *        the designated bucket. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the
         *        Amazon S3 API Reference. </p> <note>
         *        <p>
         *        This error occurs only when there is a problem with the destination S3 bucket, and does not occur for
         *        requests that time out. To resolve the issue, create a new bucket, and then call
         *        <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that CloudTrail can
         *        again write to the bucket.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestDigestDeliveryError(String latestDigestDeliveryError);

        /**
         * <p>
         * This field is no longer in use.
         * </p>
         * 
         * @param latestDeliveryAttemptTime
         *        This field is no longer in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestDeliveryAttemptTime(String latestDeliveryAttemptTime);

        /**
         * <p>
         * This field is no longer in use.
         * </p>
         * 
         * @param latestNotificationAttemptTime
         *        This field is no longer in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestNotificationAttemptTime(String latestNotificationAttemptTime);

        /**
         * <p>
         * This field is no longer in use.
         * </p>
         * 
         * @param latestNotificationAttemptSucceeded
         *        This field is no longer in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestNotificationAttemptSucceeded(String latestNotificationAttemptSucceeded);

        /**
         * <p>
         * This field is no longer in use.
         * </p>
         * 
         * @param latestDeliveryAttemptSucceeded
         *        This field is no longer in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestDeliveryAttemptSucceeded(String latestDeliveryAttemptSucceeded);

        /**
         * <p>
         * This field is no longer in use.
         * </p>
         * 
         * @param timeLoggingStarted
         *        This field is no longer in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeLoggingStarted(String timeLoggingStarted);

        /**
         * <p>
         * This field is no longer in use.
         * </p>
         * 
         * @param timeLoggingStopped
         *        This field is no longer in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeLoggingStopped(String timeLoggingStopped);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private Boolean isLogging;

        private String latestDeliveryError;

        private String latestNotificationError;

        private Instant latestDeliveryTime;

        private Instant latestNotificationTime;

        private Instant startLoggingTime;

        private Instant stopLoggingTime;

        private String latestCloudWatchLogsDeliveryError;

        private Instant latestCloudWatchLogsDeliveryTime;

        private Instant latestDigestDeliveryTime;

        private String latestDigestDeliveryError;

        private String latestDeliveryAttemptTime;

        private String latestNotificationAttemptTime;

        private String latestNotificationAttemptSucceeded;

        private String latestDeliveryAttemptSucceeded;

        private String timeLoggingStarted;

        private String timeLoggingStopped;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrailStatusResponse model) {
            super(model);
            isLogging(model.isLogging);
            latestDeliveryError(model.latestDeliveryError);
            latestNotificationError(model.latestNotificationError);
            latestDeliveryTime(model.latestDeliveryTime);
            latestNotificationTime(model.latestNotificationTime);
            startLoggingTime(model.startLoggingTime);
            stopLoggingTime(model.stopLoggingTime);
            latestCloudWatchLogsDeliveryError(model.latestCloudWatchLogsDeliveryError);
            latestCloudWatchLogsDeliveryTime(model.latestCloudWatchLogsDeliveryTime);
            latestDigestDeliveryTime(model.latestDigestDeliveryTime);
            latestDigestDeliveryError(model.latestDigestDeliveryError);
            latestDeliveryAttemptTime(model.latestDeliveryAttemptTime);
            latestNotificationAttemptTime(model.latestNotificationAttemptTime);
            latestNotificationAttemptSucceeded(model.latestNotificationAttemptSucceeded);
            latestDeliveryAttemptSucceeded(model.latestDeliveryAttemptSucceeded);
            timeLoggingStarted(model.timeLoggingStarted);
            timeLoggingStopped(model.timeLoggingStopped);
        }

        public final Boolean getIsLogging() {
            return isLogging;
        }

        public final void setIsLogging(Boolean isLogging) {
            this.isLogging = isLogging;
        }

        @Override
        @Transient
        public final Builder isLogging(Boolean isLogging) {
            this.isLogging = isLogging;
            return this;
        }

        public final String getLatestDeliveryError() {
            return latestDeliveryError;
        }

        public final void setLatestDeliveryError(String latestDeliveryError) {
            this.latestDeliveryError = latestDeliveryError;
        }

        @Override
        @Transient
        public final Builder latestDeliveryError(String latestDeliveryError) {
            this.latestDeliveryError = latestDeliveryError;
            return this;
        }

        public final String getLatestNotificationError() {
            return latestNotificationError;
        }

        public final void setLatestNotificationError(String latestNotificationError) {
            this.latestNotificationError = latestNotificationError;
        }

        @Override
        @Transient
        public final Builder latestNotificationError(String latestNotificationError) {
            this.latestNotificationError = latestNotificationError;
            return this;
        }

        public final Instant getLatestDeliveryTime() {
            return latestDeliveryTime;
        }

        public final void setLatestDeliveryTime(Instant latestDeliveryTime) {
            this.latestDeliveryTime = latestDeliveryTime;
        }

        @Override
        @Transient
        public final Builder latestDeliveryTime(Instant latestDeliveryTime) {
            this.latestDeliveryTime = latestDeliveryTime;
            return this;
        }

        public final Instant getLatestNotificationTime() {
            return latestNotificationTime;
        }

        public final void setLatestNotificationTime(Instant latestNotificationTime) {
            this.latestNotificationTime = latestNotificationTime;
        }

        @Override
        @Transient
        public final Builder latestNotificationTime(Instant latestNotificationTime) {
            this.latestNotificationTime = latestNotificationTime;
            return this;
        }

        public final Instant getStartLoggingTime() {
            return startLoggingTime;
        }

        public final void setStartLoggingTime(Instant startLoggingTime) {
            this.startLoggingTime = startLoggingTime;
        }

        @Override
        @Transient
        public final Builder startLoggingTime(Instant startLoggingTime) {
            this.startLoggingTime = startLoggingTime;
            return this;
        }

        public final Instant getStopLoggingTime() {
            return stopLoggingTime;
        }

        public final void setStopLoggingTime(Instant stopLoggingTime) {
            this.stopLoggingTime = stopLoggingTime;
        }

        @Override
        @Transient
        public final Builder stopLoggingTime(Instant stopLoggingTime) {
            this.stopLoggingTime = stopLoggingTime;
            return this;
        }

        public final String getLatestCloudWatchLogsDeliveryError() {
            return latestCloudWatchLogsDeliveryError;
        }

        public final void setLatestCloudWatchLogsDeliveryError(String latestCloudWatchLogsDeliveryError) {
            this.latestCloudWatchLogsDeliveryError = latestCloudWatchLogsDeliveryError;
        }

        @Override
        @Transient
        public final Builder latestCloudWatchLogsDeliveryError(String latestCloudWatchLogsDeliveryError) {
            this.latestCloudWatchLogsDeliveryError = latestCloudWatchLogsDeliveryError;
            return this;
        }

        public final Instant getLatestCloudWatchLogsDeliveryTime() {
            return latestCloudWatchLogsDeliveryTime;
        }

        public final void setLatestCloudWatchLogsDeliveryTime(Instant latestCloudWatchLogsDeliveryTime) {
            this.latestCloudWatchLogsDeliveryTime = latestCloudWatchLogsDeliveryTime;
        }

        @Override
        @Transient
        public final Builder latestCloudWatchLogsDeliveryTime(Instant latestCloudWatchLogsDeliveryTime) {
            this.latestCloudWatchLogsDeliveryTime = latestCloudWatchLogsDeliveryTime;
            return this;
        }

        public final Instant getLatestDigestDeliveryTime() {
            return latestDigestDeliveryTime;
        }

        public final void setLatestDigestDeliveryTime(Instant latestDigestDeliveryTime) {
            this.latestDigestDeliveryTime = latestDigestDeliveryTime;
        }

        @Override
        @Transient
        public final Builder latestDigestDeliveryTime(Instant latestDigestDeliveryTime) {
            this.latestDigestDeliveryTime = latestDigestDeliveryTime;
            return this;
        }

        public final String getLatestDigestDeliveryError() {
            return latestDigestDeliveryError;
        }

        public final void setLatestDigestDeliveryError(String latestDigestDeliveryError) {
            this.latestDigestDeliveryError = latestDigestDeliveryError;
        }

        @Override
        @Transient
        public final Builder latestDigestDeliveryError(String latestDigestDeliveryError) {
            this.latestDigestDeliveryError = latestDigestDeliveryError;
            return this;
        }

        public final String getLatestDeliveryAttemptTime() {
            return latestDeliveryAttemptTime;
        }

        public final void setLatestDeliveryAttemptTime(String latestDeliveryAttemptTime) {
            this.latestDeliveryAttemptTime = latestDeliveryAttemptTime;
        }

        @Override
        @Transient
        public final Builder latestDeliveryAttemptTime(String latestDeliveryAttemptTime) {
            this.latestDeliveryAttemptTime = latestDeliveryAttemptTime;
            return this;
        }

        public final String getLatestNotificationAttemptTime() {
            return latestNotificationAttemptTime;
        }

        public final void setLatestNotificationAttemptTime(String latestNotificationAttemptTime) {
            this.latestNotificationAttemptTime = latestNotificationAttemptTime;
        }

        @Override
        @Transient
        public final Builder latestNotificationAttemptTime(String latestNotificationAttemptTime) {
            this.latestNotificationAttemptTime = latestNotificationAttemptTime;
            return this;
        }

        public final String getLatestNotificationAttemptSucceeded() {
            return latestNotificationAttemptSucceeded;
        }

        public final void setLatestNotificationAttemptSucceeded(String latestNotificationAttemptSucceeded) {
            this.latestNotificationAttemptSucceeded = latestNotificationAttemptSucceeded;
        }

        @Override
        @Transient
        public final Builder latestNotificationAttemptSucceeded(String latestNotificationAttemptSucceeded) {
            this.latestNotificationAttemptSucceeded = latestNotificationAttemptSucceeded;
            return this;
        }

        public final String getLatestDeliveryAttemptSucceeded() {
            return latestDeliveryAttemptSucceeded;
        }

        public final void setLatestDeliveryAttemptSucceeded(String latestDeliveryAttemptSucceeded) {
            this.latestDeliveryAttemptSucceeded = latestDeliveryAttemptSucceeded;
        }

        @Override
        @Transient
        public final Builder latestDeliveryAttemptSucceeded(String latestDeliveryAttemptSucceeded) {
            this.latestDeliveryAttemptSucceeded = latestDeliveryAttemptSucceeded;
            return this;
        }

        public final String getTimeLoggingStarted() {
            return timeLoggingStarted;
        }

        public final void setTimeLoggingStarted(String timeLoggingStarted) {
            this.timeLoggingStarted = timeLoggingStarted;
        }

        @Override
        @Transient
        public final Builder timeLoggingStarted(String timeLoggingStarted) {
            this.timeLoggingStarted = timeLoggingStarted;
            return this;
        }

        public final String getTimeLoggingStopped() {
            return timeLoggingStopped;
        }

        public final void setTimeLoggingStopped(String timeLoggingStopped) {
            this.timeLoggingStopped = timeLoggingStopped;
        }

        @Override
        @Transient
        public final Builder timeLoggingStopped(String timeLoggingStopped) {
            this.timeLoggingStopped = timeLoggingStopped;
            return this;
        }

        @Override
        public GetTrailStatusResponse build() {
            return new GetTrailStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
