/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a CloudTrail trail, including the trail's name, home region, and Amazon Resource Name (ARN).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrailInfo implements SdkPojo, Serializable, ToCopyableBuilder<TrailInfo.Builder, TrailInfo> {
    private static final SdkField<String> TRAIL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrailARN").getter(getter(TrailInfo::trailARN)).setter(setter(Builder::trailARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailARN").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TrailInfo::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> HOME_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeRegion").getter(getter(TrailInfo::homeRegion)).setter(setter(Builder::homeRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_ARN_FIELD, NAME_FIELD,
            HOME_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String trailARN;

    private final String name;

    private final String homeRegion;

    private TrailInfo(BuilderImpl builder) {
        this.trailARN = builder.trailARN;
        this.name = builder.name;
        this.homeRegion = builder.homeRegion;
    }

    /**
     * <p>
     * The ARN of a trail.
     * </p>
     * 
     * @return The ARN of a trail.
     */
    public final String trailARN() {
        return trailARN;
    }

    /**
     * <p>
     * The name of a trail.
     * </p>
     * 
     * @return The name of a trail.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Web Services Region in which a trail was created.
     * </p>
     * 
     * @return The Amazon Web Services Region in which a trail was created.
     */
    public final String homeRegion() {
        return homeRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trailARN());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(homeRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrailInfo)) {
            return false;
        }
        TrailInfo other = (TrailInfo) obj;
        return Objects.equals(trailARN(), other.trailARN()) && Objects.equals(name(), other.name())
                && Objects.equals(homeRegion(), other.homeRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrailInfo").add("TrailARN", trailARN()).add("Name", name()).add("HomeRegion", homeRegion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrailARN":
            return Optional.ofNullable(clazz.cast(trailARN()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "HomeRegion":
            return Optional.ofNullable(clazz.cast(homeRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrailInfo, T> g) {
        return obj -> g.apply((TrailInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrailInfo> {
        /**
         * <p>
         * The ARN of a trail.
         * </p>
         * 
         * @param trailARN
         *        The ARN of a trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailARN(String trailARN);

        /**
         * <p>
         * The name of a trail.
         * </p>
         * 
         * @param name
         *        The name of a trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Web Services Region in which a trail was created.
         * </p>
         * 
         * @param homeRegion
         *        The Amazon Web Services Region in which a trail was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegion(String homeRegion);
    }

    static final class BuilderImpl implements Builder {
        private String trailARN;

        private String name;

        private String homeRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(TrailInfo model) {
            trailARN(model.trailARN);
            name(model.name);
            homeRegion(model.homeRegion);
        }

        public final String getTrailARN() {
            return trailARN;
        }

        public final void setTrailARN(String trailARN) {
            this.trailARN = trailARN;
        }

        @Override
        @Transient
        public final Builder trailARN(String trailARN) {
            this.trailARN = trailARN;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getHomeRegion() {
            return homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        @Transient
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        @Override
        public TrailInfo build() {
            return new TrailInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
