/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudtrail.CloudTrailAsyncClient;
import software.amazon.awssdk.services.cloudtrail.CloudTrailAsyncClientBuilder;
import software.amazon.awssdk.services.cloudtrail.CloudTrailServiceClientConfiguration;
import software.amazon.awssdk.services.cloudtrail.DefaultCloudTrailAsyncClient;
import software.amazon.awssdk.services.cloudtrail.DefaultCloudTrailBaseClientBuilder;
import software.amazon.awssdk.services.cloudtrail.endpoints.CloudTrailEndpointProvider;

@SdkInternalApi
final class DefaultCloudTrailAsyncClientBuilder
extends DefaultCloudTrailBaseClientBuilder<CloudTrailAsyncClientBuilder, CloudTrailAsyncClient>
implements CloudTrailAsyncClientBuilder {
    DefaultCloudTrailAsyncClientBuilder() {
    }

    @Override
    public DefaultCloudTrailAsyncClientBuilder endpointProvider(CloudTrailEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudTrailAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCloudTrailAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CloudTrailServiceClientConfiguration serviceClientConfiguration = CloudTrailServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCloudTrailAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

