/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides statistics for the specified <code>ImportID</code>. CloudTrail does not update import statistics in
 * real-time. Returned values for parameters such as <code>EventsCompleted</code> may be lower than the actual value,
 * because CloudTrail updates statistics incrementally over the course of the import.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportStatistics.Builder, ImportStatistics> {
    private static final SdkField<Long> PREFIXES_FOUND_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("PrefixesFound").getter(getter(ImportStatistics::prefixesFound)).setter(setter(Builder::prefixesFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixesFound").build()).build();

    private static final SdkField<Long> PREFIXES_COMPLETED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("PrefixesCompleted").getter(getter(ImportStatistics::prefixesCompleted))
            .setter(setter(Builder::prefixesCompleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixesCompleted").build()).build();

    private static final SdkField<Long> FILES_COMPLETED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FilesCompleted").getter(getter(ImportStatistics::filesCompleted))
            .setter(setter(Builder::filesCompleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesCompleted").build()).build();

    private static final SdkField<Long> EVENTS_COMPLETED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EventsCompleted").getter(getter(ImportStatistics::eventsCompleted))
            .setter(setter(Builder::eventsCompleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsCompleted").build()).build();

    private static final SdkField<Long> FAILED_ENTRIES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FailedEntries").getter(getter(ImportStatistics::failedEntries)).setter(setter(Builder::failedEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedEntries").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIXES_FOUND_FIELD,
            PREFIXES_COMPLETED_FIELD, FILES_COMPLETED_FIELD, EVENTS_COMPLETED_FIELD, FAILED_ENTRIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long prefixesFound;

    private final Long prefixesCompleted;

    private final Long filesCompleted;

    private final Long eventsCompleted;

    private final Long failedEntries;

    private ImportStatistics(BuilderImpl builder) {
        this.prefixesFound = builder.prefixesFound;
        this.prefixesCompleted = builder.prefixesCompleted;
        this.filesCompleted = builder.filesCompleted;
        this.eventsCompleted = builder.eventsCompleted;
        this.failedEntries = builder.failedEntries;
    }

    /**
     * <p>
     * The number of S3 prefixes found for the import.
     * </p>
     * 
     * @return The number of S3 prefixes found for the import.
     */
    public final Long prefixesFound() {
        return prefixesFound;
    }

    /**
     * <p>
     * The number of S3 prefixes that completed import.
     * </p>
     * 
     * @return The number of S3 prefixes that completed import.
     */
    public final Long prefixesCompleted() {
        return prefixesCompleted;
    }

    /**
     * <p>
     * The number of log files that completed import.
     * </p>
     * 
     * @return The number of log files that completed import.
     */
    public final Long filesCompleted() {
        return filesCompleted;
    }

    /**
     * <p>
     * The number of trail events imported into the event data store.
     * </p>
     * 
     * @return The number of trail events imported into the event data store.
     */
    public final Long eventsCompleted() {
        return eventsCompleted;
    }

    /**
     * <p>
     * The number of failed entries.
     * </p>
     * 
     * @return The number of failed entries.
     */
    public final Long failedEntries() {
        return failedEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prefixesFound());
        hashCode = 31 * hashCode + Objects.hashCode(prefixesCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(filesCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(eventsCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(failedEntries());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportStatistics)) {
            return false;
        }
        ImportStatistics other = (ImportStatistics) obj;
        return Objects.equals(prefixesFound(), other.prefixesFound())
                && Objects.equals(prefixesCompleted(), other.prefixesCompleted())
                && Objects.equals(filesCompleted(), other.filesCompleted())
                && Objects.equals(eventsCompleted(), other.eventsCompleted())
                && Objects.equals(failedEntries(), other.failedEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportStatistics").add("PrefixesFound", prefixesFound())
                .add("PrefixesCompleted", prefixesCompleted()).add("FilesCompleted", filesCompleted())
                .add("EventsCompleted", eventsCompleted()).add("FailedEntries", failedEntries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrefixesFound":
            return Optional.ofNullable(clazz.cast(prefixesFound()));
        case "PrefixesCompleted":
            return Optional.ofNullable(clazz.cast(prefixesCompleted()));
        case "FilesCompleted":
            return Optional.ofNullable(clazz.cast(filesCompleted()));
        case "EventsCompleted":
            return Optional.ofNullable(clazz.cast(eventsCompleted()));
        case "FailedEntries":
            return Optional.ofNullable(clazz.cast(failedEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportStatistics, T> g) {
        return obj -> g.apply((ImportStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportStatistics> {
        /**
         * <p>
         * The number of S3 prefixes found for the import.
         * </p>
         * 
         * @param prefixesFound
         *        The number of S3 prefixes found for the import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixesFound(Long prefixesFound);

        /**
         * <p>
         * The number of S3 prefixes that completed import.
         * </p>
         * 
         * @param prefixesCompleted
         *        The number of S3 prefixes that completed import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixesCompleted(Long prefixesCompleted);

        /**
         * <p>
         * The number of log files that completed import.
         * </p>
         * 
         * @param filesCompleted
         *        The number of log files that completed import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesCompleted(Long filesCompleted);

        /**
         * <p>
         * The number of trail events imported into the event data store.
         * </p>
         * 
         * @param eventsCompleted
         *        The number of trail events imported into the event data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsCompleted(Long eventsCompleted);

        /**
         * <p>
         * The number of failed entries.
         * </p>
         * 
         * @param failedEntries
         *        The number of failed entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEntries(Long failedEntries);
    }

    static final class BuilderImpl implements Builder {
        private Long prefixesFound;

        private Long prefixesCompleted;

        private Long filesCompleted;

        private Long eventsCompleted;

        private Long failedEntries;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportStatistics model) {
            prefixesFound(model.prefixesFound);
            prefixesCompleted(model.prefixesCompleted);
            filesCompleted(model.filesCompleted);
            eventsCompleted(model.eventsCompleted);
            failedEntries(model.failedEntries);
        }

        public final Long getPrefixesFound() {
            return prefixesFound;
        }

        public final void setPrefixesFound(Long prefixesFound) {
            this.prefixesFound = prefixesFound;
        }

        @Override
        public final Builder prefixesFound(Long prefixesFound) {
            this.prefixesFound = prefixesFound;
            return this;
        }

        public final Long getPrefixesCompleted() {
            return prefixesCompleted;
        }

        public final void setPrefixesCompleted(Long prefixesCompleted) {
            this.prefixesCompleted = prefixesCompleted;
        }

        @Override
        public final Builder prefixesCompleted(Long prefixesCompleted) {
            this.prefixesCompleted = prefixesCompleted;
            return this;
        }

        public final Long getFilesCompleted() {
            return filesCompleted;
        }

        public final void setFilesCompleted(Long filesCompleted) {
            this.filesCompleted = filesCompleted;
        }

        @Override
        public final Builder filesCompleted(Long filesCompleted) {
            this.filesCompleted = filesCompleted;
            return this;
        }

        public final Long getEventsCompleted() {
            return eventsCompleted;
        }

        public final void setEventsCompleted(Long eventsCompleted) {
            this.eventsCompleted = eventsCompleted;
        }

        @Override
        public final Builder eventsCompleted(Long eventsCompleted) {
            this.eventsCompleted = eventsCompleted;
            return this;
        }

        public final Long getFailedEntries() {
            return failedEntries;
        }

        public final void setFailedEntries(Long failedEntries) {
            this.failedEntries = failedEntries;
        }

        @Override
        public final Builder failedEntries(Long failedEntries) {
            this.failedEntries = failedEntries;
            return this;
        }

        @Override
        public ImportStatistics build() {
            return new ImportStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
