/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies settings to update for the trail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTrailRequest extends CloudTrailRequest implements
        ToCopyableBuilder<UpdateTrailRequest.Builder, UpdateTrailRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateTrailRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(UpdateTrailRequest::s3BucketName)).setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3KeyPrefix").getter(getter(UpdateTrailRequest::s3KeyPrefix)).setter(setter(Builder::s3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()).build();

    private static final SdkField<String> SNS_TOPIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicName").getter(getter(UpdateTrailRequest::snsTopicName)).setter(setter(Builder::snsTopicName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicName").build()).build();

    private static final SdkField<Boolean> INCLUDE_GLOBAL_SERVICE_EVENTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeGlobalServiceEvents")
            .getter(getter(UpdateTrailRequest::includeGlobalServiceEvents))
            .setter(setter(Builder::includeGlobalServiceEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeGlobalServiceEvents").build())
            .build();

    private static final SdkField<Boolean> IS_MULTI_REGION_TRAIL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsMultiRegionTrail").getter(getter(UpdateTrailRequest::isMultiRegionTrail))
            .setter(setter(Builder::isMultiRegionTrail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsMultiRegionTrail").build())
            .build();

    private static final SdkField<Boolean> ENABLE_LOG_FILE_VALIDATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableLogFileValidation").getter(getter(UpdateTrailRequest::enableLogFileValidation))
            .setter(setter(Builder::enableLogFileValidation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableLogFileValidation").build())
            .build();

    private static final SdkField<String> CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("CloudWatchLogsLogGroupArn")
            .getter(getter(UpdateTrailRequest::cloudWatchLogsLogGroupArn)).setter(setter(Builder::cloudWatchLogsLogGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsLogGroupArn").build())
            .build();

    private static final SdkField<String> CLOUD_WATCH_LOGS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogsRoleArn").getter(getter(UpdateTrailRequest::cloudWatchLogsRoleArn))
            .setter(setter(Builder::cloudWatchLogsRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsRoleArn").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(UpdateTrailRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> IS_ORGANIZATION_TRAIL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsOrganizationTrail").getter(getter(UpdateTrailRequest::isOrganizationTrail))
            .setter(setter(Builder::isOrganizationTrail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsOrganizationTrail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            S3_BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD, SNS_TOPIC_NAME_FIELD, INCLUDE_GLOBAL_SERVICE_EVENTS_FIELD,
            IS_MULTI_REGION_TRAIL_FIELD, ENABLE_LOG_FILE_VALIDATION_FIELD, CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD,
            CLOUD_WATCH_LOGS_ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, IS_ORGANIZATION_TRAIL_FIELD));

    private final String name;

    private final String s3BucketName;

    private final String s3KeyPrefix;

    private final String snsTopicName;

    private final Boolean includeGlobalServiceEvents;

    private final Boolean isMultiRegionTrail;

    private final Boolean enableLogFileValidation;

    private final String cloudWatchLogsLogGroupArn;

    private final String cloudWatchLogsRoleArn;

    private final String kmsKeyId;

    private final Boolean isOrganizationTrail;

    private UpdateTrailRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.snsTopicName = builder.snsTopicName;
        this.includeGlobalServiceEvents = builder.includeGlobalServiceEvents;
        this.isMultiRegionTrail = builder.isMultiRegionTrail;
        this.enableLogFileValidation = builder.enableLogFileValidation;
        this.cloudWatchLogsLogGroupArn = builder.cloudWatchLogsLogGroupArn;
        this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.isOrganizationTrail = builder.isOrganizationTrail;
    }

    /**
     * <p>
     * Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the string must meet the
     * following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     * </p>
     * </li>
     * <li>
     * <p>
     * Start with a letter or number, and end with a letter or number
     * </p>
     * </li>
     * <li>
     * <p>
     * Be between 3 and 128 characters
     * </p>
     * </li>
     * <li>
     * <p>
     * Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     * <code>my--namespace</code> are not valid.
     * </p>
     * </li>
     * <li>
     * <p>
     * Not be in IP address format (for example, 192.168.5.4)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>Name</code> is a trail ARN, it must be in the following format.
     * </p>
     * <p>
     * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     * </p>
     * 
     * @return Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the string must meet
     *         the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>Name</code> is a trail ARN, it must be in the following format.
     *         </p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3
     * Bucket Naming Requirements</a>.
     * </p>
     * 
     * @return Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon
     *         S3 Bucket Naming Requirements</a>.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file
     * delivery. For more information, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your
     * CloudTrail Log Files</a>. The maximum length is 200 characters.
     * </p>
     * 
     * @return Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log
     *         file delivery. For more information, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding
     *         Your CloudTrail Log Files</a>. The maximum length is 200 characters.
     */
    public final String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    /**
     * <p>
     * Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is
     * 256 characters.
     * </p>
     * 
     * @return Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum
     *         length is 256 characters.
     */
    public final String snsTopicName() {
        return snsTopicName;
    }

    /**
     * <p>
     * Specifies whether the trail is publishing events from global services such as IAM to the log files.
     * </p>
     * 
     * @return Specifies whether the trail is publishing events from global services such as IAM to the log files.
     */
    public final Boolean includeGlobalServiceEvents() {
        return includeGlobalServiceEvents;
    }

    /**
     * <p>
     * Specifies whether the trail applies only to the current Region or to all Regions. The default is false. If the
     * trail exists only in the current Region and this value is set to true, shadow trails (replications of the trail)
     * will be created in the other Regions. If the trail exists in all Regions and this value is set to false, the
     * trail will remain in the Region where it was created, and its shadow trails in other Regions will be deleted. As
     * a best practice, consider using trails that log events in all Regions.
     * </p>
     * 
     * @return Specifies whether the trail applies only to the current Region or to all Regions. The default is false.
     *         If the trail exists only in the current Region and this value is set to true, shadow trails (replications
     *         of the trail) will be created in the other Regions. If the trail exists in all Regions and this value is
     *         set to false, the trail will remain in the Region where it was created, and its shadow trails in other
     *         Regions will be deleted. As a best practice, consider using trails that log events in all Regions.
     */
    public final Boolean isMultiRegionTrail() {
        return isMultiRegionTrail;
    }

    /**
     * <p>
     * Specifies whether log file validation is enabled. The default is false.
     * </p>
     * <note>
     * <p>
     * When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail
     * does not create digest files for log files that were delivered during a period in which log file integrity
     * validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable
     * it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log
     * files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail
     * logging or delete a trail.
     * </p>
     * </note>
     * 
     * @return Specifies whether log file validation is enabled. The default is false.</p> <note>
     *         <p>
     *         When you disable log file integrity validation, the chain of digest files is broken after one hour.
     *         CloudTrail does not create digest files for log files that were delivered during a period in which log
     *         file integrity validation was disabled. For example, if you enable log file integrity validation at noon
     *         on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will
     *         not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies
     *         whenever you stop CloudTrail logging or delete a trail.
     *         </p>
     */
    public final Boolean enableLogFileValidation() {
        return enableLogFileValidation;
    }

    /**
     * <p>
     * Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group
     * to which CloudTrail logs are delivered. You must use a log group that exists in your account.
     * </p>
     * <p>
     * Not required unless you specify <code>CloudWatchLogsRoleArn</code>.
     * </p>
     * <note>
     * <p>
     * Only the management account can configure a CloudWatch Logs log group for an organization trail.
     * </p>
     * </note>
     * 
     * @return Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the
     *         log group to which CloudTrail logs are delivered. You must use a log group that exists in your
     *         account.</p>
     *         <p>
     *         Not required unless you specify <code>CloudWatchLogsRoleArn</code>.
     *         </p>
     *         <note>
     *         <p>
     *         Only the management account can configure a CloudWatch Logs log group for an organization trail.
     *         </p>
     */
    public final String cloudWatchLogsLogGroupArn() {
        return cloudWatchLogsLogGroupArn;
    }

    /**
     * <p>
     * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group. You must use a role
     * that exists in your account.
     * </p>
     * 
     * @return Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group. You must
     *         use a role that exists in your account.
     */
    public final String cloudWatchLogsRoleArn() {
        return cloudWatchLogsRoleArn;
    }

    /**
     * <p>
     * Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name
     * prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique
     * identifier.
     * </p>
     * <p>
     * CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region
     * keys</a> in the <i>Key Management Service Developer Guide</i>.
     * </p>
     * <p>
     * Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * alias/MyAliasName
     * </p>
     * </li>
     * <li>
     * <p>
     * arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
     * </p>
     * </li>
     * <li>
     * <p>
     * arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
     * </p>
     * </li>
     * <li>
     * <p>
     * 12345678-1234-1234-1234-123456789012
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias
     *         name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a
     *         globally unique identifier.</p>
     *         <p>
     *         CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using
     *         multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.
     *         </p>
     *         <p>
     *         Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         alias/MyAliasName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         12345678-1234-1234-1234-123456789012
     *         </p>
     *         </li>
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specifies whether the trail is applied to all accounts in an organization in Organizations, or only for the
     * current Amazon Web Services account. The default is false, and cannot be true unless the call is made on behalf
     * of an Amazon Web Services account that is the management account for an organization in Organizations. If the
     * trail is not an organization trail and this is set to <code>true</code>, the trail will be created in all Amazon
     * Web Services accounts that belong to the organization. If the trail is an organization trail and this is set to
     * <code>false</code>, the trail will remain in the current Amazon Web Services account but be deleted from all
     * member accounts in the organization.
     * </p>
     * <note>
     * <p>
     * Only the management account for the organization can convert an organization trail to a non-organization trail,
     * or convert a non-organization trail to an organization trail.
     * </p>
     * </note>
     * 
     * @return Specifies whether the trail is applied to all accounts in an organization in Organizations, or only for
     *         the current Amazon Web Services account. The default is false, and cannot be true unless the call is made
     *         on behalf of an Amazon Web Services account that is the management account for an organization in
     *         Organizations. If the trail is not an organization trail and this is set to <code>true</code>, the trail
     *         will be created in all Amazon Web Services accounts that belong to the organization. If the trail is an
     *         organization trail and this is set to <code>false</code>, the trail will remain in the current Amazon Web
     *         Services account but be deleted from all member accounts in the organization.</p> <note>
     *         <p>
     *         Only the management account for the organization can convert an organization trail to a non-organization
     *         trail, or convert a non-organization trail to an organization trail.
     *         </p>
     */
    public final Boolean isOrganizationTrail() {
        return isOrganizationTrail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicName());
        hashCode = 31 * hashCode + Objects.hashCode(includeGlobalServiceEvents());
        hashCode = 31 * hashCode + Objects.hashCode(isMultiRegionTrail());
        hashCode = 31 * hashCode + Objects.hashCode(enableLogFileValidation());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(isOrganizationTrail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrailRequest)) {
            return false;
        }
        UpdateTrailRequest other = (UpdateTrailRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(s3KeyPrefix(), other.s3KeyPrefix()) && Objects.equals(snsTopicName(), other.snsTopicName())
                && Objects.equals(includeGlobalServiceEvents(), other.includeGlobalServiceEvents())
                && Objects.equals(isMultiRegionTrail(), other.isMultiRegionTrail())
                && Objects.equals(enableLogFileValidation(), other.enableLogFileValidation())
                && Objects.equals(cloudWatchLogsLogGroupArn(), other.cloudWatchLogsLogGroupArn())
                && Objects.equals(cloudWatchLogsRoleArn(), other.cloudWatchLogsRoleArn())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(isOrganizationTrail(), other.isOrganizationTrail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTrailRequest").add("Name", name()).add("S3BucketName", s3BucketName())
                .add("S3KeyPrefix", s3KeyPrefix()).add("SnsTopicName", snsTopicName())
                .add("IncludeGlobalServiceEvents", includeGlobalServiceEvents()).add("IsMultiRegionTrail", isMultiRegionTrail())
                .add("EnableLogFileValidation", enableLogFileValidation())
                .add("CloudWatchLogsLogGroupArn", cloudWatchLogsLogGroupArn())
                .add("CloudWatchLogsRoleArn", cloudWatchLogsRoleArn()).add("KmsKeyId", kmsKeyId())
                .add("IsOrganizationTrail", isOrganizationTrail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "S3KeyPrefix":
            return Optional.ofNullable(clazz.cast(s3KeyPrefix()));
        case "SnsTopicName":
            return Optional.ofNullable(clazz.cast(snsTopicName()));
        case "IncludeGlobalServiceEvents":
            return Optional.ofNullable(clazz.cast(includeGlobalServiceEvents()));
        case "IsMultiRegionTrail":
            return Optional.ofNullable(clazz.cast(isMultiRegionTrail()));
        case "EnableLogFileValidation":
            return Optional.ofNullable(clazz.cast(enableLogFileValidation()));
        case "CloudWatchLogsLogGroupArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsLogGroupArn()));
        case "CloudWatchLogsRoleArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsRoleArn()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "IsOrganizationTrail":
            return Optional.ofNullable(clazz.cast(isOrganizationTrail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrailRequest, T> g) {
        return obj -> g.apply((UpdateTrailRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTrailRequest> {
        /**
         * <p>
         * Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the string must meet the
         * following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
         * </p>
         * </li>
         * <li>
         * <p>
         * Start with a letter or number, and end with a letter or number
         * </p>
         * </li>
         * <li>
         * <p>
         * Be between 3 and 128 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
         * <code>my--namespace</code> are not valid.
         * </p>
         * </li>
         * <li>
         * <p>
         * Not be in IP address format (for example, 192.168.5.4)
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>Name</code> is a trail ARN, it must be in the following format.
         * </p>
         * <p>
         * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * </p>
         * 
         * @param name
         *        Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the string must
         *        meet the following requirements:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start with a letter or number, and end with a letter or number
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Be between 3 and 128 characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
         *        <code>my--namespace</code> are not valid.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Not be in IP address format (for example, 192.168.5.4)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>Name</code> is a trail ARN, it must be in the following format.
         *        </p>
         *        <p>
         *        <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a
         * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3
         * Bucket Naming Requirements</a>.
         * </p>
         * 
         * @param s3BucketName
         *        Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a
         *        href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html"
         *        >Amazon S3 Bucket Naming Requirements</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file
         * delivery. For more information, see <a
         * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your
         * CloudTrail Log Files</a>. The maximum length is 200 characters.
         * </p>
         * 
         * @param s3KeyPrefix
         *        Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log
         *        file delivery. For more information, see <a
         *        href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html"
         *        >Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);

        /**
         * <p>
         * Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length
         * is 256 characters.
         * </p>
         * 
         * @param snsTopicName
         *        Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum
         *        length is 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicName(String snsTopicName);

        /**
         * <p>
         * Specifies whether the trail is publishing events from global services such as IAM to the log files.
         * </p>
         * 
         * @param includeGlobalServiceEvents
         *        Specifies whether the trail is publishing events from global services such as IAM to the log files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeGlobalServiceEvents(Boolean includeGlobalServiceEvents);

        /**
         * <p>
         * Specifies whether the trail applies only to the current Region or to all Regions. The default is false. If
         * the trail exists only in the current Region and this value is set to true, shadow trails (replications of the
         * trail) will be created in the other Regions. If the trail exists in all Regions and this value is set to
         * false, the trail will remain in the Region where it was created, and its shadow trails in other Regions will
         * be deleted. As a best practice, consider using trails that log events in all Regions.
         * </p>
         * 
         * @param isMultiRegionTrail
         *        Specifies whether the trail applies only to the current Region or to all Regions. The default is
         *        false. If the trail exists only in the current Region and this value is set to true, shadow trails
         *        (replications of the trail) will be created in the other Regions. If the trail exists in all Regions
         *        and this value is set to false, the trail will remain in the Region where it was created, and its
         *        shadow trails in other Regions will be deleted. As a best practice, consider using trails that log
         *        events in all Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isMultiRegionTrail(Boolean isMultiRegionTrail);

        /**
         * <p>
         * Specifies whether log file validation is enabled. The default is false.
         * </p>
         * <note>
         * <p>
         * When you disable log file integrity validation, the chain of digest files is broken after one hour.
         * CloudTrail does not create digest files for log files that were delivered during a period in which log file
         * integrity validation was disabled. For example, if you enable log file integrity validation at noon on
         * January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be
         * created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever
         * you stop CloudTrail logging or delete a trail.
         * </p>
         * </note>
         * 
         * @param enableLogFileValidation
         *        Specifies whether log file validation is enabled. The default is false.</p> <note>
         *        <p>
         *        When you disable log file integrity validation, the chain of digest files is broken after one hour.
         *        CloudTrail does not create digest files for log files that were delivered during a period in which log
         *        file integrity validation was disabled. For example, if you enable log file integrity validation at
         *        noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest
         *        files will not be created for the log files delivered from noon on January 2 to noon on January 10.
         *        The same applies whenever you stop CloudTrail logging or delete a trail.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableLogFileValidation(Boolean enableLogFileValidation);

        /**
         * <p>
         * Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log
         * group to which CloudTrail logs are delivered. You must use a log group that exists in your account.
         * </p>
         * <p>
         * Not required unless you specify <code>CloudWatchLogsRoleArn</code>.
         * </p>
         * <note>
         * <p>
         * Only the management account can configure a CloudWatch Logs log group for an organization trail.
         * </p>
         * </note>
         * 
         * @param cloudWatchLogsLogGroupArn
         *        Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents
         *        the log group to which CloudTrail logs are delivered. You must use a log group that exists in your
         *        account.</p>
         *        <p>
         *        Not required unless you specify <code>CloudWatchLogsRoleArn</code>.
         *        </p>
         *        <note>
         *        <p>
         *        Only the management account can configure a CloudWatch Logs log group for an organization trail.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn);

        /**
         * <p>
         * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group. You must use a
         * role that exists in your account.
         * </p>
         * 
         * @param cloudWatchLogsRoleArn
         *        Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group. You must
         *        use a role that exists in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn);

        /**
         * <p>
         * Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name
         * prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique
         * identifier.
         * </p>
         * <p>
         * CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using
         * multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.
         * </p>
         * <p>
         * Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * alias/MyAliasName
         * </p>
         * </li>
         * <li>
         * <p>
         * arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
         * </p>
         * </li>
         * <li>
         * <p>
         * arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
         * </p>
         * </li>
         * <li>
         * <p>
         * 12345678-1234-1234-1234-123456789012
         * </p>
         * </li>
         * </ul>
         * 
         * @param kmsKeyId
         *        Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias
         *        name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a
         *        globally unique identifier.</p>
         *        <p>
         *        CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using
         *        multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        alias/MyAliasName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        12345678-1234-1234-1234-123456789012
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies whether the trail is applied to all accounts in an organization in Organizations, or only for the
         * current Amazon Web Services account. The default is false, and cannot be true unless the call is made on
         * behalf of an Amazon Web Services account that is the management account for an organization in Organizations.
         * If the trail is not an organization trail and this is set to <code>true</code>, the trail will be created in
         * all Amazon Web Services accounts that belong to the organization. If the trail is an organization trail and
         * this is set to <code>false</code>, the trail will remain in the current Amazon Web Services account but be
         * deleted from all member accounts in the organization.
         * </p>
         * <note>
         * <p>
         * Only the management account for the organization can convert an organization trail to a non-organization
         * trail, or convert a non-organization trail to an organization trail.
         * </p>
         * </note>
         * 
         * @param isOrganizationTrail
         *        Specifies whether the trail is applied to all accounts in an organization in Organizations, or only
         *        for the current Amazon Web Services account. The default is false, and cannot be true unless the call
         *        is made on behalf of an Amazon Web Services account that is the management account for an organization
         *        in Organizations. If the trail is not an organization trail and this is set to <code>true</code>, the
         *        trail will be created in all Amazon Web Services accounts that belong to the organization. If the
         *        trail is an organization trail and this is set to <code>false</code>, the trail will remain in the
         *        current Amazon Web Services account but be deleted from all member accounts in the organization.</p>
         *        <note>
         *        <p>
         *        Only the management account for the organization can convert an organization trail to a
         *        non-organization trail, or convert a non-organization trail to an organization trail.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isOrganizationTrail(Boolean isOrganizationTrail);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String name;

        private String s3BucketName;

        private String s3KeyPrefix;

        private String snsTopicName;

        private Boolean includeGlobalServiceEvents;

        private Boolean isMultiRegionTrail;

        private Boolean enableLogFileValidation;

        private String cloudWatchLogsLogGroupArn;

        private String cloudWatchLogsRoleArn;

        private String kmsKeyId;

        private Boolean isOrganizationTrail;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrailRequest model) {
            super(model);
            name(model.name);
            s3BucketName(model.s3BucketName);
            s3KeyPrefix(model.s3KeyPrefix);
            snsTopicName(model.snsTopicName);
            includeGlobalServiceEvents(model.includeGlobalServiceEvents);
            isMultiRegionTrail(model.isMultiRegionTrail);
            enableLogFileValidation(model.enableLogFileValidation);
            cloudWatchLogsLogGroupArn(model.cloudWatchLogsLogGroupArn);
            cloudWatchLogsRoleArn(model.cloudWatchLogsRoleArn);
            kmsKeyId(model.kmsKeyId);
            isOrganizationTrail(model.isOrganizationTrail);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final String getSnsTopicName() {
            return snsTopicName;
        }

        public final void setSnsTopicName(String snsTopicName) {
            this.snsTopicName = snsTopicName;
        }

        @Override
        public final Builder snsTopicName(String snsTopicName) {
            this.snsTopicName = snsTopicName;
            return this;
        }

        public final Boolean getIncludeGlobalServiceEvents() {
            return includeGlobalServiceEvents;
        }

        public final void setIncludeGlobalServiceEvents(Boolean includeGlobalServiceEvents) {
            this.includeGlobalServiceEvents = includeGlobalServiceEvents;
        }

        @Override
        public final Builder includeGlobalServiceEvents(Boolean includeGlobalServiceEvents) {
            this.includeGlobalServiceEvents = includeGlobalServiceEvents;
            return this;
        }

        public final Boolean getIsMultiRegionTrail() {
            return isMultiRegionTrail;
        }

        public final void setIsMultiRegionTrail(Boolean isMultiRegionTrail) {
            this.isMultiRegionTrail = isMultiRegionTrail;
        }

        @Override
        public final Builder isMultiRegionTrail(Boolean isMultiRegionTrail) {
            this.isMultiRegionTrail = isMultiRegionTrail;
            return this;
        }

        public final Boolean getEnableLogFileValidation() {
            return enableLogFileValidation;
        }

        public final void setEnableLogFileValidation(Boolean enableLogFileValidation) {
            this.enableLogFileValidation = enableLogFileValidation;
        }

        @Override
        public final Builder enableLogFileValidation(Boolean enableLogFileValidation) {
            this.enableLogFileValidation = enableLogFileValidation;
            return this;
        }

        public final String getCloudWatchLogsLogGroupArn() {
            return cloudWatchLogsLogGroupArn;
        }

        public final void setCloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
            return this;
        }

        public final String getCloudWatchLogsRoleArn() {
            return cloudWatchLogsRoleArn;
        }

        public final void setCloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
        }

        @Override
        public final Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getIsOrganizationTrail() {
            return isOrganizationTrail;
        }

        public final void setIsOrganizationTrail(Boolean isOrganizationTrail) {
            this.isOrganizationTrail = isOrganizationTrail;
        }

        @Override
        public final Builder isOrganizationTrail(Boolean isOrganizationTrail) {
            this.isOrganizationTrail = isOrganizationTrail;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrailRequest build() {
            return new UpdateTrailRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
