/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailAsyncClient;
import software.amazon.awssdk.services.cloudtrail.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataResponse;

public class ListInsightsMetricDataPublisher
implements SdkPublisher<ListInsightsMetricDataResponse> {
    private final CloudTrailAsyncClient client;
    private final ListInsightsMetricDataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInsightsMetricDataPublisher(CloudTrailAsyncClient client, ListInsightsMetricDataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInsightsMetricDataPublisher(CloudTrailAsyncClient client, ListInsightsMetricDataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInsightsMetricDataResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInsightsMetricDataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListInsightsMetricDataResponseFetcher
    implements AsyncPageFetcher<ListInsightsMetricDataResponse> {
        private ListInsightsMetricDataResponseFetcher() {
        }

        public boolean hasNextPage(ListInsightsMetricDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInsightsMetricDataResponse> nextPage(ListInsightsMetricDataResponse previousPage) {
            if (previousPage == null) {
                return ListInsightsMetricDataPublisher.this.client.listInsightsMetricData(ListInsightsMetricDataPublisher.this.firstRequest);
            }
            return ListInsightsMetricDataPublisher.this.client.listInsightsMetricData((ListInsightsMetricDataRequest)((Object)ListInsightsMetricDataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

