/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateQueryResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, GenerateQueryResponse> {
    private static final SdkField<String> QUERY_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryStatement").getter(GenerateQueryResponse.getter(GenerateQueryResponse::queryStatement)).setter(GenerateQueryResponse.setter(Builder::queryStatement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatement").build()}).build();
    private static final SdkField<String> QUERY_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryAlias").getter(GenerateQueryResponse.getter(GenerateQueryResponse::queryAlias)).setter(GenerateQueryResponse.setter(Builder::queryAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAlias").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STATEMENT_FIELD, QUERY_ALIAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("QueryStatement", QUERY_STATEMENT_FIELD);
            this.put("QueryAlias", QUERY_ALIAS_FIELD);
        }
    });
    private final String queryStatement;
    private final String queryAlias;

    private GenerateQueryResponse(BuilderImpl builder) {
        super(builder);
        this.queryStatement = builder.queryStatement;
        this.queryAlias = builder.queryAlias;
    }

    public final String queryStatement() {
        return this.queryStatement;
    }

    public final String queryAlias() {
        return this.queryAlias;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryAlias());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateQueryResponse)) {
            return false;
        }
        GenerateQueryResponse other = (GenerateQueryResponse)((Object)obj);
        return Objects.equals(this.queryStatement(), other.queryStatement()) && Objects.equals(this.queryAlias(), other.queryAlias());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateQueryResponse").add("QueryStatement", (Object)this.queryStatement()).add("QueryAlias", (Object)this.queryAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryStatement": {
                return Optional.ofNullable(clazz.cast(this.queryStatement()));
            }
            case "QueryAlias": {
                return Optional.ofNullable(clazz.cast(this.queryAlias()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GenerateQueryResponse, T> g) {
        return obj -> g.apply((GenerateQueryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String queryStatement;
        private String queryAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateQueryResponse model) {
            super(model);
            this.queryStatement(model.queryStatement);
            this.queryAlias(model.queryAlias);
        }

        public final String getQueryStatement() {
            return this.queryStatement;
        }

        public final void setQueryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
        }

        @Override
        public final Builder queryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
            return this;
        }

        public final String getQueryAlias() {
            return this.queryAlias;
        }

        public final void setQueryAlias(String queryAlias) {
            this.queryAlias = queryAlias;
        }

        @Override
        public final Builder queryAlias(String queryAlias) {
            this.queryAlias = queryAlias;
            return this;
        }

        @Override
        public GenerateQueryResponse build() {
            return new GenerateQueryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateQueryResponse> {
        public Builder queryStatement(String var1);

        public Builder queryAlias(String var1);
    }
}

