/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.RefreshSchedule;
import software.amazon.awssdk.services.cloudtrail.model.RequestWidget;
import software.amazon.awssdk.services.cloudtrail.model.RequestWidgetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDashboardRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, UpdateDashboardRequest> {
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardId").getter(UpdateDashboardRequest.getter(UpdateDashboardRequest::dashboardId)).setter(UpdateDashboardRequest.setter(Builder::dashboardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()}).build();
    private static final SdkField<List<RequestWidget>> WIDGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Widgets").getter(UpdateDashboardRequest.getter(UpdateDashboardRequest::widgets)).setter(UpdateDashboardRequest.setter(Builder::widgets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Widgets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RequestWidget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RefreshSchedule> REFRESH_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RefreshSchedule").getter(UpdateDashboardRequest.getter(UpdateDashboardRequest::refreshSchedule)).setter(UpdateDashboardRequest.setter(Builder::refreshSchedule)).constructor(RefreshSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedule").build()}).build();
    private static final SdkField<Boolean> TERMINATION_PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TerminationProtectionEnabled").getter(UpdateDashboardRequest.getter(UpdateDashboardRequest::terminationProtectionEnabled)).setter(UpdateDashboardRequest.setter(Builder::terminationProtectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtectionEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ID_FIELD, WIDGETS_FIELD, REFRESH_SCHEDULE_FIELD, TERMINATION_PROTECTION_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DashboardId", DASHBOARD_ID_FIELD);
            this.put("Widgets", WIDGETS_FIELD);
            this.put("RefreshSchedule", REFRESH_SCHEDULE_FIELD);
            this.put("TerminationProtectionEnabled", TERMINATION_PROTECTION_ENABLED_FIELD);
        }
    });
    private final String dashboardId;
    private final List<RequestWidget> widgets;
    private final RefreshSchedule refreshSchedule;
    private final Boolean terminationProtectionEnabled;

    private UpdateDashboardRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardId = builder.dashboardId;
        this.widgets = builder.widgets;
        this.refreshSchedule = builder.refreshSchedule;
        this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
    }

    public final String dashboardId() {
        return this.dashboardId;
    }

    public final boolean hasWidgets() {
        return this.widgets != null && !(this.widgets instanceof SdkAutoConstructList);
    }

    public final List<RequestWidget> widgets() {
        return this.widgets;
    }

    public final RefreshSchedule refreshSchedule() {
        return this.refreshSchedule;
    }

    public final Boolean terminationProtectionEnabled() {
        return this.terminationProtectionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWidgets() ? this.widgets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationProtectionEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDashboardRequest)) {
            return false;
        }
        UpdateDashboardRequest other = (UpdateDashboardRequest)((Object)obj);
        return Objects.equals(this.dashboardId(), other.dashboardId()) && this.hasWidgets() == other.hasWidgets() && Objects.equals(this.widgets(), other.widgets()) && Objects.equals(this.refreshSchedule(), other.refreshSchedule()) && Objects.equals(this.terminationProtectionEnabled(), other.terminationProtectionEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDashboardRequest").add("DashboardId", (Object)this.dashboardId()).add("Widgets", this.hasWidgets() ? this.widgets() : null).add("RefreshSchedule", (Object)this.refreshSchedule()).add("TerminationProtectionEnabled", (Object)this.terminationProtectionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardId": {
                return Optional.ofNullable(clazz.cast(this.dashboardId()));
            }
            case "Widgets": {
                return Optional.ofNullable(clazz.cast(this.widgets()));
            }
            case "RefreshSchedule": {
                return Optional.ofNullable(clazz.cast(this.refreshSchedule()));
            }
            case "TerminationProtectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.terminationProtectionEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDashboardRequest, T> g) {
        return obj -> g.apply((UpdateDashboardRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private String dashboardId;
        private List<RequestWidget> widgets = DefaultSdkAutoConstructList.getInstance();
        private RefreshSchedule refreshSchedule;
        private Boolean terminationProtectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDashboardRequest model) {
            super(model);
            this.dashboardId(model.dashboardId);
            this.widgets(model.widgets);
            this.refreshSchedule(model.refreshSchedule);
            this.terminationProtectionEnabled(model.terminationProtectionEnabled);
        }

        public final String getDashboardId() {
            return this.dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final List<RequestWidget.Builder> getWidgets() {
            List<RequestWidget.Builder> result = RequestWidgetListCopier.copyToBuilder(this.widgets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWidgets(Collection<RequestWidget.BuilderImpl> widgets) {
            this.widgets = RequestWidgetListCopier.copyFromBuilder(widgets);
        }

        @Override
        public final Builder widgets(Collection<RequestWidget> widgets) {
            this.widgets = RequestWidgetListCopier.copy(widgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(RequestWidget ... widgets) {
            this.widgets(Arrays.asList(widgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(Consumer<RequestWidget.Builder> ... widgets) {
            this.widgets(Stream.of(widgets).map(c -> (RequestWidget)((RequestWidget.Builder)RequestWidget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RefreshSchedule.Builder getRefreshSchedule() {
            return this.refreshSchedule != null ? this.refreshSchedule.toBuilder() : null;
        }

        public final void setRefreshSchedule(RefreshSchedule.BuilderImpl refreshSchedule) {
            this.refreshSchedule = refreshSchedule != null ? refreshSchedule.build() : null;
        }

        @Override
        public final Builder refreshSchedule(RefreshSchedule refreshSchedule) {
            this.refreshSchedule = refreshSchedule;
            return this;
        }

        public final Boolean getTerminationProtectionEnabled() {
            return this.terminationProtectionEnabled;
        }

        public final void setTerminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
        }

        @Override
        public final Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDashboardRequest build() {
            return new UpdateDashboardRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDashboardRequest> {
        public Builder dashboardId(String var1);

        public Builder widgets(Collection<RequestWidget> var1);

        public Builder widgets(RequestWidget ... var1);

        public Builder widgets(Consumer<RequestWidget.Builder> ... var1);

        public Builder refreshSchedule(RefreshSchedule var1);

        default public Builder refreshSchedule(Consumer<RefreshSchedule.Builder> refreshSchedule) {
            return this.refreshSchedule((RefreshSchedule)((RefreshSchedule.Builder)RefreshSchedule.builder().applyMutation(refreshSchedule)).build());
        }

        public Builder terminationProtectionEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

