/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.QueryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueriesRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, ListQueriesRequest> {
    private static final SdkField<String> EVENT_DATA_STORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStore").getter(ListQueriesRequest.getter(ListQueriesRequest::eventDataStore)).setter(ListQueriesRequest.setter(Builder::eventDataStore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStore").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListQueriesRequest.getter(ListQueriesRequest::nextToken)).setter(ListQueriesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListQueriesRequest.getter(ListQueriesRequest::maxResults)).setter(ListQueriesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ListQueriesRequest.getter(ListQueriesRequest::startTime)).setter(ListQueriesRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ListQueriesRequest.getter(ListQueriesRequest::endTime)).setter(ListQueriesRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> QUERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryStatus").getter(ListQueriesRequest.getter(ListQueriesRequest::queryStatusAsString)).setter(ListQueriesRequest.setter(Builder::queryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, START_TIME_FIELD, END_TIME_FIELD, QUERY_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EventDataStore", EVENT_DATA_STORE_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("EndTime", END_TIME_FIELD);
            this.put("QueryStatus", QUERY_STATUS_FIELD);
        }
    });
    private final String eventDataStore;
    private final String nextToken;
    private final Integer maxResults;
    private final Instant startTime;
    private final Instant endTime;
    private final String queryStatus;

    private ListQueriesRequest(BuilderImpl builder) {
        super(builder);
        this.eventDataStore = builder.eventDataStore;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.queryStatus = builder.queryStatus;
    }

    public final String eventDataStore() {
        return this.eventDataStore;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final QueryStatus queryStatus() {
        return QueryStatus.fromValue(this.queryStatus);
    }

    public final String queryStatusAsString() {
        return this.queryStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStore());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueriesRequest)) {
            return false;
        }
        ListQueriesRequest other = (ListQueriesRequest)((Object)obj);
        return Objects.equals(this.eventDataStore(), other.eventDataStore()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.queryStatusAsString(), other.queryStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListQueriesRequest").add("EventDataStore", (Object)this.eventDataStore()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("QueryStatus", (Object)this.queryStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventDataStore": {
                return Optional.ofNullable(clazz.cast(this.eventDataStore()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "QueryStatus": {
                return Optional.ofNullable(clazz.cast(this.queryStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListQueriesRequest, T> g) {
        return obj -> g.apply((ListQueriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private String eventDataStore;
        private String nextToken;
        private Integer maxResults;
        private Instant startTime;
        private Instant endTime;
        private String queryStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueriesRequest model) {
            super(model);
            this.eventDataStore(model.eventDataStore);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.queryStatus(model.queryStatus);
        }

        public final String getEventDataStore() {
            return this.eventDataStore;
        }

        public final void setEventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
        }

        @Override
        public final Builder eventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getQueryStatus() {
            return this.queryStatus;
        }

        public final void setQueryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
        }

        @Override
        public final Builder queryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
            return this;
        }

        @Override
        public final Builder queryStatus(QueryStatus queryStatus) {
            this.queryStatus(queryStatus == null ? null : queryStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListQueriesRequest build() {
            return new ListQueriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQueriesRequest> {
        public Builder eventDataStore(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder queryStatus(String var1);

        public Builder queryStatus(QueryStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

