/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DashboardType;
import software.amazon.awssdk.services.cloudtrail.model.RefreshSchedule;
import software.amazon.awssdk.services.cloudtrail.model.Widget;
import software.amazon.awssdk.services.cloudtrail.model.WidgetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDashboardResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, UpdateDashboardResponse> {
    private static final SdkField<String> DASHBOARD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardArn").getter(UpdateDashboardResponse.getter(UpdateDashboardResponse::dashboardArn)).setter(UpdateDashboardResponse.setter(Builder::dashboardArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateDashboardResponse.getter(UpdateDashboardResponse::name)).setter(UpdateDashboardResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(UpdateDashboardResponse.getter(UpdateDashboardResponse::typeAsString)).setter(UpdateDashboardResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<Widget>> WIDGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Widgets").getter(UpdateDashboardResponse.getter(UpdateDashboardResponse::widgets)).setter(UpdateDashboardResponse.setter(Builder::widgets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Widgets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Widget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RefreshSchedule> REFRESH_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RefreshSchedule").getter(UpdateDashboardResponse.getter(UpdateDashboardResponse::refreshSchedule)).setter(UpdateDashboardResponse.setter(Builder::refreshSchedule)).constructor(RefreshSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedule").build()}).build();
    private static final SdkField<Boolean> TERMINATION_PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TerminationProtectionEnabled").getter(UpdateDashboardResponse.getter(UpdateDashboardResponse::terminationProtectionEnabled)).setter(UpdateDashboardResponse.setter(Builder::terminationProtectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtectionEnabled").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(UpdateDashboardResponse.getter(UpdateDashboardResponse::createdTimestamp)).setter(UpdateDashboardResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(UpdateDashboardResponse.getter(UpdateDashboardResponse::updatedTimestamp)).setter(UpdateDashboardResponse.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ARN_FIELD, NAME_FIELD, TYPE_FIELD, WIDGETS_FIELD, REFRESH_SCHEDULE_FIELD, TERMINATION_PROTECTION_ENABLED_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DashboardArn", DASHBOARD_ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("Widgets", WIDGETS_FIELD);
            this.put("RefreshSchedule", REFRESH_SCHEDULE_FIELD);
            this.put("TerminationProtectionEnabled", TERMINATION_PROTECTION_ENABLED_FIELD);
            this.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
            this.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        }
    });
    private final String dashboardArn;
    private final String name;
    private final String type;
    private final List<Widget> widgets;
    private final RefreshSchedule refreshSchedule;
    private final Boolean terminationProtectionEnabled;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;

    private UpdateDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardArn = builder.dashboardArn;
        this.name = builder.name;
        this.type = builder.type;
        this.widgets = builder.widgets;
        this.refreshSchedule = builder.refreshSchedule;
        this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    public final String dashboardArn() {
        return this.dashboardArn;
    }

    public final String name() {
        return this.name;
    }

    public final DashboardType type() {
        return DashboardType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasWidgets() {
        return this.widgets != null && !(this.widgets instanceof SdkAutoConstructList);
    }

    public final List<Widget> widgets() {
        return this.widgets;
    }

    public final RefreshSchedule refreshSchedule() {
        return this.refreshSchedule;
    }

    public final Boolean terminationProtectionEnabled() {
        return this.terminationProtectionEnabled;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWidgets() ? this.widgets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDashboardResponse)) {
            return false;
        }
        UpdateDashboardResponse other = (UpdateDashboardResponse)((Object)obj);
        return Objects.equals(this.dashboardArn(), other.dashboardArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasWidgets() == other.hasWidgets() && Objects.equals(this.widgets(), other.widgets()) && Objects.equals(this.refreshSchedule(), other.refreshSchedule()) && Objects.equals(this.terminationProtectionEnabled(), other.terminationProtectionEnabled()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDashboardResponse").add("DashboardArn", (Object)this.dashboardArn()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Widgets", this.hasWidgets() ? this.widgets() : null).add("RefreshSchedule", (Object)this.refreshSchedule()).add("TerminationProtectionEnabled", (Object)this.terminationProtectionEnabled()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardArn": {
                return Optional.ofNullable(clazz.cast(this.dashboardArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Widgets": {
                return Optional.ofNullable(clazz.cast(this.widgets()));
            }
            case "RefreshSchedule": {
                return Optional.ofNullable(clazz.cast(this.refreshSchedule()));
            }
            case "TerminationProtectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.terminationProtectionEnabled()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDashboardResponse, T> g) {
        return obj -> g.apply((UpdateDashboardResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String dashboardArn;
        private String name;
        private String type;
        private List<Widget> widgets = DefaultSdkAutoConstructList.getInstance();
        private RefreshSchedule refreshSchedule;
        private Boolean terminationProtectionEnabled;
        private Instant createdTimestamp;
        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDashboardResponse model) {
            super(model);
            this.dashboardArn(model.dashboardArn);
            this.name(model.name);
            this.type(model.type);
            this.widgets(model.widgets);
            this.refreshSchedule(model.refreshSchedule);
            this.terminationProtectionEnabled(model.terminationProtectionEnabled);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
        }

        public final String getDashboardArn() {
            return this.dashboardArn;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DashboardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<Widget.Builder> getWidgets() {
            List<Widget.Builder> result = WidgetListCopier.copyToBuilder(this.widgets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWidgets(Collection<Widget.BuilderImpl> widgets) {
            this.widgets = WidgetListCopier.copyFromBuilder(widgets);
        }

        @Override
        public final Builder widgets(Collection<Widget> widgets) {
            this.widgets = WidgetListCopier.copy(widgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(Widget ... widgets) {
            this.widgets(Arrays.asList(widgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(Consumer<Widget.Builder> ... widgets) {
            this.widgets(Stream.of(widgets).map(c -> (Widget)((Widget.Builder)Widget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RefreshSchedule.Builder getRefreshSchedule() {
            return this.refreshSchedule != null ? this.refreshSchedule.toBuilder() : null;
        }

        public final void setRefreshSchedule(RefreshSchedule.BuilderImpl refreshSchedule) {
            this.refreshSchedule = refreshSchedule != null ? refreshSchedule.build() : null;
        }

        @Override
        public final Builder refreshSchedule(RefreshSchedule refreshSchedule) {
            this.refreshSchedule = refreshSchedule;
            return this;
        }

        public final Boolean getTerminationProtectionEnabled() {
            return this.terminationProtectionEnabled;
        }

        public final void setTerminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
        }

        @Override
        public final Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        @Override
        public UpdateDashboardResponse build() {
            return new UpdateDashboardResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDashboardResponse> {
        public Builder dashboardArn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(DashboardType var1);

        public Builder widgets(Collection<Widget> var1);

        public Builder widgets(Widget ... var1);

        public Builder widgets(Consumer<Widget.Builder> ... var1);

        public Builder refreshSchedule(RefreshSchedule var1);

        default public Builder refreshSchedule(Consumer<RefreshSchedule.Builder> refreshSchedule) {
            return this.refreshSchedule((RefreshSchedule)((RefreshSchedule.Builder)RefreshSchedule.builder().applyMutation(refreshSchedule)).build());
        }

        public Builder terminationProtectionEnabled(Boolean var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);
    }
}

