/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a response to a LookupEvents action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LookupEventsResponse extends CloudTrailResponse implements
        ToCopyableBuilder<LookupEventsResponse.Builder, LookupEventsResponse> {
    private static final SdkField<List<Event>> EVENTS_FIELD = SdkField
            .<List<Event>> builder(MarshallingType.LIST)
            .getter(getter(LookupEventsResponse::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Event> builder(MarshallingType.SDK_POJO)
                                            .constructor(Event::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LookupEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EVENTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Event> events;

    private final String nextToken;

    private LookupEventsResponse(BuilderImpl builder) {
        super(builder);
        this.events = builder.events;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of events returned based on the lookup attributes specified and the CloudTrail event. The events list is
     * sorted by time. The most recent event is listed first.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of events returned based on the lookup attributes specified and the CloudTrail event. The events
     *         list is sorted by time. The most recent event is listed first.
     */
    public List<Event> events() {
        return events;
    }

    /**
     * <p>
     * The token to use to get the next page of results after a previous API call. If the token does not appear, there
     * are no more results to return. The token must be passed in with the same parameters as the previous call. For
     * example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with
     * NextToken should include those same parameters.
     * </p>
     * 
     * @return The token to use to get the next page of results after a previous API call. If the token does not appear,
     *         there are no more results to return. The token must be passed in with the same parameters as the previous
     *         call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root',
     *         the call with NextToken should include those same parameters.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(events());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupEventsResponse)) {
            return false;
        }
        LookupEventsResponse other = (LookupEventsResponse) obj;
        return Objects.equals(events(), other.events()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("LookupEventsResponse").add("Events", events()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Events":
            return Optional.ofNullable(clazz.cast(events()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LookupEventsResponse, T> g) {
        return obj -> g.apply((LookupEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, LookupEventsResponse> {
        /**
         * <p>
         * A list of events returned based on the lookup attributes specified and the CloudTrail event. The events list
         * is sorted by time. The most recent event is listed first.
         * </p>
         * 
         * @param events
         *        A list of events returned based on the lookup attributes specified and the CloudTrail event. The
         *        events list is sorted by time. The most recent event is listed first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<Event> events);

        /**
         * <p>
         * A list of events returned based on the lookup attributes specified and the CloudTrail event. The events list
         * is sorted by time. The most recent event is listed first.
         * </p>
         * 
         * @param events
         *        A list of events returned based on the lookup attributes specified and the CloudTrail event. The
         *        events list is sorted by time. The most recent event is listed first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Event... events);

        /**
         * <p>
         * A list of events returned based on the lookup attributes specified and the CloudTrail event. The events list
         * is sorted by time. The most recent event is listed first.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Event>.Builder} avoiding the need to create
         * one manually via {@link List<Event>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Event>.Builder#build()} is called immediately and its result
         * is passed to {@link #events(List<Event>)}.
         * 
         * @param events
         *        a consumer that will call methods on {@link List<Event>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(List<Event>)
         */
        Builder events(Consumer<Event.Builder>... events);

        /**
         * <p>
         * The token to use to get the next page of results after a previous API call. If the token does not appear,
         * there are no more results to return. The token must be passed in with the same parameters as the previous
         * call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the
         * call with NextToken should include those same parameters.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next page of results after a previous API call. If the token does not
         *        appear, there are no more results to return. The token must be passed in with the same parameters as
         *        the previous call. For example, if the original call specified an AttributeKey of 'Username' with a
         *        value of 'root', the call with NextToken should include those same parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private List<Event> events = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(LookupEventsResponse model) {
            super(model);
            events(model.events);
            nextToken(model.nextToken);
        }

        public final Collection<Event.Builder> getEvents() {
            return events != null ? events.stream().map(Event::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<Event> events) {
            this.events = EventsListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<Event.Builder>... events) {
            events(Stream.of(events).map(c -> Event.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<Event.BuilderImpl> events) {
            this.events = EventsListCopier.copyFromBuilder(events);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public LookupEventsResponse build() {
            return new LookupEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
