/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the type and name of a resource referenced by an event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resource implements SdkPojo, Serializable, ToCopyableBuilder<Resource.Builder, Resource> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Resource::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Resource::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            RESOURCE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final String resourceName;

    private Resource(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceName = builder.resourceName;
    }

    /**
     * <p>
     * The type of a resource referenced by the event returned. When the resource type cannot be determined, null is
     * returned. Some examples of resource types are: <b>Instance</b> for EC2, <b>Trail</b> for CloudTrail,
     * <b>DBInstance</b> for RDS, and <b>AccessKey</b> for IAM. For a list of resource types supported for event lookup,
     * see <a
     * href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/lookup_supported_resourcetypes.html">Resource
     * Types Supported for Event Lookup</a>.
     * </p>
     * 
     * @return The type of a resource referenced by the event returned. When the resource type cannot be determined,
     *         null is returned. Some examples of resource types are: <b>Instance</b> for EC2, <b>Trail</b> for
     *         CloudTrail, <b>DBInstance</b> for RDS, and <b>AccessKey</b> for IAM. For a list of resource types
     *         supported for event lookup, see <a
     *         href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/lookup_supported_resourcetypes.html"
     *         >Resource Types Supported for Event Lookup</a>.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The name of the resource referenced by the event returned. These are user-created names whose values will depend
     * on the environment. For example, the resource name might be "auto-scaling-test-group" for an Auto Scaling Group
     * or "i-1234567" for an EC2 Instance.
     * </p>
     * 
     * @return The name of the resource referenced by the event returned. These are user-created names whose values will
     *         depend on the environment. For example, the resource name might be "auto-scaling-test-group" for an Auto
     *         Scaling Group or "i-1234567" for an EC2 Instance.
     */
    public String resourceName() {
        return resourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource) obj;
        return Objects.equals(resourceType(), other.resourceType()) && Objects.equals(resourceName(), other.resourceName());
    }

    @Override
    public String toString() {
        return ToString.builder("Resource").add("ResourceType", resourceType()).add("ResourceName", resourceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resource> {
        /**
         * <p>
         * The type of a resource referenced by the event returned. When the resource type cannot be determined, null is
         * returned. Some examples of resource types are: <b>Instance</b> for EC2, <b>Trail</b> for CloudTrail,
         * <b>DBInstance</b> for RDS, and <b>AccessKey</b> for IAM. For a list of resource types supported for event
         * lookup, see <a
         * href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/lookup_supported_resourcetypes.html">Resource
         * Types Supported for Event Lookup</a>.
         * </p>
         * 
         * @param resourceType
         *        The type of a resource referenced by the event returned. When the resource type cannot be determined,
         *        null is returned. Some examples of resource types are: <b>Instance</b> for EC2, <b>Trail</b> for
         *        CloudTrail, <b>DBInstance</b> for RDS, and <b>AccessKey</b> for IAM. For a list of resource types
         *        supported for event lookup, see <a
         *        href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/lookup_supported_resourcetypes.html"
         *        >Resource Types Supported for Event Lookup</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The name of the resource referenced by the event returned. These are user-created names whose values will
         * depend on the environment. For example, the resource name might be "auto-scaling-test-group" for an Auto
         * Scaling Group or "i-1234567" for an EC2 Instance.
         * </p>
         * 
         * @param resourceName
         *        The name of the resource referenced by the event returned. These are user-created names whose values
         *        will depend on the environment. For example, the resource name might be "auto-scaling-test-group" for
         *        an Auto Scaling Group or "i-1234567" for an EC2 Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private String resourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            resourceType(model.resourceType);
            resourceName(model.resourceName);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public Resource build() {
            return new Resource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
