/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.DataResource;
import software.amazon.awssdk.services.cloudtrail.model.DataResourcesCopier;
import software.amazon.awssdk.services.cloudtrail.model.ReadWriteType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventSelector> {
    private static final SdkField<String> READ_WRITE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EventSelector.getter(EventSelector::readWriteTypeAsString)).setter(EventSelector.setter(Builder::readWriteType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadWriteType").build()}).build();
    private static final SdkField<Boolean> INCLUDE_MANAGEMENT_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(EventSelector.getter(EventSelector::includeManagementEvents)).setter(EventSelector.setter(Builder::includeManagementEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeManagementEvents").build()}).build();
    private static final SdkField<List<DataResource>> DATA_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventSelector.getter(EventSelector::dataResources)).setter(EventSelector.setter(Builder::dataResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_WRITE_TYPE_FIELD, INCLUDE_MANAGEMENT_EVENTS_FIELD, DATA_RESOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String readWriteType;
    private final Boolean includeManagementEvents;
    private final List<DataResource> dataResources;

    private EventSelector(BuilderImpl builder) {
        this.readWriteType = builder.readWriteType;
        this.includeManagementEvents = builder.includeManagementEvents;
        this.dataResources = builder.dataResources;
    }

    public ReadWriteType readWriteType() {
        return ReadWriteType.fromValue(this.readWriteType);
    }

    public String readWriteTypeAsString() {
        return this.readWriteType;
    }

    public Boolean includeManagementEvents() {
        return this.includeManagementEvents;
    }

    public List<DataResource> dataResources() {
        return this.dataResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.readWriteTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeManagementEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataResources());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSelector)) {
            return false;
        }
        EventSelector other = (EventSelector)obj;
        return Objects.equals(this.readWriteTypeAsString(), other.readWriteTypeAsString()) && Objects.equals(this.includeManagementEvents(), other.includeManagementEvents()) && Objects.equals(this.dataResources(), other.dataResources());
    }

    public String toString() {
        return ToString.builder((String)"EventSelector").add("ReadWriteType", (Object)this.readWriteTypeAsString()).add("IncludeManagementEvents", (Object)this.includeManagementEvents()).add("DataResources", this.dataResources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReadWriteType": {
                return Optional.ofNullable(clazz.cast(this.readWriteTypeAsString()));
            }
            case "IncludeManagementEvents": {
                return Optional.ofNullable(clazz.cast(this.includeManagementEvents()));
            }
            case "DataResources": {
                return Optional.ofNullable(clazz.cast(this.dataResources()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventSelector, T> g) {
        return obj -> g.apply((EventSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String readWriteType;
        private Boolean includeManagementEvents;
        private List<DataResource> dataResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventSelector model) {
            this.readWriteType(model.readWriteType);
            this.includeManagementEvents(model.includeManagementEvents);
            this.dataResources(model.dataResources);
        }

        public final String getReadWriteTypeAsString() {
            return this.readWriteType;
        }

        @Override
        public final Builder readWriteType(String readWriteType) {
            this.readWriteType = readWriteType;
            return this;
        }

        @Override
        public final Builder readWriteType(ReadWriteType readWriteType) {
            this.readWriteType(readWriteType.toString());
            return this;
        }

        public final void setReadWriteType(String readWriteType) {
            this.readWriteType = readWriteType;
        }

        public final Boolean getIncludeManagementEvents() {
            return this.includeManagementEvents;
        }

        @Override
        public final Builder includeManagementEvents(Boolean includeManagementEvents) {
            this.includeManagementEvents = includeManagementEvents;
            return this;
        }

        public final void setIncludeManagementEvents(Boolean includeManagementEvents) {
            this.includeManagementEvents = includeManagementEvents;
        }

        public final Collection<DataResource.Builder> getDataResources() {
            return this.dataResources != null ? (Collection)this.dataResources.stream().map(DataResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataResources(Collection<DataResource> dataResources) {
            this.dataResources = DataResourcesCopier.copy(dataResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataResources(DataResource ... dataResources) {
            this.dataResources(Arrays.asList(dataResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataResources(Consumer<DataResource.Builder> ... dataResources) {
            this.dataResources(Stream.of(dataResources).map(c -> (DataResource)((DataResource.Builder)DataResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDataResources(Collection<DataResource.BuilderImpl> dataResources) {
            this.dataResources = DataResourcesCopier.copyFromBuilder(dataResources);
        }

        public EventSelector build() {
            return new EventSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventSelector> {
        public Builder readWriteType(String var1);

        public Builder readWriteType(ReadWriteType var1);

        public Builder includeManagementEvents(Boolean var1);

        public Builder dataResources(Collection<DataResource> var1);

        public Builder dataResources(DataResource ... var1);

        public Builder dataResources(Consumer<DataResource.Builder> ... var1);
    }
}

