/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateQueryRequest extends CloudTrailRequest implements
        ToCopyableBuilder<GenerateQueryRequest.Builder, GenerateQueryRequest> {
    private static final SdkField<List<String>> EVENT_DATA_STORES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EventDataStores")
            .getter(getter(GenerateQueryRequest::eventDataStores))
            .setter(setter(Builder::eventDataStores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStores").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROMPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prompt")
            .getter(getter(GenerateQueryRequest::prompt)).setter(setter(Builder::prompt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prompt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORES_FIELD,
            PROMPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> eventDataStores;

    private final String prompt;

    private GenerateQueryRequest(BuilderImpl builder) {
        super(builder);
        this.eventDataStores = builder.eventDataStores;
        this.prompt = builder.prompt;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventDataStores property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventDataStores() {
        return eventDataStores != null && !(eventDataStores instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN (or ID suffix of the ARN) of the event data store that you want to query. You can only specify one event
     * data store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventDataStores} method.
     * </p>
     * 
     * @return The ARN (or ID suffix of the ARN) of the event data store that you want to query. You can only specify
     *         one event data store.
     */
    public final List<String> eventDataStores() {
        return eventDataStores;
    }

    /**
     * <p>
     * The prompt that you want to use to generate the query. The prompt must be in English. For example prompts, see <a
     * href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-query-generator.html#lake-query-generator-examples"
     * >Example prompts</a> in the <i>CloudTrail </i> user guide.
     * </p>
     * 
     * @return The prompt that you want to use to generate the query. The prompt must be in English. For example
     *         prompts, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-query-generator.html#lake-query-generator-examples"
     *         >Example prompts</a> in the <i>CloudTrail </i> user guide.
     */
    public final String prompt() {
        return prompt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventDataStores() ? eventDataStores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(prompt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateQueryRequest)) {
            return false;
        }
        GenerateQueryRequest other = (GenerateQueryRequest) obj;
        return hasEventDataStores() == other.hasEventDataStores() && Objects.equals(eventDataStores(), other.eventDataStores())
                && Objects.equals(prompt(), other.prompt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateQueryRequest").add("EventDataStores", hasEventDataStores() ? eventDataStores() : null)
                .add("Prompt", prompt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventDataStores":
            return Optional.ofNullable(clazz.cast(eventDataStores()));
        case "Prompt":
            return Optional.ofNullable(clazz.cast(prompt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventDataStores", EVENT_DATA_STORES_FIELD);
        map.put("Prompt", PROMPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateQueryRequest, T> g) {
        return obj -> g.apply((GenerateQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, GenerateQueryRequest> {
        /**
         * <p>
         * The ARN (or ID suffix of the ARN) of the event data store that you want to query. You can only specify one
         * event data store.
         * </p>
         * 
         * @param eventDataStores
         *        The ARN (or ID suffix of the ARN) of the event data store that you want to query. You can only specify
         *        one event data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataStores(Collection<String> eventDataStores);

        /**
         * <p>
         * The ARN (or ID suffix of the ARN) of the event data store that you want to query. You can only specify one
         * event data store.
         * </p>
         * 
         * @param eventDataStores
         *        The ARN (or ID suffix of the ARN) of the event data store that you want to query. You can only specify
         *        one event data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataStores(String... eventDataStores);

        /**
         * <p>
         * The prompt that you want to use to generate the query. The prompt must be in English. For example prompts,
         * see <a href=
         * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-query-generator.html#lake-query-generator-examples"
         * >Example prompts</a> in the <i>CloudTrail </i> user guide.
         * </p>
         * 
         * @param prompt
         *        The prompt that you want to use to generate the query. The prompt must be in English. For example
         *        prompts, see <a href=
         *        "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-query-generator.html#lake-query-generator-examples"
         *        >Example prompts</a> in the <i>CloudTrail </i> user guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prompt(String prompt);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private List<String> eventDataStores = DefaultSdkAutoConstructList.getInstance();

        private String prompt;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateQueryRequest model) {
            super(model);
            eventDataStores(model.eventDataStores);
            prompt(model.prompt);
        }

        public final Collection<String> getEventDataStores() {
            if (eventDataStores instanceof SdkAutoConstructList) {
                return null;
            }
            return eventDataStores;
        }

        public final void setEventDataStores(Collection<String> eventDataStores) {
            this.eventDataStores = EventDataStoreListCopier.copy(eventDataStores);
        }

        @Override
        public final Builder eventDataStores(Collection<String> eventDataStores) {
            this.eventDataStores = EventDataStoreListCopier.copy(eventDataStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDataStores(String... eventDataStores) {
            eventDataStores(Arrays.asList(eventDataStores));
            return this;
        }

        public final String getPrompt() {
            return prompt;
        }

        public final void setPrompt(String prompt) {
            this.prompt = prompt;
        }

        @Override
        public final Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateQueryRequest build() {
            return new GenerateQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
