/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets metadata about a query, including the number of events that were matched, the total number of events scanned,
 * the query run time in milliseconds, and the query's creation time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryStatisticsForDescribeQuery implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryStatisticsForDescribeQuery.Builder, QueryStatisticsForDescribeQuery> {
    private static final SdkField<Long> EVENTS_MATCHED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EventsMatched").getter(getter(QueryStatisticsForDescribeQuery::eventsMatched))
            .setter(setter(Builder::eventsMatched))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsMatched").build()).build();

    private static final SdkField<Long> EVENTS_SCANNED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EventsScanned").getter(getter(QueryStatisticsForDescribeQuery::eventsScanned))
            .setter(setter(Builder::eventsScanned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsScanned").build()).build();

    private static final SdkField<Long> BYTES_SCANNED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BytesScanned").getter(getter(QueryStatisticsForDescribeQuery::bytesScanned))
            .setter(setter(Builder::bytesScanned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesScanned").build()).build();

    private static final SdkField<Integer> EXECUTION_TIME_IN_MILLIS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExecutionTimeInMillis").getter(getter(QueryStatisticsForDescribeQuery::executionTimeInMillis))
            .setter(setter(Builder::executionTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTimeInMillis").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(QueryStatisticsForDescribeQuery::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_MATCHED_FIELD,
            EVENTS_SCANNED_FIELD, BYTES_SCANNED_FIELD, EXECUTION_TIME_IN_MILLIS_FIELD, CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long eventsMatched;

    private final Long eventsScanned;

    private final Long bytesScanned;

    private final Integer executionTimeInMillis;

    private final Instant creationTime;

    private QueryStatisticsForDescribeQuery(BuilderImpl builder) {
        this.eventsMatched = builder.eventsMatched;
        this.eventsScanned = builder.eventsScanned;
        this.bytesScanned = builder.bytesScanned;
        this.executionTimeInMillis = builder.executionTimeInMillis;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The number of events that matched a query.
     * </p>
     * 
     * @return The number of events that matched a query.
     */
    public final Long eventsMatched() {
        return eventsMatched;
    }

    /**
     * <p>
     * The number of events that the query scanned in the event data store.
     * </p>
     * 
     * @return The number of events that the query scanned in the event data store.
     */
    public final Long eventsScanned() {
        return eventsScanned;
    }

    /**
     * <p>
     * The total bytes that the query scanned in the event data store. This value matches the number of bytes for which
     * your account is billed for the query, unless the query is still running.
     * </p>
     * 
     * @return The total bytes that the query scanned in the event data store. This value matches the number of bytes
     *         for which your account is billed for the query, unless the query is still running.
     */
    public final Long bytesScanned() {
        return bytesScanned;
    }

    /**
     * <p>
     * The query's run time, in milliseconds.
     * </p>
     * 
     * @return The query's run time, in milliseconds.
     */
    public final Integer executionTimeInMillis() {
        return executionTimeInMillis;
    }

    /**
     * <p>
     * The creation time of the query.
     * </p>
     * 
     * @return The creation time of the query.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventsMatched());
        hashCode = 31 * hashCode + Objects.hashCode(eventsScanned());
        hashCode = 31 * hashCode + Objects.hashCode(bytesScanned());
        hashCode = 31 * hashCode + Objects.hashCode(executionTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStatisticsForDescribeQuery)) {
            return false;
        }
        QueryStatisticsForDescribeQuery other = (QueryStatisticsForDescribeQuery) obj;
        return Objects.equals(eventsMatched(), other.eventsMatched()) && Objects.equals(eventsScanned(), other.eventsScanned())
                && Objects.equals(bytesScanned(), other.bytesScanned())
                && Objects.equals(executionTimeInMillis(), other.executionTimeInMillis())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryStatisticsForDescribeQuery").add("EventsMatched", eventsMatched())
                .add("EventsScanned", eventsScanned()).add("BytesScanned", bytesScanned())
                .add("ExecutionTimeInMillis", executionTimeInMillis()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventsMatched":
            return Optional.ofNullable(clazz.cast(eventsMatched()));
        case "EventsScanned":
            return Optional.ofNullable(clazz.cast(eventsScanned()));
        case "BytesScanned":
            return Optional.ofNullable(clazz.cast(bytesScanned()));
        case "ExecutionTimeInMillis":
            return Optional.ofNullable(clazz.cast(executionTimeInMillis()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventsMatched", EVENTS_MATCHED_FIELD);
        map.put("EventsScanned", EVENTS_SCANNED_FIELD);
        map.put("BytesScanned", BYTES_SCANNED_FIELD);
        map.put("ExecutionTimeInMillis", EXECUTION_TIME_IN_MILLIS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryStatisticsForDescribeQuery, T> g) {
        return obj -> g.apply((QueryStatisticsForDescribeQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryStatisticsForDescribeQuery> {
        /**
         * <p>
         * The number of events that matched a query.
         * </p>
         * 
         * @param eventsMatched
         *        The number of events that matched a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsMatched(Long eventsMatched);

        /**
         * <p>
         * The number of events that the query scanned in the event data store.
         * </p>
         * 
         * @param eventsScanned
         *        The number of events that the query scanned in the event data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsScanned(Long eventsScanned);

        /**
         * <p>
         * The total bytes that the query scanned in the event data store. This value matches the number of bytes for
         * which your account is billed for the query, unless the query is still running.
         * </p>
         * 
         * @param bytesScanned
         *        The total bytes that the query scanned in the event data store. This value matches the number of bytes
         *        for which your account is billed for the query, unless the query is still running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesScanned(Long bytesScanned);

        /**
         * <p>
         * The query's run time, in milliseconds.
         * </p>
         * 
         * @param executionTimeInMillis
         *        The query's run time, in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTimeInMillis(Integer executionTimeInMillis);

        /**
         * <p>
         * The creation time of the query.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private Long eventsMatched;

        private Long eventsScanned;

        private Long bytesScanned;

        private Integer executionTimeInMillis;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryStatisticsForDescribeQuery model) {
            eventsMatched(model.eventsMatched);
            eventsScanned(model.eventsScanned);
            bytesScanned(model.bytesScanned);
            executionTimeInMillis(model.executionTimeInMillis);
            creationTime(model.creationTime);
        }

        public final Long getEventsMatched() {
            return eventsMatched;
        }

        public final void setEventsMatched(Long eventsMatched) {
            this.eventsMatched = eventsMatched;
        }

        @Override
        public final Builder eventsMatched(Long eventsMatched) {
            this.eventsMatched = eventsMatched;
            return this;
        }

        public final Long getEventsScanned() {
            return eventsScanned;
        }

        public final void setEventsScanned(Long eventsScanned) {
            this.eventsScanned = eventsScanned;
        }

        @Override
        public final Builder eventsScanned(Long eventsScanned) {
            this.eventsScanned = eventsScanned;
            return this;
        }

        public final Long getBytesScanned() {
            return bytesScanned;
        }

        public final void setBytesScanned(Long bytesScanned) {
            this.bytesScanned = bytesScanned;
        }

        @Override
        public final Builder bytesScanned(Long bytesScanned) {
            this.bytesScanned = bytesScanned;
            return this;
        }

        public final Integer getExecutionTimeInMillis() {
            return executionTimeInMillis;
        }

        public final void setExecutionTimeInMillis(Integer executionTimeInMillis) {
            this.executionTimeInMillis = executionTimeInMillis;
        }

        @Override
        public final Builder executionTimeInMillis(Integer executionTimeInMillis) {
            this.executionTimeInMillis = executionTimeInMillis;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public QueryStatisticsForDescribeQuery build() {
            return new QueryStatisticsForDescribeQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
