/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableFederationRequest extends CloudTrailRequest implements
        ToCopyableBuilder<EnableFederationRequest.Builder, EnableFederationRequest> {
    private static final SdkField<String> EVENT_DATA_STORE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventDataStore").getter(getter(EnableFederationRequest::eventDataStore))
            .setter(setter(Builder::eventDataStore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStore").build()).build();

    private static final SdkField<String> FEDERATION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FederationRoleArn").getter(getter(EnableFederationRequest::federationRoleArn))
            .setter(setter(Builder::federationRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederationRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_FIELD,
            FEDERATION_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String eventDataStore;

    private final String federationRoleArn;

    private EnableFederationRequest(BuilderImpl builder) {
        super(builder);
        this.eventDataStore = builder.eventDataStore;
        this.federationRoleArn = builder.federationRoleArn;
    }

    /**
     * <p>
     * The ARN (or ID suffix of the ARN) of the event data store for which you want to enable Lake query federation.
     * </p>
     * 
     * @return The ARN (or ID suffix of the ARN) of the event data store for which you want to enable Lake query
     *         federation.
     */
    public final String eventDataStore() {
        return eventDataStore;
    }

    /**
     * <p>
     * The ARN of the federation role to use for the event data store. Amazon Web Services services like Lake Formation
     * use this federation role to access data for the federated event data store. The federation role must exist in
     * your account and provide the <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html#query-federation-permissions-role"
     * >required minimum permissions</a>.
     * </p>
     * 
     * @return The ARN of the federation role to use for the event data store. Amazon Web Services services like Lake
     *         Formation use this federation role to access data for the federated event data store. The federation role
     *         must exist in your account and provide the <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html#query-federation-permissions-role"
     *         >required minimum permissions</a>.
     */
    public final String federationRoleArn() {
        return federationRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventDataStore());
        hashCode = 31 * hashCode + Objects.hashCode(federationRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFederationRequest)) {
            return false;
        }
        EnableFederationRequest other = (EnableFederationRequest) obj;
        return Objects.equals(eventDataStore(), other.eventDataStore())
                && Objects.equals(federationRoleArn(), other.federationRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableFederationRequest").add("EventDataStore", eventDataStore())
                .add("FederationRoleArn", federationRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventDataStore":
            return Optional.ofNullable(clazz.cast(eventDataStore()));
        case "FederationRoleArn":
            return Optional.ofNullable(clazz.cast(federationRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventDataStore", EVENT_DATA_STORE_FIELD);
        map.put("FederationRoleArn", FEDERATION_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableFederationRequest, T> g) {
        return obj -> g.apply((EnableFederationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, EnableFederationRequest> {
        /**
         * <p>
         * The ARN (or ID suffix of the ARN) of the event data store for which you want to enable Lake query federation.
         * </p>
         * 
         * @param eventDataStore
         *        The ARN (or ID suffix of the ARN) of the event data store for which you want to enable Lake query
         *        federation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataStore(String eventDataStore);

        /**
         * <p>
         * The ARN of the federation role to use for the event data store. Amazon Web Services services like Lake
         * Formation use this federation role to access data for the federated event data store. The federation role
         * must exist in your account and provide the <a href=
         * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html#query-federation-permissions-role"
         * >required minimum permissions</a>.
         * </p>
         * 
         * @param federationRoleArn
         *        The ARN of the federation role to use for the event data store. Amazon Web Services services like Lake
         *        Formation use this federation role to access data for the federated event data store. The federation
         *        role must exist in your account and provide the <a href=
         *        "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html#query-federation-permissions-role"
         *        >required minimum permissions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder federationRoleArn(String federationRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String eventDataStore;

        private String federationRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableFederationRequest model) {
            super(model);
            eventDataStore(model.eventDataStore);
            federationRoleArn(model.federationRoleArn);
        }

        public final String getEventDataStore() {
            return eventDataStore;
        }

        public final void setEventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
        }

        @Override
        public final Builder eventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
            return this;
        }

        public final String getFederationRoleArn() {
            return federationRoleArn;
        }

        public final void setFederationRoleArn(String federationRoleArn) {
            this.federationRoleArn = federationRoleArn;
        }

        @Override
        public final Builder federationRoleArn(String federationRoleArn) {
            this.federationRoleArn = federationRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableFederationRequest build() {
            return new EnableFederationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
