/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableFederationResponse extends CloudTrailResponse implements
        ToCopyableBuilder<EnableFederationResponse.Builder, EnableFederationResponse> {
    private static final SdkField<String> EVENT_DATA_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventDataStoreArn").getter(getter(EnableFederationResponse::eventDataStoreArn))
            .setter(setter(Builder::eventDataStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStoreArn").build()).build();

    private static final SdkField<String> FEDERATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FederationStatus").getter(getter(EnableFederationResponse::federationStatusAsString))
            .setter(setter(Builder::federationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederationStatus").build()).build();

    private static final SdkField<String> FEDERATION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FederationRoleArn").getter(getter(EnableFederationResponse::federationRoleArn))
            .setter(setter(Builder::federationRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederationRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_ARN_FIELD,
            FEDERATION_STATUS_FIELD, FEDERATION_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String eventDataStoreArn;

    private final String federationStatus;

    private final String federationRoleArn;

    private EnableFederationResponse(BuilderImpl builder) {
        super(builder);
        this.eventDataStoreArn = builder.eventDataStoreArn;
        this.federationStatus = builder.federationStatus;
        this.federationRoleArn = builder.federationRoleArn;
    }

    /**
     * <p>
     * The ARN of the event data store for which you enabled Lake query federation.
     * </p>
     * 
     * @return The ARN of the event data store for which you enabled Lake query federation.
     */
    public final String eventDataStoreArn() {
        return eventDataStoreArn;
    }

    /**
     * <p>
     * The federation status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #federationStatus}
     * will return {@link FederationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #federationStatusAsString}.
     * </p>
     * 
     * @return The federation status.
     * @see FederationStatus
     */
    public final FederationStatus federationStatus() {
        return FederationStatus.fromValue(federationStatus);
    }

    /**
     * <p>
     * The federation status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #federationStatus}
     * will return {@link FederationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #federationStatusAsString}.
     * </p>
     * 
     * @return The federation status.
     * @see FederationStatus
     */
    public final String federationStatusAsString() {
        return federationStatus;
    }

    /**
     * <p>
     * The ARN of the federation role.
     * </p>
     * 
     * @return The ARN of the federation role.
     */
    public final String federationRoleArn() {
        return federationRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventDataStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(federationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(federationRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFederationResponse)) {
            return false;
        }
        EnableFederationResponse other = (EnableFederationResponse) obj;
        return Objects.equals(eventDataStoreArn(), other.eventDataStoreArn())
                && Objects.equals(federationStatusAsString(), other.federationStatusAsString())
                && Objects.equals(federationRoleArn(), other.federationRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableFederationResponse").add("EventDataStoreArn", eventDataStoreArn())
                .add("FederationStatus", federationStatusAsString()).add("FederationRoleArn", federationRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventDataStoreArn":
            return Optional.ofNullable(clazz.cast(eventDataStoreArn()));
        case "FederationStatus":
            return Optional.ofNullable(clazz.cast(federationStatusAsString()));
        case "FederationRoleArn":
            return Optional.ofNullable(clazz.cast(federationRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventDataStoreArn", EVENT_DATA_STORE_ARN_FIELD);
        map.put("FederationStatus", FEDERATION_STATUS_FIELD);
        map.put("FederationRoleArn", FEDERATION_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableFederationResponse, T> g) {
        return obj -> g.apply((EnableFederationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, EnableFederationResponse> {
        /**
         * <p>
         * The ARN of the event data store for which you enabled Lake query federation.
         * </p>
         * 
         * @param eventDataStoreArn
         *        The ARN of the event data store for which you enabled Lake query federation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataStoreArn(String eventDataStoreArn);

        /**
         * <p>
         * The federation status.
         * </p>
         * 
         * @param federationStatus
         *        The federation status.
         * @see FederationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FederationStatus
         */
        Builder federationStatus(String federationStatus);

        /**
         * <p>
         * The federation status.
         * </p>
         * 
         * @param federationStatus
         *        The federation status.
         * @see FederationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FederationStatus
         */
        Builder federationStatus(FederationStatus federationStatus);

        /**
         * <p>
         * The ARN of the federation role.
         * </p>
         * 
         * @param federationRoleArn
         *        The ARN of the federation role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder federationRoleArn(String federationRoleArn);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String eventDataStoreArn;

        private String federationStatus;

        private String federationRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableFederationResponse model) {
            super(model);
            eventDataStoreArn(model.eventDataStoreArn);
            federationStatus(model.federationStatus);
            federationRoleArn(model.federationRoleArn);
        }

        public final String getEventDataStoreArn() {
            return eventDataStoreArn;
        }

        public final void setEventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
        }

        @Override
        public final Builder eventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
            return this;
        }

        public final String getFederationStatus() {
            return federationStatus;
        }

        public final void setFederationStatus(String federationStatus) {
            this.federationStatus = federationStatus;
        }

        @Override
        public final Builder federationStatus(String federationStatus) {
            this.federationStatus = federationStatus;
            return this;
        }

        @Override
        public final Builder federationStatus(FederationStatus federationStatus) {
            this.federationStatus(federationStatus == null ? null : federationStatus.toString());
            return this;
        }

        public final String getFederationRoleArn() {
            return federationRoleArn;
        }

        public final void setFederationRoleArn(String federationRoleArn) {
            this.federationRoleArn = federationRoleArn;
        }

        @Override
        public final Builder federationRoleArn(String federationRoleArn) {
            this.federationRoleArn = federationRoleArn;
            return this;
        }

        @Override
        public EnableFederationResponse build() {
            return new EnableFederationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
