/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDashboardsRequest extends CloudTrailRequest implements
        ToCopyableBuilder<ListDashboardsRequest.Builder, ListDashboardsRequest> {
    private static final SdkField<String> NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NamePrefix").getter(getter(ListDashboardsRequest::namePrefix)).setter(setter(Builder::namePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamePrefix").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ListDashboardsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDashboardsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListDashboardsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_PREFIX_FIELD, TYPE_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String namePrefix;

    private final String type;

    private final String nextToken;

    private final Integer maxResults;

    private ListDashboardsRequest(BuilderImpl builder) {
        super(builder);
        this.namePrefix = builder.namePrefix;
        this.type = builder.type;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Specify a name prefix to filter on.
     * </p>
     * 
     * @return Specify a name prefix to filter on.
     */
    public final String namePrefix() {
        return namePrefix;
    }

    /**
     * <p>
     * Specify a dashboard type to filter on: <code>CUSTOM</code> or <code>MANAGED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DashboardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specify a dashboard type to filter on: <code>CUSTOM</code> or <code>MANAGED</code>.
     * @see DashboardType
     */
    public final DashboardType type() {
        return DashboardType.fromValue(type);
    }

    /**
     * <p>
     * Specify a dashboard type to filter on: <code>CUSTOM</code> or <code>MANAGED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DashboardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specify a dashboard type to filter on: <code>CUSTOM</code> or <code>MANAGED</code>.
     * @see DashboardType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A token you can use to get the next page of dashboard results.
     * </p>
     * 
     * @return A token you can use to get the next page of dashboard results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of dashboards to display on a single page.
     * </p>
     * 
     * @return The maximum number of dashboards to display on a single page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDashboardsRequest)) {
            return false;
        }
        ListDashboardsRequest other = (ListDashboardsRequest) obj;
        return Objects.equals(namePrefix(), other.namePrefix()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDashboardsRequest").add("NamePrefix", namePrefix()).add("Type", typeAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamePrefix":
            return Optional.ofNullable(clazz.cast(namePrefix()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NamePrefix", NAME_PREFIX_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDashboardsRequest, T> g) {
        return obj -> g.apply((ListDashboardsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDashboardsRequest> {
        /**
         * <p>
         * Specify a name prefix to filter on.
         * </p>
         * 
         * @param namePrefix
         *        Specify a name prefix to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namePrefix(String namePrefix);

        /**
         * <p>
         * Specify a dashboard type to filter on: <code>CUSTOM</code> or <code>MANAGED</code>.
         * </p>
         * 
         * @param type
         *        Specify a dashboard type to filter on: <code>CUSTOM</code> or <code>MANAGED</code>.
         * @see DashboardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashboardType
         */
        Builder type(String type);

        /**
         * <p>
         * Specify a dashboard type to filter on: <code>CUSTOM</code> or <code>MANAGED</code>.
         * </p>
         * 
         * @param type
         *        Specify a dashboard type to filter on: <code>CUSTOM</code> or <code>MANAGED</code>.
         * @see DashboardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashboardType
         */
        Builder type(DashboardType type);

        /**
         * <p>
         * A token you can use to get the next page of dashboard results.
         * </p>
         * 
         * @param nextToken
         *        A token you can use to get the next page of dashboard results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of dashboards to display on a single page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of dashboards to display on a single page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String namePrefix;

        private String type;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDashboardsRequest model) {
            super(model);
            namePrefix(model.namePrefix);
            type(model.type);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getNamePrefix() {
            return namePrefix;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DashboardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDashboardsRequest build() {
            return new ListDashboardsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
