/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInsightsMetricDataRequest extends CloudTrailRequest implements
        ToCopyableBuilder<ListInsightsMetricDataRequest.Builder, ListInsightsMetricDataRequest> {
    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSource").getter(getter(ListInsightsMetricDataRequest::eventSource))
            .setter(setter(Builder::eventSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSource").build()).build();

    private static final SdkField<String> EVENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventName").getter(getter(ListInsightsMetricDataRequest::eventName)).setter(setter(Builder::eventName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventName").build()).build();

    private static final SdkField<String> INSIGHT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InsightType").getter(getter(ListInsightsMetricDataRequest::insightTypeAsString))
            .setter(setter(Builder::insightType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightType").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(ListInsightsMetricDataRequest::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ListInsightsMetricDataRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ListInsightsMetricDataRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Period").getter(getter(ListInsightsMetricDataRequest::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataType").getter(getter(ListInsightsMetricDataRequest::dataTypeAsString))
            .setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListInsightsMetricDataRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInsightsMetricDataRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SOURCE_FIELD,
            EVENT_NAME_FIELD, INSIGHT_TYPE_FIELD, ERROR_CODE_FIELD, START_TIME_FIELD, END_TIME_FIELD, PERIOD_FIELD,
            DATA_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String eventSource;

    private final String eventName;

    private final String insightType;

    private final String errorCode;

    private final Instant startTime;

    private final Instant endTime;

    private final Integer period;

    private final String dataType;

    private final Integer maxResults;

    private final String nextToken;

    private ListInsightsMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.eventSource = builder.eventSource;
        this.eventName = builder.eventName;
        this.insightType = builder.insightType;
        this.errorCode = builder.errorCode;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.period = builder.period;
        this.dataType = builder.dataType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Web Services service to which the request was made, such as <code>iam.amazonaws.com</code> or
     * <code>s3.amazonaws.com</code>.
     * </p>
     * 
     * @return The Amazon Web Services service to which the request was made, such as <code>iam.amazonaws.com</code> or
     *         <code>s3.amazonaws.com</code>.
     */
    public final String eventSource() {
        return eventSource;
    }

    /**
     * <p>
     * The name of the event, typically the Amazon Web Services API on which unusual levels of activity were recorded.
     * </p>
     * 
     * @return The name of the event, typically the Amazon Web Services API on which unusual levels of activity were
     *         recorded.
     */
    public final String eventName() {
        return eventName;
    }

    /**
     * <p>
     * The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or
     * <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes write-only
     * management API calls that are aggregated per minute against a baseline API call volume. The
     * <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #insightType} will
     * return {@link InsightType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #insightTypeAsString}.
     * </p>
     * 
     * @return The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or
     *         <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes write-only
     *         management API calls that are aggregated per minute against a baseline API call volume. The
     *         <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
     * @see InsightType
     */
    public final InsightType insightType() {
        return InsightType.fromValue(insightType);
    }

    /**
     * <p>
     * The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or
     * <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes write-only
     * management API calls that are aggregated per minute against a baseline API call volume. The
     * <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #insightType} will
     * return {@link InsightType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #insightTypeAsString}.
     * </p>
     * 
     * @return The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or
     *         <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes write-only
     *         management API calls that are aggregated per minute against a baseline API call volume. The
     *         <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
     * @see InsightType
     */
    public final String insightTypeAsString() {
        return insightType;
    }

    /**
     * <p>
     * Conditionally required if the <code>InsightType</code> parameter is set to <code>ApiErrorRateInsight</code>.
     * </p>
     * <p>
     * If returning metrics for the <code>ApiErrorRateInsight</code> Insights type, this is the error to retrieve data
     * for. For example, <code>AccessDenied</code>.
     * </p>
     * 
     * @return Conditionally required if the <code>InsightType</code> parameter is set to
     *         <code>ApiErrorRateInsight</code>.</p>
     *         <p>
     *         If returning metrics for the <code>ApiErrorRateInsight</code> Insights type, this is the error to
     *         retrieve data for. For example, <code>AccessDenied</code>.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * Specifies, in UTC, the start time for time-series data. The value specified is inclusive; results include data
     * points with the specified time stamp.
     * </p>
     * <p>
     * The default is 90 days before the time of request.
     * </p>
     * 
     * @return Specifies, in UTC, the start time for time-series data. The value specified is inclusive; results include
     *         data points with the specified time stamp.</p>
     *         <p>
     *         The default is 90 days before the time of request.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Specifies, in UTC, the end time for time-series data. The value specified is exclusive; results include data
     * points up to the specified time stamp.
     * </p>
     * <p>
     * The default is the time of request.
     * </p>
     * 
     * @return Specifies, in UTC, the end time for time-series data. The value specified is exclusive; results include
     *         data points up to the specified time stamp.</p>
     *         <p>
     *         The default is the time of request.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Granularity of data to retrieve, in seconds. Valid values are <code>60</code>, <code>300</code>, and
     * <code>3600</code>. If you specify any other value, you will get an error. The default is 3600 seconds.
     * </p>
     * 
     * @return Granularity of data to retrieve, in seconds. Valid values are <code>60</code>, <code>300</code>, and
     *         <code>3600</code>. If you specify any other value, you will get an error. The default is 3600 seconds.
     */
    public final Integer period() {
        return period;
    }

    /**
     * <p>
     * Type of data points to return. Valid values are <code>NonZeroData</code> and <code>FillWithZeros</code>. The
     * default is <code>NonZeroData</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link InsightsMetricDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataTypeAsString}.
     * </p>
     * 
     * @return Type of data points to return. Valid values are <code>NonZeroData</code> and <code>FillWithZeros</code>.
     *         The default is <code>NonZeroData</code>.
     * @see InsightsMetricDataType
     */
    public final InsightsMetricDataType dataType() {
        return InsightsMetricDataType.fromValue(dataType);
    }

    /**
     * <p>
     * Type of data points to return. Valid values are <code>NonZeroData</code> and <code>FillWithZeros</code>. The
     * default is <code>NonZeroData</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link InsightsMetricDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataTypeAsString}.
     * </p>
     * 
     * @return Type of data points to return. Valid values are <code>NonZeroData</code> and <code>FillWithZeros</code>.
     *         The default is <code>NonZeroData</code>.
     * @see InsightsMetricDataType
     */
    public final String dataTypeAsString() {
        return dataType;
    }

    /**
     * <p>
     * The maximum number of data points to return. Valid values are integers from 1 to 21600. The default value is
     * 21600.
     * </p>
     * 
     * @return The maximum number of data points to return. Valid values are integers from 1 to 21600. The default value
     *         is 21600.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Returned if all datapoints can't be returned in a single call. For example, due to reaching
     * <code>MaxResults</code>.
     * </p>
     * <p>
     * Add this parameter to the request to continue retrieving results starting from the last evaluated point.
     * </p>
     * 
     * @return Returned if all datapoints can't be returned in a single call. For example, due to reaching
     *         <code>MaxResults</code>.</p>
     *         <p>
     *         Add this parameter to the request to continue retrieving results starting from the last evaluated point.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventSource());
        hashCode = 31 * hashCode + Objects.hashCode(eventName());
        hashCode = 31 * hashCode + Objects.hashCode(insightTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInsightsMetricDataRequest)) {
            return false;
        }
        ListInsightsMetricDataRequest other = (ListInsightsMetricDataRequest) obj;
        return Objects.equals(eventSource(), other.eventSource()) && Objects.equals(eventName(), other.eventName())
                && Objects.equals(insightTypeAsString(), other.insightTypeAsString())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(period(), other.period())
                && Objects.equals(dataTypeAsString(), other.dataTypeAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInsightsMetricDataRequest").add("EventSource", eventSource()).add("EventName", eventName())
                .add("InsightType", insightTypeAsString()).add("ErrorCode", errorCode()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Period", period()).add("DataType", dataTypeAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventSource":
            return Optional.ofNullable(clazz.cast(eventSource()));
        case "EventName":
            return Optional.ofNullable(clazz.cast(eventName()));
        case "InsightType":
            return Optional.ofNullable(clazz.cast(insightTypeAsString()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        case "DataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventSource", EVENT_SOURCE_FIELD);
        map.put("EventName", EVENT_NAME_FIELD);
        map.put("InsightType", INSIGHT_TYPE_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Period", PERIOD_FIELD);
        map.put("DataType", DATA_TYPE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInsightsMetricDataRequest, T> g) {
        return obj -> g.apply((ListInsightsMetricDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListInsightsMetricDataRequest> {
        /**
         * <p>
         * The Amazon Web Services service to which the request was made, such as <code>iam.amazonaws.com</code> or
         * <code>s3.amazonaws.com</code>.
         * </p>
         * 
         * @param eventSource
         *        The Amazon Web Services service to which the request was made, such as <code>iam.amazonaws.com</code>
         *        or <code>s3.amazonaws.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSource(String eventSource);

        /**
         * <p>
         * The name of the event, typically the Amazon Web Services API on which unusual levels of activity were
         * recorded.
         * </p>
         * 
         * @param eventName
         *        The name of the event, typically the Amazon Web Services API on which unusual levels of activity were
         *        recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventName(String eventName);

        /**
         * <p>
         * The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or
         * <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes write-only
         * management API calls that are aggregated per minute against a baseline API call volume. The
         * <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
         * </p>
         * 
         * @param insightType
         *        The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or
         *        <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes
         *        write-only management API calls that are aggregated per minute against a baseline API call volume. The
         *        <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error
         *        codes.
         * @see InsightType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightType
         */
        Builder insightType(String insightType);

        /**
         * <p>
         * The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or
         * <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes write-only
         * management API calls that are aggregated per minute against a baseline API call volume. The
         * <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
         * </p>
         * 
         * @param insightType
         *        The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or
         *        <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes
         *        write-only management API calls that are aggregated per minute against a baseline API call volume. The
         *        <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error
         *        codes.
         * @see InsightType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightType
         */
        Builder insightType(InsightType insightType);

        /**
         * <p>
         * Conditionally required if the <code>InsightType</code> parameter is set to <code>ApiErrorRateInsight</code>.
         * </p>
         * <p>
         * If returning metrics for the <code>ApiErrorRateInsight</code> Insights type, this is the error to retrieve
         * data for. For example, <code>AccessDenied</code>.
         * </p>
         * 
         * @param errorCode
         *        Conditionally required if the <code>InsightType</code> parameter is set to
         *        <code>ApiErrorRateInsight</code>.</p>
         *        <p>
         *        If returning metrics for the <code>ApiErrorRateInsight</code> Insights type, this is the error to
         *        retrieve data for. For example, <code>AccessDenied</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * Specifies, in UTC, the start time for time-series data. The value specified is inclusive; results include
         * data points with the specified time stamp.
         * </p>
         * <p>
         * The default is 90 days before the time of request.
         * </p>
         * 
         * @param startTime
         *        Specifies, in UTC, the start time for time-series data. The value specified is inclusive; results
         *        include data points with the specified time stamp.</p>
         *        <p>
         *        The default is 90 days before the time of request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Specifies, in UTC, the end time for time-series data. The value specified is exclusive; results include data
         * points up to the specified time stamp.
         * </p>
         * <p>
         * The default is the time of request.
         * </p>
         * 
         * @param endTime
         *        Specifies, in UTC, the end time for time-series data. The value specified is exclusive; results
         *        include data points up to the specified time stamp.</p>
         *        <p>
         *        The default is the time of request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Granularity of data to retrieve, in seconds. Valid values are <code>60</code>, <code>300</code>, and
         * <code>3600</code>. If you specify any other value, you will get an error. The default is 3600 seconds.
         * </p>
         * 
         * @param period
         *        Granularity of data to retrieve, in seconds. Valid values are <code>60</code>, <code>300</code>, and
         *        <code>3600</code>. If you specify any other value, you will get an error. The default is 3600 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * Type of data points to return. Valid values are <code>NonZeroData</code> and <code>FillWithZeros</code>. The
         * default is <code>NonZeroData</code>.
         * </p>
         * 
         * @param dataType
         *        Type of data points to return. Valid values are <code>NonZeroData</code> and
         *        <code>FillWithZeros</code>. The default is <code>NonZeroData</code>.
         * @see InsightsMetricDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightsMetricDataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * Type of data points to return. Valid values are <code>NonZeroData</code> and <code>FillWithZeros</code>. The
         * default is <code>NonZeroData</code>.
         * </p>
         * 
         * @param dataType
         *        Type of data points to return. Valid values are <code>NonZeroData</code> and
         *        <code>FillWithZeros</code>. The default is <code>NonZeroData</code>.
         * @see InsightsMetricDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightsMetricDataType
         */
        Builder dataType(InsightsMetricDataType dataType);

        /**
         * <p>
         * The maximum number of data points to return. Valid values are integers from 1 to 21600. The default value is
         * 21600.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of data points to return. Valid values are integers from 1 to 21600. The default
         *        value is 21600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Returned if all datapoints can't be returned in a single call. For example, due to reaching
         * <code>MaxResults</code>.
         * </p>
         * <p>
         * Add this parameter to the request to continue retrieving results starting from the last evaluated point.
         * </p>
         * 
         * @param nextToken
         *        Returned if all datapoints can't be returned in a single call. For example, due to reaching
         *        <code>MaxResults</code>.</p>
         *        <p>
         *        Add this parameter to the request to continue retrieving results starting from the last evaluated
         *        point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String eventSource;

        private String eventName;

        private String insightType;

        private String errorCode;

        private Instant startTime;

        private Instant endTime;

        private Integer period;

        private String dataType;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInsightsMetricDataRequest model) {
            super(model);
            eventSource(model.eventSource);
            eventName(model.eventName);
            insightType(model.insightType);
            errorCode(model.errorCode);
            startTime(model.startTime);
            endTime(model.endTime);
            period(model.period);
            dataType(model.dataType);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getEventSource() {
            return eventSource;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final String getEventName() {
            return eventName;
        }

        public final void setEventName(String eventName) {
            this.eventName = eventName;
        }

        @Override
        public final Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public final String getInsightType() {
            return insightType;
        }

        public final void setInsightType(String insightType) {
            this.insightType = insightType;
        }

        @Override
        public final Builder insightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        @Override
        public final Builder insightType(InsightType insightType) {
            this.insightType(insightType == null ? null : insightType.toString());
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getPeriod() {
            return period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(InsightsMetricDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInsightsMetricDataRequest build() {
            return new ListInsightsMetricDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
