/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQueriesRequest extends CloudTrailRequest implements
        ToCopyableBuilder<ListQueriesRequest.Builder, ListQueriesRequest> {
    private static final SdkField<String> EVENT_DATA_STORE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventDataStore").getter(getter(ListQueriesRequest::eventDataStore))
            .setter(setter(Builder::eventDataStore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStore").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListQueriesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListQueriesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ListQueriesRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ListQueriesRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> QUERY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryStatus").getter(getter(ListQueriesRequest::queryStatusAsString))
            .setter(setter(Builder::queryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, START_TIME_FIELD, END_TIME_FIELD, QUERY_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String eventDataStore;

    private final String nextToken;

    private final Integer maxResults;

    private final Instant startTime;

    private final Instant endTime;

    private final String queryStatus;

    private ListQueriesRequest(BuilderImpl builder) {
        super(builder);
        this.eventDataStore = builder.eventDataStore;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.queryStatus = builder.queryStatus;
    }

    /**
     * <p>
     * The ARN (or the ID suffix of the ARN) of an event data store on which queries were run.
     * </p>
     * 
     * @return The ARN (or the ID suffix of the ARN) of an event data store on which queries were run.
     */
    public final String eventDataStore() {
        return eventDataStore;
    }

    /**
     * <p>
     * A token you can use to get the next page of results.
     * </p>
     * 
     * @return A token you can use to get the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of queries to show on a page.
     * </p>
     * 
     * @return The maximum number of queries to show on a page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Use with <code>EndTime</code> to bound a <code>ListQueries</code> request, and limit its results to only those
     * queries run within a specified time period.
     * </p>
     * 
     * @return Use with <code>EndTime</code> to bound a <code>ListQueries</code> request, and limit its results to only
     *         those queries run within a specified time period.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Use with <code>StartTime</code> to bound a <code>ListQueries</code> request, and limit its results to only those
     * queries run within a specified time period.
     * </p>
     * 
     * @return Use with <code>StartTime</code> to bound a <code>ListQueries</code> request, and limit its results to
     *         only those queries run within a specified time period.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The status of queries that you want to return in results. Valid values for <code>QueryStatus</code> include
     * <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or
     * <code>CANCELLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryStatus} will
     * return {@link QueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryStatusAsString}.
     * </p>
     * 
     * @return The status of queries that you want to return in results. Valid values for <code>QueryStatus</code>
     *         include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>,
     *         <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
     * @see QueryStatus
     */
    public final QueryStatus queryStatus() {
        return QueryStatus.fromValue(queryStatus);
    }

    /**
     * <p>
     * The status of queries that you want to return in results. Valid values for <code>QueryStatus</code> include
     * <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or
     * <code>CANCELLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryStatus} will
     * return {@link QueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryStatusAsString}.
     * </p>
     * 
     * @return The status of queries that you want to return in results. Valid values for <code>QueryStatus</code>
     *         include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>,
     *         <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
     * @see QueryStatus
     */
    public final String queryStatusAsString() {
        return queryStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventDataStore());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(queryStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueriesRequest)) {
            return false;
        }
        ListQueriesRequest other = (ListQueriesRequest) obj;
        return Objects.equals(eventDataStore(), other.eventDataStore()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime())
                && Objects.equals(queryStatusAsString(), other.queryStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListQueriesRequest").add("EventDataStore", eventDataStore()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("QueryStatus", queryStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventDataStore":
            return Optional.ofNullable(clazz.cast(eventDataStore()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "QueryStatus":
            return Optional.ofNullable(clazz.cast(queryStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventDataStore", EVENT_DATA_STORE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("QueryStatus", QUERY_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQueriesRequest, T> g) {
        return obj -> g.apply((ListQueriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListQueriesRequest> {
        /**
         * <p>
         * The ARN (or the ID suffix of the ARN) of an event data store on which queries were run.
         * </p>
         * 
         * @param eventDataStore
         *        The ARN (or the ID suffix of the ARN) of an event data store on which queries were run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataStore(String eventDataStore);

        /**
         * <p>
         * A token you can use to get the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A token you can use to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of queries to show on a page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of queries to show on a page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Use with <code>EndTime</code> to bound a <code>ListQueries</code> request, and limit its results to only
         * those queries run within a specified time period.
         * </p>
         * 
         * @param startTime
         *        Use with <code>EndTime</code> to bound a <code>ListQueries</code> request, and limit its results to
         *        only those queries run within a specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Use with <code>StartTime</code> to bound a <code>ListQueries</code> request, and limit its results to only
         * those queries run within a specified time period.
         * </p>
         * 
         * @param endTime
         *        Use with <code>StartTime</code> to bound a <code>ListQueries</code> request, and limit its results to
         *        only those queries run within a specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The status of queries that you want to return in results. Valid values for <code>QueryStatus</code> include
         * <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>
         * , or <code>CANCELLED</code>.
         * </p>
         * 
         * @param queryStatus
         *        The status of queries that you want to return in results. Valid values for <code>QueryStatus</code>
         *        include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>,
         *        <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
         * @see QueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryStatus
         */
        Builder queryStatus(String queryStatus);

        /**
         * <p>
         * The status of queries that you want to return in results. Valid values for <code>QueryStatus</code> include
         * <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>
         * , or <code>CANCELLED</code>.
         * </p>
         * 
         * @param queryStatus
         *        The status of queries that you want to return in results. Valid values for <code>QueryStatus</code>
         *        include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>,
         *        <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
         * @see QueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryStatus
         */
        Builder queryStatus(QueryStatus queryStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String eventDataStore;

        private String nextToken;

        private Integer maxResults;

        private Instant startTime;

        private Instant endTime;

        private String queryStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueriesRequest model) {
            super(model);
            eventDataStore(model.eventDataStore);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            startTime(model.startTime);
            endTime(model.endTime);
            queryStatus(model.queryStatus);
        }

        public final String getEventDataStore() {
            return eventDataStore;
        }

        public final void setEventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
        }

        @Override
        public final Builder eventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getQueryStatus() {
            return queryStatus;
        }

        public final void setQueryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
        }

        @Override
        public final Builder queryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
            return this;
        }

        @Override
        public final Builder queryStatus(QueryStatus queryStatus) {
            this.queryStatus(queryStatus == null ? null : queryStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListQueriesRequest build() {
            return new ListQueriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
