/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The schedule for a dashboard refresh.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefreshSchedule implements SdkPojo, Serializable, ToCopyableBuilder<RefreshSchedule.Builder, RefreshSchedule> {
    private static final SdkField<RefreshScheduleFrequency> FREQUENCY_FIELD = SdkField
            .<RefreshScheduleFrequency> builder(MarshallingType.SDK_POJO).memberName("Frequency")
            .getter(getter(RefreshSchedule::frequency)).setter(setter(Builder::frequency))
            .constructor(RefreshScheduleFrequency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RefreshSchedule::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TIME_OF_DAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeOfDay").getter(getter(RefreshSchedule::timeOfDay)).setter(setter(Builder::timeOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeOfDay").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREQUENCY_FIELD, STATUS_FIELD,
            TIME_OF_DAY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RefreshScheduleFrequency frequency;

    private final String status;

    private final String timeOfDay;

    private RefreshSchedule(BuilderImpl builder) {
        this.frequency = builder.frequency;
        this.status = builder.status;
        this.timeOfDay = builder.timeOfDay;
    }

    /**
     * <p>
     * The frequency at which you want the dashboard refreshed.
     * </p>
     * 
     * @return The frequency at which you want the dashboard refreshed.
     */
    public final RefreshScheduleFrequency frequency() {
        return frequency;
    }

    /**
     * <p>
     * Specifies whether the refresh schedule is enabled. Set the value to <code>ENABLED</code> to enable the refresh
     * schedule, or to <code>DISABLED</code> to turn off the refresh schedule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RefreshScheduleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies whether the refresh schedule is enabled. Set the value to <code>ENABLED</code> to enable the
     *         refresh schedule, or to <code>DISABLED</code> to turn off the refresh schedule.
     * @see RefreshScheduleStatus
     */
    public final RefreshScheduleStatus status() {
        return RefreshScheduleStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies whether the refresh schedule is enabled. Set the value to <code>ENABLED</code> to enable the refresh
     * schedule, or to <code>DISABLED</code> to turn off the refresh schedule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RefreshScheduleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies whether the refresh schedule is enabled. Set the value to <code>ENABLED</code> to enable the
     *         refresh schedule, or to <code>DISABLED</code> to turn off the refresh schedule.
     * @see RefreshScheduleStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time of day in UTC to run the schedule; for hourly only refer to minutes; default is 00:00.
     * </p>
     * 
     * @return The time of day in UTC to run the schedule; for hourly only refer to minutes; default is 00:00.
     */
    public final String timeOfDay() {
        return timeOfDay;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(frequency());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timeOfDay());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshSchedule)) {
            return false;
        }
        RefreshSchedule other = (RefreshSchedule) obj;
        return Objects.equals(frequency(), other.frequency()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(timeOfDay(), other.timeOfDay());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RefreshSchedule").add("Frequency", frequency()).add("Status", statusAsString())
                .add("TimeOfDay", timeOfDay()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Frequency":
            return Optional.ofNullable(clazz.cast(frequency()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "TimeOfDay":
            return Optional.ofNullable(clazz.cast(timeOfDay()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Frequency", FREQUENCY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TimeOfDay", TIME_OF_DAY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RefreshSchedule, T> g) {
        return obj -> g.apply((RefreshSchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RefreshSchedule> {
        /**
         * <p>
         * The frequency at which you want the dashboard refreshed.
         * </p>
         * 
         * @param frequency
         *        The frequency at which you want the dashboard refreshed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frequency(RefreshScheduleFrequency frequency);

        /**
         * <p>
         * The frequency at which you want the dashboard refreshed.
         * </p>
         * This is a convenience method that creates an instance of the {@link RefreshScheduleFrequency.Builder}
         * avoiding the need to create one manually via {@link RefreshScheduleFrequency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RefreshScheduleFrequency.Builder#build()} is called immediately
         * and its result is passed to {@link #frequency(RefreshScheduleFrequency)}.
         * 
         * @param frequency
         *        a consumer that will call methods on {@link RefreshScheduleFrequency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frequency(RefreshScheduleFrequency)
         */
        default Builder frequency(Consumer<RefreshScheduleFrequency.Builder> frequency) {
            return frequency(RefreshScheduleFrequency.builder().applyMutation(frequency).build());
        }

        /**
         * <p>
         * Specifies whether the refresh schedule is enabled. Set the value to <code>ENABLED</code> to enable the
         * refresh schedule, or to <code>DISABLED</code> to turn off the refresh schedule.
         * </p>
         * 
         * @param status
         *        Specifies whether the refresh schedule is enabled. Set the value to <code>ENABLED</code> to enable the
         *        refresh schedule, or to <code>DISABLED</code> to turn off the refresh schedule.
         * @see RefreshScheduleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RefreshScheduleStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies whether the refresh schedule is enabled. Set the value to <code>ENABLED</code> to enable the
         * refresh schedule, or to <code>DISABLED</code> to turn off the refresh schedule.
         * </p>
         * 
         * @param status
         *        Specifies whether the refresh schedule is enabled. Set the value to <code>ENABLED</code> to enable the
         *        refresh schedule, or to <code>DISABLED</code> to turn off the refresh schedule.
         * @see RefreshScheduleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RefreshScheduleStatus
         */
        Builder status(RefreshScheduleStatus status);

        /**
         * <p>
         * The time of day in UTC to run the schedule; for hourly only refer to minutes; default is 00:00.
         * </p>
         * 
         * @param timeOfDay
         *        The time of day in UTC to run the schedule; for hourly only refer to minutes; default is 00:00.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeOfDay(String timeOfDay);
    }

    static final class BuilderImpl implements Builder {
        private RefreshScheduleFrequency frequency;

        private String status;

        private String timeOfDay;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshSchedule model) {
            frequency(model.frequency);
            status(model.status);
            timeOfDay(model.timeOfDay);
        }

        public final RefreshScheduleFrequency.Builder getFrequency() {
            return frequency != null ? frequency.toBuilder() : null;
        }

        public final void setFrequency(RefreshScheduleFrequency.BuilderImpl frequency) {
            this.frequency = frequency != null ? frequency.build() : null;
        }

        @Override
        public final Builder frequency(RefreshScheduleFrequency frequency) {
            this.frequency = frequency;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RefreshScheduleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTimeOfDay() {
            return timeOfDay;
        }

        public final void setTimeOfDay(String timeOfDay) {
            this.timeOfDay = timeOfDay;
        }

        @Override
        public final Builder timeOfDay(String timeOfDay) {
            this.timeOfDay = timeOfDay;
            return this;
        }

        @Override
        public RefreshSchedule build() {
            return new RefreshSchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
