/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDashboardRefreshResponse extends CloudTrailResponse implements
        ToCopyableBuilder<StartDashboardRefreshResponse.Builder, StartDashboardRefreshResponse> {
    private static final SdkField<String> REFRESH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RefreshId").getter(getter(StartDashboardRefreshResponse::refreshId)).setter(setter(Builder::refreshId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFRESH_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String refreshId;

    private StartDashboardRefreshResponse(BuilderImpl builder) {
        super(builder);
        this.refreshId = builder.refreshId;
    }

    /**
     * <p>
     * The refresh ID for the dashboard.
     * </p>
     * 
     * @return The refresh ID for the dashboard.
     */
    public final String refreshId() {
        return refreshId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(refreshId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDashboardRefreshResponse)) {
            return false;
        }
        StartDashboardRefreshResponse other = (StartDashboardRefreshResponse) obj;
        return Objects.equals(refreshId(), other.refreshId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDashboardRefreshResponse").add("RefreshId", refreshId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RefreshId":
            return Optional.ofNullable(clazz.cast(refreshId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RefreshId", REFRESH_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDashboardRefreshResponse, T> g) {
        return obj -> g.apply((StartDashboardRefreshResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartDashboardRefreshResponse> {
        /**
         * <p>
         * The refresh ID for the dashboard.
         * </p>
         * 
         * @param refreshId
         *        The refresh ID for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshId(String refreshId);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String refreshId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDashboardRefreshResponse model) {
            super(model);
            refreshId(model.refreshId);
        }

        public final String getRefreshId() {
            return refreshId;
        }

        public final void setRefreshId(String refreshId) {
            this.refreshId = refreshId;
        }

        @Override
        public final Builder refreshId(String refreshId) {
            this.refreshId = refreshId;
            return this;
        }

        @Override
        public StartDashboardRefreshResponse build() {
            return new StartDashboardRefreshResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
