/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartQueryResponse extends CloudTrailResponse implements
        ToCopyableBuilder<StartQueryResponse.Builder, StartQueryResponse> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryId").getter(getter(StartQueryResponse::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()).build();

    private static final SdkField<String> EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EventDataStoreOwnerAccountId")
            .getter(getter(StartQueryResponse::eventDataStoreOwnerAccountId))
            .setter(setter(Builder::eventDataStoreOwnerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStoreOwnerAccountId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD,
            EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String queryId;

    private final String eventDataStoreOwnerAccountId;

    private StartQueryResponse(BuilderImpl builder) {
        super(builder);
        this.queryId = builder.queryId;
        this.eventDataStoreOwnerAccountId = builder.eventDataStoreOwnerAccountId;
    }

    /**
     * <p>
     * The ID of the started query.
     * </p>
     * 
     * @return The ID of the started query.
     */
    public final String queryId() {
        return queryId;
    }

    /**
     * <p>
     * The account ID of the event data store owner.
     * </p>
     * 
     * @return The account ID of the event data store owner.
     */
    public final String eventDataStoreOwnerAccountId() {
        return eventDataStoreOwnerAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(eventDataStoreOwnerAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQueryResponse)) {
            return false;
        }
        StartQueryResponse other = (StartQueryResponse) obj;
        return Objects.equals(queryId(), other.queryId())
                && Objects.equals(eventDataStoreOwnerAccountId(), other.eventDataStoreOwnerAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartQueryResponse").add("QueryId", queryId())
                .add("EventDataStoreOwnerAccountId", eventDataStoreOwnerAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "EventDataStoreOwnerAccountId":
            return Optional.ofNullable(clazz.cast(eventDataStoreOwnerAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("EventDataStoreOwnerAccountId", EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartQueryResponse, T> g) {
        return obj -> g.apply((StartQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartQueryResponse> {
        /**
         * <p>
         * The ID of the started query.
         * </p>
         * 
         * @param queryId
         *        The ID of the started query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * The account ID of the event data store owner.
         * </p>
         * 
         * @param eventDataStoreOwnerAccountId
         *        The account ID of the event data store owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String queryId;

        private String eventDataStoreOwnerAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartQueryResponse model) {
            super(model);
            queryId(model.queryId);
            eventDataStoreOwnerAccountId(model.eventDataStoreOwnerAccountId);
        }

        public final String getQueryId() {
            return queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getEventDataStoreOwnerAccountId() {
            return eventDataStoreOwnerAccountId;
        }

        public final void setEventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId) {
            this.eventDataStoreOwnerAccountId = eventDataStoreOwnerAccountId;
        }

        @Override
        public final Builder eventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId) {
            this.eventDataStoreOwnerAccountId = eventDataStoreOwnerAccountId;
            return this;
        }

        @Override
        public StartQueryResponse build() {
            return new StartQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
