/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDashboardRequest extends CloudTrailRequest implements
        ToCopyableBuilder<UpdateDashboardRequest.Builder, UpdateDashboardRequest> {
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardId").getter(getter(UpdateDashboardRequest::dashboardId)).setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()).build();

    private static final SdkField<List<RequestWidget>> WIDGETS_FIELD = SdkField
            .<List<RequestWidget>> builder(MarshallingType.LIST)
            .memberName("Widgets")
            .getter(getter(UpdateDashboardRequest::widgets))
            .setter(setter(Builder::widgets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Widgets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RequestWidget> builder(MarshallingType.SDK_POJO)
                                            .constructor(RequestWidget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RefreshSchedule> REFRESH_SCHEDULE_FIELD = SdkField
            .<RefreshSchedule> builder(MarshallingType.SDK_POJO).memberName("RefreshSchedule")
            .getter(getter(UpdateDashboardRequest::refreshSchedule)).setter(setter(Builder::refreshSchedule))
            .constructor(RefreshSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedule").build()).build();

    private static final SdkField<Boolean> TERMINATION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TerminationProtectionEnabled")
            .getter(getter(UpdateDashboardRequest::terminationProtectionEnabled))
            .setter(setter(Builder::terminationProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtectionEnabled")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ID_FIELD,
            WIDGETS_FIELD, REFRESH_SCHEDULE_FIELD, TERMINATION_PROTECTION_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dashboardId;

    private final List<RequestWidget> widgets;

    private final RefreshSchedule refreshSchedule;

    private final Boolean terminationProtectionEnabled;

    private UpdateDashboardRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardId = builder.dashboardId;
        this.widgets = builder.widgets;
        this.refreshSchedule = builder.refreshSchedule;
        this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
    }

    /**
     * <p>
     * The name or ARN of the dashboard.
     * </p>
     * 
     * @return The name or ARN of the dashboard.
     */
    public final String dashboardId() {
        return dashboardId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Widgets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWidgets() {
        return widgets != null && !(widgets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of widgets for the dashboard. A custom dashboard can have a maximum of 10 widgets.
     * </p>
     * <p>
     * To add new widgets, pass in an array that includes the existing widgets along with any new widgets. Run the
     * <code>GetDashboard</code> operation to get the list of widgets for the dashboard.
     * </p>
     * <p>
     * To remove widgets, pass in an array that includes the existing widgets minus the widgets you want removed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWidgets} method.
     * </p>
     * 
     * @return An array of widgets for the dashboard. A custom dashboard can have a maximum of 10 widgets. </p>
     *         <p>
     *         To add new widgets, pass in an array that includes the existing widgets along with any new widgets. Run
     *         the <code>GetDashboard</code> operation to get the list of widgets for the dashboard.
     *         </p>
     *         <p>
     *         To remove widgets, pass in an array that includes the existing widgets minus the widgets you want
     *         removed.
     */
    public final List<RequestWidget> widgets() {
        return widgets;
    }

    /**
     * <p>
     * The refresh schedule configuration for the dashboard.
     * </p>
     * 
     * @return The refresh schedule configuration for the dashboard.
     */
    public final RefreshSchedule refreshSchedule() {
        return refreshSchedule;
    }

    /**
     * <p>
     * Specifies whether termination protection is enabled for the dashboard. If termination protection is enabled, you
     * cannot delete the dashboard until termination protection is disabled.
     * </p>
     * 
     * @return Specifies whether termination protection is enabled for the dashboard. If termination protection is
     *         enabled, you cannot delete the dashboard until termination protection is disabled.
     */
    public final Boolean terminationProtectionEnabled() {
        return terminationProtectionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(hasWidgets() ? widgets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(refreshSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(terminationProtectionEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDashboardRequest)) {
            return false;
        }
        UpdateDashboardRequest other = (UpdateDashboardRequest) obj;
        return Objects.equals(dashboardId(), other.dashboardId()) && hasWidgets() == other.hasWidgets()
                && Objects.equals(widgets(), other.widgets()) && Objects.equals(refreshSchedule(), other.refreshSchedule())
                && Objects.equals(terminationProtectionEnabled(), other.terminationProtectionEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDashboardRequest").add("DashboardId", dashboardId())
                .add("Widgets", hasWidgets() ? widgets() : null).add("RefreshSchedule", refreshSchedule())
                .add("TerminationProtectionEnabled", terminationProtectionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "Widgets":
            return Optional.ofNullable(clazz.cast(widgets()));
        case "RefreshSchedule":
            return Optional.ofNullable(clazz.cast(refreshSchedule()));
        case "TerminationProtectionEnabled":
            return Optional.ofNullable(clazz.cast(terminationProtectionEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DashboardId", DASHBOARD_ID_FIELD);
        map.put("Widgets", WIDGETS_FIELD);
        map.put("RefreshSchedule", REFRESH_SCHEDULE_FIELD);
        map.put("TerminationProtectionEnabled", TERMINATION_PROTECTION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDashboardRequest, T> g) {
        return obj -> g.apply((UpdateDashboardRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDashboardRequest> {
        /**
         * <p>
         * The name or ARN of the dashboard.
         * </p>
         * 
         * @param dashboardId
         *        The name or ARN of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * An array of widgets for the dashboard. A custom dashboard can have a maximum of 10 widgets.
         * </p>
         * <p>
         * To add new widgets, pass in an array that includes the existing widgets along with any new widgets. Run the
         * <code>GetDashboard</code> operation to get the list of widgets for the dashboard.
         * </p>
         * <p>
         * To remove widgets, pass in an array that includes the existing widgets minus the widgets you want removed.
         * </p>
         * 
         * @param widgets
         *        An array of widgets for the dashboard. A custom dashboard can have a maximum of 10 widgets. </p>
         *        <p>
         *        To add new widgets, pass in an array that includes the existing widgets along with any new widgets.
         *        Run the <code>GetDashboard</code> operation to get the list of widgets for the dashboard.
         *        </p>
         *        <p>
         *        To remove widgets, pass in an array that includes the existing widgets minus the widgets you want
         *        removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder widgets(Collection<RequestWidget> widgets);

        /**
         * <p>
         * An array of widgets for the dashboard. A custom dashboard can have a maximum of 10 widgets.
         * </p>
         * <p>
         * To add new widgets, pass in an array that includes the existing widgets along with any new widgets. Run the
         * <code>GetDashboard</code> operation to get the list of widgets for the dashboard.
         * </p>
         * <p>
         * To remove widgets, pass in an array that includes the existing widgets minus the widgets you want removed.
         * </p>
         * 
         * @param widgets
         *        An array of widgets for the dashboard. A custom dashboard can have a maximum of 10 widgets. </p>
         *        <p>
         *        To add new widgets, pass in an array that includes the existing widgets along with any new widgets.
         *        Run the <code>GetDashboard</code> operation to get the list of widgets for the dashboard.
         *        </p>
         *        <p>
         *        To remove widgets, pass in an array that includes the existing widgets minus the widgets you want
         *        removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder widgets(RequestWidget... widgets);

        /**
         * <p>
         * An array of widgets for the dashboard. A custom dashboard can have a maximum of 10 widgets.
         * </p>
         * <p>
         * To add new widgets, pass in an array that includes the existing widgets along with any new widgets. Run the
         * <code>GetDashboard</code> operation to get the list of widgets for the dashboard.
         * </p>
         * <p>
         * To remove widgets, pass in an array that includes the existing widgets minus the widgets you want removed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.RequestWidget.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudtrail.model.RequestWidget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.RequestWidget.Builder#build()} is called immediately
         * and its result is passed to {@link #widgets(List<RequestWidget>)}.
         * 
         * @param widgets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.RequestWidget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #widgets(java.util.Collection<RequestWidget>)
         */
        Builder widgets(Consumer<RequestWidget.Builder>... widgets);

        /**
         * <p>
         * The refresh schedule configuration for the dashboard.
         * </p>
         * 
         * @param refreshSchedule
         *        The refresh schedule configuration for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshSchedule(RefreshSchedule refreshSchedule);

        /**
         * <p>
         * The refresh schedule configuration for the dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link RefreshSchedule.Builder} avoiding the
         * need to create one manually via {@link RefreshSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RefreshSchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #refreshSchedule(RefreshSchedule)}.
         * 
         * @param refreshSchedule
         *        a consumer that will call methods on {@link RefreshSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshSchedule(RefreshSchedule)
         */
        default Builder refreshSchedule(Consumer<RefreshSchedule.Builder> refreshSchedule) {
            return refreshSchedule(RefreshSchedule.builder().applyMutation(refreshSchedule).build());
        }

        /**
         * <p>
         * Specifies whether termination protection is enabled for the dashboard. If termination protection is enabled,
         * you cannot delete the dashboard until termination protection is disabled.
         * </p>
         * 
         * @param terminationProtectionEnabled
         *        Specifies whether termination protection is enabled for the dashboard. If termination protection is
         *        enabled, you cannot delete the dashboard until termination protection is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String dashboardId;

        private List<RequestWidget> widgets = DefaultSdkAutoConstructList.getInstance();

        private RefreshSchedule refreshSchedule;

        private Boolean terminationProtectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDashboardRequest model) {
            super(model);
            dashboardId(model.dashboardId);
            widgets(model.widgets);
            refreshSchedule(model.refreshSchedule);
            terminationProtectionEnabled(model.terminationProtectionEnabled);
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final List<RequestWidget.Builder> getWidgets() {
            List<RequestWidget.Builder> result = RequestWidgetListCopier.copyToBuilder(this.widgets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWidgets(Collection<RequestWidget.BuilderImpl> widgets) {
            this.widgets = RequestWidgetListCopier.copyFromBuilder(widgets);
        }

        @Override
        public final Builder widgets(Collection<RequestWidget> widgets) {
            this.widgets = RequestWidgetListCopier.copy(widgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(RequestWidget... widgets) {
            widgets(Arrays.asList(widgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(Consumer<RequestWidget.Builder>... widgets) {
            widgets(Stream.of(widgets).map(c -> RequestWidget.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final RefreshSchedule.Builder getRefreshSchedule() {
            return refreshSchedule != null ? refreshSchedule.toBuilder() : null;
        }

        public final void setRefreshSchedule(RefreshSchedule.BuilderImpl refreshSchedule) {
            this.refreshSchedule = refreshSchedule != null ? refreshSchedule.build() : null;
        }

        @Override
        public final Builder refreshSchedule(RefreshSchedule refreshSchedule) {
            this.refreshSchedule = refreshSchedule;
            return this;
        }

        public final Boolean getTerminationProtectionEnabled() {
            return terminationProtectionEnabled;
        }

        public final void setTerminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
        }

        @Override
        public final Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDashboardRequest build() {
            return new UpdateDashboardRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
