/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStore;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoresCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEventDataStoresResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, ListEventDataStoresResponse> {
    private static final SdkField<List<EventDataStore>> EVENT_DATA_STORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventDataStores").getter(ListEventDataStoresResponse.getter(ListEventDataStoresResponse::eventDataStores)).setter(ListEventDataStoresResponse.setter(Builder::eventDataStores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventDataStore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEventDataStoresResponse.getter(ListEventDataStoresResponse::nextToken)).setter(ListEventDataStoresResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEventDataStoresResponse.memberNameToFieldInitializer();
    private final List<EventDataStore> eventDataStores;
    private final String nextToken;

    private ListEventDataStoresResponse(BuilderImpl builder) {
        super(builder);
        this.eventDataStores = builder.eventDataStores;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEventDataStores() {
        return this.eventDataStores != null && !(this.eventDataStores instanceof SdkAutoConstructList);
    }

    public final List<EventDataStore> eventDataStores() {
        return this.eventDataStores;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventDataStores() ? this.eventDataStores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventDataStoresResponse)) {
            return false;
        }
        ListEventDataStoresResponse other = (ListEventDataStoresResponse)((Object)obj);
        return this.hasEventDataStores() == other.hasEventDataStores() && Objects.equals(this.eventDataStores(), other.eventDataStores()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEventDataStoresResponse").add("EventDataStores", this.hasEventDataStores() ? this.eventDataStores() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventDataStores": {
                return Optional.ofNullable(clazz.cast(this.eventDataStores()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventDataStores", EVENT_DATA_STORES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEventDataStoresResponse, T> g) {
        return obj -> g.apply((ListEventDataStoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private List<EventDataStore> eventDataStores = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventDataStoresResponse model) {
            super(model);
            this.eventDataStores(model.eventDataStores);
            this.nextToken(model.nextToken);
        }

        public final List<EventDataStore.Builder> getEventDataStores() {
            List<EventDataStore.Builder> result = EventDataStoresCopier.copyToBuilder(this.eventDataStores);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventDataStores(Collection<EventDataStore.BuilderImpl> eventDataStores) {
            this.eventDataStores = EventDataStoresCopier.copyFromBuilder(eventDataStores);
        }

        @Override
        public final Builder eventDataStores(Collection<EventDataStore> eventDataStores) {
            this.eventDataStores = EventDataStoresCopier.copy(eventDataStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDataStores(EventDataStore ... eventDataStores) {
            this.eventDataStores(Arrays.asList(eventDataStores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDataStores(Consumer<EventDataStore.Builder> ... eventDataStores) {
            this.eventDataStores(Stream.of(eventDataStores).map(c -> (EventDataStore)((EventDataStore.Builder)EventDataStore.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEventDataStoresResponse build() {
            return new ListEventDataStoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEventDataStoresResponse> {
        public Builder eventDataStores(Collection<EventDataStore> var1);

        public Builder eventDataStores(EventDataStore ... var1);

        public Builder eventDataStores(Consumer<EventDataStore.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

