/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse;

public class ListEventDataStoresIterable
implements SdkIterable<ListEventDataStoresResponse> {
    private final CloudTrailClient client;
    private final ListEventDataStoresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventDataStoresIterable(CloudTrailClient client, ListEventDataStoresRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEventDataStoresResponseFetcher();
    }

    public Iterator<ListEventDataStoresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListEventDataStoresResponseFetcher
    implements SyncPageFetcher<ListEventDataStoresResponse> {
        private ListEventDataStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListEventDataStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventDataStoresResponse nextPage(ListEventDataStoresResponse previousPage) {
            if (previousPage == null) {
                return ListEventDataStoresIterable.this.client.listEventDataStores(ListEventDataStoresIterable.this.firstRequest);
            }
            return ListEventDataStoresIterable.this.client.listEventDataStores((ListEventDataStoresRequest)((Object)ListEventDataStoresIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

