/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MaxEventSize {
    STANDARD("Standard"),
    LARGE("Large"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MaxEventSize> VALUE_MAP;
    private final String value;

    private MaxEventSize(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MaxEventSize fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MaxEventSize> knownValues() {
        EnumSet<MaxEventSize> knownValues = EnumSet.allOf(MaxEventSize.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MaxEventSize.class, MaxEventSize::toString);
    }
}

